/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.debug.DebugValueSource;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.slf4j.Logger;

public abstract class TileEntity
implements DebugValueSource {
    private static final Codec<TileEntityTypes<?>> TYPE_CODEC = BuiltInRegistries.BLOCK_ENTITY_TYPE.byNameCodec();
    private static final Logger LOGGER = LogUtils.getLogger();
    private final TileEntityTypes<?> type;
    @Nullable
    protected World level;
    protected final BlockPosition worldPosition;
    protected boolean remove;
    private IBlockData blockState;
    private DataComponentMap components = DataComponentMap.EMPTY;

    public TileEntity(TileEntityTypes<?> var0, BlockPosition var1, IBlockData var2) {
        this.type = var0;
        this.worldPosition = var1.immutable();
        this.validateBlockState(var2);
        this.blockState = var2;
    }

    private void validateBlockState(IBlockData var0) {
        if (!this.isValidBlockState(var0)) {
            throw new IllegalStateException("Invalid block entity " + this.getNameForReporting() + " state at " + String.valueOf(this.worldPosition) + ", got " + String.valueOf(var0));
        }
    }

    public boolean isValidBlockState(IBlockData var0) {
        return this.type.isValid(var0);
    }

    public static BlockPosition getPosFromTag(ChunkCoordIntPair var0, NBTTagCompound var1) {
        int var2 = var1.getIntOr("x", 0);
        int var3 = var1.getIntOr("y", 0);
        int var4 = var1.getIntOr("z", 0);
        int var5 = SectionPosition.blockToSectionCoord(var2);
        int var6 = SectionPosition.blockToSectionCoord(var4);
        if (var5 != var0.x || var6 != var0.z) {
            LOGGER.warn("Block entity {} found in a wrong chunk, expected position from chunk {}", (Object)var1, (Object)var0);
            var2 = var0.getBlockX(SectionPosition.sectionRelative(var2));
            var4 = var0.getBlockZ(SectionPosition.sectionRelative(var4));
        }
        return new BlockPosition(var2, var3, var4);
    }

    @Nullable
    public World getLevel() {
        return this.level;
    }

    public void setLevel(World var0) {
        this.level = var0;
    }

    public boolean hasLevel() {
        return this.level != null;
    }

    protected void loadAdditional(ValueInput var0) {
    }

    public final void loadWithComponents(ValueInput var0) {
        this.loadAdditional(var0);
        this.components = var0.read("components", DataComponentMap.CODEC).orElse(DataComponentMap.EMPTY);
    }

    public final void loadCustomOnly(ValueInput var0) {
        this.loadAdditional(var0);
    }

    protected void saveAdditional(ValueOutput var0) {
    }

    public final NBTTagCompound saveWithFullMetadata(HolderLookup.a var0) {
        try (ProblemReporter.j var1 = new ProblemReporter.j(this.problemPath(), LOGGER);){
            TagValueOutput var2 = TagValueOutput.createWithContext(var1, var0);
            this.saveWithFullMetadata(var2);
            NBTTagCompound nBTTagCompound = var2.buildResult();
            return nBTTagCompound;
        }
    }

    public void saveWithFullMetadata(ValueOutput var0) {
        this.saveWithoutMetadata(var0);
        this.saveMetadata(var0);
    }

    public void saveWithId(ValueOutput var0) {
        this.saveWithoutMetadata(var0);
        this.saveId(var0);
    }

    public final NBTTagCompound saveWithoutMetadata(HolderLookup.a var0) {
        try (ProblemReporter.j var1 = new ProblemReporter.j(this.problemPath(), LOGGER);){
            TagValueOutput var2 = TagValueOutput.createWithContext(var1, var0);
            this.saveWithoutMetadata(var2);
            NBTTagCompound nBTTagCompound = var2.buildResult();
            return nBTTagCompound;
        }
    }

    public void saveWithoutMetadata(ValueOutput var0) {
        this.saveAdditional(var0);
        var0.store("components", DataComponentMap.CODEC, this.components);
    }

    public final NBTTagCompound saveCustomOnly(HolderLookup.a var0) {
        try (ProblemReporter.j var1 = new ProblemReporter.j(this.problemPath(), LOGGER);){
            TagValueOutput var2 = TagValueOutput.createWithContext(var1, var0);
            this.saveCustomOnly(var2);
            NBTTagCompound nBTTagCompound = var2.buildResult();
            return nBTTagCompound;
        }
    }

    public void saveCustomOnly(ValueOutput var0) {
        this.saveAdditional(var0);
    }

    private void saveId(ValueOutput var0) {
        TileEntity.addEntityType(var0, this.getType());
    }

    public static void addEntityType(ValueOutput var0, TileEntityTypes<?> var1) {
        var0.store("id", TYPE_CODEC, var1);
    }

    private void saveMetadata(ValueOutput var0) {
        this.saveId(var0);
        var0.putInt("x", this.worldPosition.getX());
        var0.putInt("y", this.worldPosition.getY());
        var0.putInt("z", this.worldPosition.getZ());
    }

    @Nullable
    public static TileEntity loadStatic(BlockPosition var0, IBlockData var1, NBTTagCompound var2, HolderLookup.a var3) {
        Object var5;
        TileEntityTypes var4 = var2.read("id", TYPE_CODEC).orElse(null);
        if (var4 == null) {
            LOGGER.error("Skipping block entity with invalid type: {}", (Object)var2.get("id"));
            return null;
        }
        try {
            var5 = var4.create(var0, var1);
        }
        catch (Throwable var6) {
            LOGGER.error("Failed to create block entity {} for block {} at position {} ", new Object[]{var4, var0, var1, var6});
            return null;
        }
        ProblemReporter.j var6 = new ProblemReporter.j(((TileEntity)var5).problemPath(), LOGGER);
        try {
            ((TileEntity)var5).loadWithComponents(TagValueInput.create((ProblemReporter)var6, var3, var2));
            Object t2 = var5;
            var6.close();
            return t2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    var6.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable var62) {
                LOGGER.error("Failed to load data for block entity {} for block {} at position {}", new Object[]{var4, var0, var1, var62});
                return null;
            }
        }
    }

    public void setChanged() {
        if (this.level != null) {
            TileEntity.setChanged(this.level, this.worldPosition, this.blockState);
        }
    }

    protected static void setChanged(World var0, BlockPosition var1, IBlockData var2) {
        var0.blockEntityChanged(var1);
        if (!var2.isAir()) {
            var0.updateNeighbourForOutputSignal(var1, var2.getBlock());
        }
    }

    public BlockPosition getBlockPos() {
        return this.worldPosition;
    }

    public IBlockData getBlockState() {
        return this.blockState;
    }

    @Nullable
    public Packet<PacketListenerPlayOut> getUpdatePacket() {
        return null;
    }

    public NBTTagCompound getUpdateTag(HolderLookup.a var0) {
        return new NBTTagCompound();
    }

    public boolean isRemoved() {
        return this.remove;
    }

    public void setRemoved() {
        this.remove = true;
    }

    public void clearRemoved() {
        this.remove = false;
    }

    public void preRemoveSideEffects(BlockPosition var0, IBlockData var1) {
        TileEntity tileEntity = this;
        if (tileEntity instanceof IInventory) {
            IInventory var2 = (IInventory)((Object)tileEntity);
            if (this.level != null) {
                InventoryUtils.dropContents(this.level, var0, var2);
            }
        }
    }

    public boolean triggerEvent(int var0, int var1) {
        return false;
    }

    public void fillCrashReportCategory(CrashReportSystemDetails var0) {
        var0.setDetail("Name", this::getNameForReporting);
        var0.setDetail("Cached block", this.getBlockState()::toString);
        if (this.level == null) {
            var0.setDetail("Block location", () -> String.valueOf(this.worldPosition) + " (world missing)");
        } else {
            var0.setDetail("Actual block", this.level.getBlockState(this.worldPosition)::toString);
            CrashReportSystemDetails.populateBlockLocationDetails(var0, this.level, this.worldPosition);
        }
    }

    public String getNameForReporting() {
        return String.valueOf(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(this.getType())) + " // " + this.getClass().getCanonicalName();
    }

    public TileEntityTypes<?> getType() {
        return this.type;
    }

    @Deprecated
    public void setBlockState(IBlockData var0) {
        this.validateBlockState(var0);
        this.blockState = var0;
    }

    protected void applyImplicitComponents(DataComponentGetter var0) {
    }

    public final void applyComponentsFromItemStack(ItemStack var0) {
        this.applyComponents(var0.getPrototype(), var0.getComponentsPatch());
    }

    public final void applyComponents(DataComponentMap var0, DataComponentPatch var1) {
        final HashSet<DataComponentType<TooltipProvider>> var2 = new HashSet<DataComponentType<TooltipProvider>>();
        var2.add(DataComponents.BLOCK_ENTITY_DATA);
        var2.add(DataComponents.BLOCK_STATE);
        final PatchedDataComponentMap var3 = PatchedDataComponentMap.fromPatch(var0, var1);
        this.applyImplicitComponents(new DataComponentGetter(this){

            @Override
            @Nullable
            public <T> T get(DataComponentType<? extends T> var0) {
                var2.add(var0);
                return var3.get(var0);
            }

            @Override
            public <T> T getOrDefault(DataComponentType<? extends T> var0, T var1) {
                var2.add(var0);
                return var3.getOrDefault(var0, var1);
            }
        });
        DataComponentPatch var4 = var1.forget(var2::contains);
        this.components = var4.split().added();
    }

    protected void collectImplicitComponents(DataComponentMap.a var0) {
    }

    @Deprecated
    public void removeComponentsFromTag(ValueOutput var0) {
    }

    public final DataComponentMap collectComponents() {
        DataComponentMap.a var0 = DataComponentMap.builder();
        var0.addAll(this.components);
        this.collectImplicitComponents(var0);
        return var0.build();
    }

    public DataComponentMap components() {
        return this.components;
    }

    public void setComponents(DataComponentMap var0) {
        this.components = var0;
    }

    @Nullable
    public static IChatBaseComponent parseCustomNameSafe(ValueInput var0, String var1) {
        return var0.read(var1, ComponentSerialization.CODEC).orElse(null);
    }

    public ProblemReporter.f problemPath() {
        return new a(this);
    }

    @Override
    public void registerDebugValues(WorldServer var0, DebugValueSource.a var1) {
    }

    record a(TileEntity blockEntity) implements ProblemReporter.f
    {
        @Override
        public String get() {
            return this.blockEntity.getNameForReporting() + "@" + String.valueOf(this.blockEntity.getBlockPos());
        }
    }
}

