/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public abstract class BlockSprawling
extends Block {
    public static final BlockStateBoolean NORTH = BlockProperties.NORTH;
    public static final BlockStateBoolean EAST = BlockProperties.EAST;
    public static final BlockStateBoolean SOUTH = BlockProperties.SOUTH;
    public static final BlockStateBoolean WEST = BlockProperties.WEST;
    public static final BlockStateBoolean UP = BlockProperties.UP;
    public static final BlockStateBoolean DOWN = BlockProperties.DOWN;
    public static final Map<EnumDirection, BlockStateBoolean> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)Maps.newEnumMap(Map.of(EnumDirection.NORTH, NORTH, EnumDirection.EAST, EAST, EnumDirection.SOUTH, SOUTH, EnumDirection.WEST, WEST, EnumDirection.UP, UP, EnumDirection.DOWN, DOWN)));
    private final Function<IBlockData, VoxelShape> shapes;

    protected BlockSprawling(float var0, BlockBase.Info var1) {
        super(var1);
        this.shapes = this.makeShapes(var0);
    }

    protected abstract MapCodec<? extends BlockSprawling> codec();

    private Function<IBlockData, VoxelShape> makeShapes(float var0) {
        VoxelShape var1 = Block.cube(var0);
        Map<EnumDirection, VoxelShape> var22 = VoxelShapes.rotateAll(Block.boxZ(var0, 0.0, 8.0));
        return this.getShapeForEachState(var2 -> {
            VoxelShape var3 = var1;
            for (Map.Entry<EnumDirection, BlockStateBoolean> var5 : PROPERTY_BY_DIRECTION.entrySet()) {
                if (!((Boolean)var2.getValue(var5.getValue())).booleanValue()) continue;
                var3 = VoxelShapes.or((VoxelShape)var22.get(var5.getKey()), var3);
            }
            return var3;
        });
    }

    @Override
    protected boolean propagatesSkylightDown(IBlockData var0) {
        return false;
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.shapes.apply(var0);
    }
}

