/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChorusFruit;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockChorusFlower
extends Block {
    public static final MapCodec<BlockChorusFlower> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("plant").forGetter(var0 -> var0.plant), BlockChorusFlower.propertiesCodec()).apply((Applicative)var02, BlockChorusFlower::new));
    public static final int DEAD_AGE = 5;
    public static final BlockStateInteger AGE = BlockProperties.AGE_5;
    private static final VoxelShape SHAPE_BLOCK_SUPPORT = Block.column(14.0, 0.0, 15.0);
    private final Block plant;

    public MapCodec<BlockChorusFlower> codec() {
        return CODEC;
    }

    protected BlockChorusFlower(Block var0, BlockBase.Info var1) {
        super(var1);
        this.plant = var0;
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(AGE, 0));
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (!var0.canSurvive(var1, var2)) {
            var1.destroyBlock(var2, true);
        }
    }

    @Override
    protected boolean isRandomlyTicking(IBlockData var0) {
        return var0.getValue(AGE) < 5;
    }

    @Override
    public VoxelShape getBlockSupportShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return SHAPE_BLOCK_SUPPORT;
    }

    @Override
    protected void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        int var10;
        int var9;
        BlockPosition var4 = var2.above();
        if (!var1.isEmptyBlock(var4) || var4.getY() > var1.getMaxY()) {
            return;
        }
        int var5 = var0.getValue(AGE);
        if (var5 >= 5) {
            return;
        }
        boolean var6 = false;
        boolean var7 = false;
        IBlockData var8 = var1.getBlockState(var2.below());
        if (var8.is(Blocks.END_STONE)) {
            var6 = true;
        } else if (var8.is(this.plant)) {
            var9 = 1;
            for (var10 = 0; var10 < 4; ++var10) {
                IBlockData var11 = var1.getBlockState(var2.below(var9 + 1));
                if (var11.is(this.plant)) {
                    ++var9;
                    continue;
                }
                if (!var11.is(Blocks.END_STONE)) break;
                var7 = true;
                break;
            }
            if (var9 < 2 || var9 <= var3.nextInt(var7 ? 5 : 4)) {
                var6 = true;
            }
        } else if (var8.isAir()) {
            var6 = true;
        }
        if (var6 && BlockChorusFlower.allNeighborsEmpty(var1, var4, null) && var1.isEmptyBlock(var2.above(2))) {
            var1.setBlock(var2, BlockChorusFruit.getStateWithConnections(var1, var2, this.plant.defaultBlockState()), 2);
            this.placeGrownFlower(var1, var4, var5);
        } else if (var5 < 4) {
            var9 = var3.nextInt(4);
            if (var7) {
                ++var9;
            }
            var10 = 0;
            for (int var11 = 0; var11 < var9; ++var11) {
                EnumDirection var12 = EnumDirection.EnumDirectionLimit.HORIZONTAL.getRandomDirection(var3);
                BlockPosition var13 = var2.relative(var12);
                if (!var1.isEmptyBlock(var13) || !var1.isEmptyBlock(var13.below()) || !BlockChorusFlower.allNeighborsEmpty(var1, var13, var12.getOpposite())) continue;
                this.placeGrownFlower(var1, var13, var5 + 1);
                var10 = 1;
            }
            if (var10 != 0) {
                var1.setBlock(var2, BlockChorusFruit.getStateWithConnections(var1, var2, this.plant.defaultBlockState()), 2);
            } else {
                this.placeDeadFlower(var1, var2);
            }
        } else {
            this.placeDeadFlower(var1, var2);
        }
    }

    private void placeGrownFlower(World var0, BlockPosition var1, int var2) {
        var0.setBlock(var1, (IBlockData)this.defaultBlockState().setValue(AGE, var2), 2);
        var0.levelEvent(1033, var1, 0);
    }

    private void placeDeadFlower(World var0, BlockPosition var1) {
        var0.setBlock(var1, (IBlockData)this.defaultBlockState().setValue(AGE, 5), 2);
        var0.levelEvent(1034, var1, 0);
    }

    private static boolean allNeighborsEmpty(IWorldReader var0, BlockPosition var1, @Nullable EnumDirection var2) {
        for (EnumDirection var4 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            if (var4 == var2 || var0.isEmptyBlock(var1.relative(var4))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var4 != EnumDirection.UP && !var0.canSurvive(var1, var3)) {
            var2.scheduleTick(var3, this, 1);
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        IBlockData var3 = var1.getBlockState(var2.below());
        if (var3.is(this.plant) || var3.is(Blocks.END_STONE)) {
            return true;
        }
        if (!var3.isAir()) {
            return false;
        }
        boolean var4 = false;
        for (EnumDirection var6 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            IBlockData var7 = var1.getBlockState(var2.relative(var6));
            if (var7.is(this.plant)) {
                if (var4) {
                    return false;
                }
                var4 = true;
                continue;
            }
            if (var7.isAir()) continue;
            return false;
        }
        return var4;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(AGE);
    }

    public static void generatePlant(GeneratorAccess var0, BlockPosition var1, RandomSource var2, int var3) {
        var0.setBlock(var1, BlockChorusFruit.getStateWithConnections(var0, var1, Blocks.CHORUS_PLANT.defaultBlockState()), 2);
        BlockChorusFlower.growTreeRecursive(var0, var1, var2, var1, var3, 0);
    }

    private static void growTreeRecursive(GeneratorAccess var0, BlockPosition var1, RandomSource var2, BlockPosition var3, int var4, int var5) {
        int var8;
        Block var6 = Blocks.CHORUS_PLANT;
        int var7 = var2.nextInt(4) + 1;
        if (var5 == 0) {
            ++var7;
        }
        for (var8 = 0; var8 < var7; ++var8) {
            BlockPosition var9 = var1.above(var8 + 1);
            if (!BlockChorusFlower.allNeighborsEmpty(var0, var9, null)) {
                return;
            }
            var0.setBlock(var9, BlockChorusFruit.getStateWithConnections(var0, var9, var6.defaultBlockState()), 2);
            var0.setBlock(var9.below(), BlockChorusFruit.getStateWithConnections(var0, var9.below(), var6.defaultBlockState()), 2);
        }
        var8 = 0;
        if (var5 < 4) {
            int var9 = var2.nextInt(4);
            if (var5 == 0) {
                ++var9;
            }
            for (int var10 = 0; var10 < var9; ++var10) {
                EnumDirection var11 = EnumDirection.EnumDirectionLimit.HORIZONTAL.getRandomDirection(var2);
                BlockPosition var12 = var1.above(var7).relative(var11);
                if (Math.abs(var12.getX() - var3.getX()) >= var4 || Math.abs(var12.getZ() - var3.getZ()) >= var4 || !var0.isEmptyBlock(var12) || !var0.isEmptyBlock(var12.below()) || !BlockChorusFlower.allNeighborsEmpty(var0, var12, var11.getOpposite())) continue;
                var8 = 1;
                var0.setBlock(var12, BlockChorusFruit.getStateWithConnections(var0, var12, var6.defaultBlockState()), 2);
                var0.setBlock(var12.relative(var11.getOpposite()), BlockChorusFruit.getStateWithConnections(var0, var12.relative(var11.getOpposite()), var6.defaultBlockState()), 2);
                BlockChorusFlower.growTreeRecursive(var0, var12, var2, var3, var4, var5 + 1);
            }
        }
        if (var8 == 0) {
            var0.setBlock(var1.above(var7), (IBlockData)Blocks.CHORUS_FLOWER.defaultBlockState().setValue(AGE, 5), 2);
        }
    }

    @Override
    protected void onProjectileHit(World var0, IBlockData var1, MovingObjectPositionBlock var2, IProjectile var3) {
        WorldServer var5;
        BlockPosition var4 = var2.getBlockPos();
        if (var0 instanceof WorldServer && var3.mayInteract(var5 = (WorldServer)var0, var4) && var3.mayBreak(var5)) {
            var0.destroyBlock(var4, true, var3);
        }
    }
}

