/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;

public abstract class CommandBlockListenerAbstract {
    private static final IChatBaseComponent DEFAULT_NAME = IChatBaseComponent.literal("@");
    private static final int NO_LAST_EXECUTION = -1;
    private long lastExecution = -1L;
    private boolean updateLastExecution = true;
    private int successCount;
    private boolean trackOutput = true;
    @Nullable
    IChatBaseComponent lastOutput;
    private String command = "";
    @Nullable
    private IChatBaseComponent customName;

    public int getSuccessCount() {
        return this.successCount;
    }

    public void setSuccessCount(int var0) {
        this.successCount = var0;
    }

    public IChatBaseComponent getLastOutput() {
        return this.lastOutput == null ? CommonComponents.EMPTY : this.lastOutput;
    }

    public void save(ValueOutput var0) {
        var0.putString("Command", this.command);
        var0.putInt("SuccessCount", this.successCount);
        var0.storeNullable("CustomName", ComponentSerialization.CODEC, this.customName);
        var0.putBoolean("TrackOutput", this.trackOutput);
        if (this.trackOutput) {
            var0.storeNullable("LastOutput", ComponentSerialization.CODEC, this.lastOutput);
        }
        var0.putBoolean("UpdateLastExecution", this.updateLastExecution);
        if (this.updateLastExecution && this.lastExecution != -1L) {
            var0.putLong("LastExecution", this.lastExecution);
        }
    }

    public void load(ValueInput var0) {
        this.command = var0.getStringOr("Command", "");
        this.successCount = var0.getIntOr("SuccessCount", 0);
        this.setCustomName(TileEntity.parseCustomNameSafe(var0, "CustomName"));
        this.trackOutput = var0.getBooleanOr("TrackOutput", true);
        this.lastOutput = this.trackOutput ? TileEntity.parseCustomNameSafe(var0, "LastOutput") : null;
        this.updateLastExecution = var0.getBooleanOr("UpdateLastExecution", true);
        this.lastExecution = this.updateLastExecution ? var0.getLongOr("LastExecution", -1L) : -1L;
    }

    public void setCommand(String var0) {
        this.command = var0;
        this.successCount = 0;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean performCommand(World var02) {
        if (var02.isClientSide() || var02.getGameTime() == this.lastExecution) {
            return false;
        }
        if ("Searge".equalsIgnoreCase(this.command)) {
            this.lastOutput = IChatBaseComponent.literal("#itzlipofutzli");
            this.successCount = 1;
            return true;
        }
        this.successCount = 0;
        MinecraftServer var12 = this.getLevel().getServer();
        if (var12.isCommandBlockEnabled() && !UtilColor.isNullOrEmpty(this.command)) {
            try {
                this.lastOutput = null;
                try (CloseableCommandBlockSource var2 = this.createSource();){
                    ICommandListener var3 = Objects.requireNonNullElse(var2, ICommandListener.NULL);
                    CommandListenerWrapper var4 = this.createCommandSourceStack(var3).withCallback((var0, var1) -> {
                        if (var0) {
                            ++this.successCount;
                        }
                    });
                    var12.getCommands().performPrefixedCommand(var4, this.command);
                }
            }
            catch (Throwable var2) {
                CrashReport var3 = CrashReport.forThrowable(var2, "Executing command block");
                CrashReportSystemDetails var4 = var3.addCategory("Command to be executed");
                var4.setDetail("Command", this::getCommand);
                var4.setDetail("Name", () -> this.getName().getString());
                throw new ReportedException(var3);
            }
        }
        this.lastExecution = this.updateLastExecution ? var02.getGameTime() : -1L;
        return true;
    }

    @Nullable
    public CloseableCommandBlockSource createSource() {
        return this.trackOutput ? new CloseableCommandBlockSource() : null;
    }

    public IChatBaseComponent getName() {
        return this.customName != null ? this.customName : DEFAULT_NAME;
    }

    @Nullable
    public IChatBaseComponent getCustomName() {
        return this.customName;
    }

    public void setCustomName(@Nullable IChatBaseComponent var0) {
        this.customName = var0;
    }

    public abstract WorldServer getLevel();

    public abstract void onUpdated();

    public void setLastOutput(@Nullable IChatBaseComponent var0) {
        this.lastOutput = var0;
    }

    public void setTrackOutput(boolean var0) {
        this.trackOutput = var0;
    }

    public boolean isTrackOutput() {
        return this.trackOutput;
    }

    public EnumInteractionResult usedBy(EntityHuman var0) {
        if (!var0.canUseGameMasterBlocks()) {
            return EnumInteractionResult.PASS;
        }
        if (var0.level().isClientSide()) {
            var0.openMinecartCommandBlock(this);
        }
        return EnumInteractionResult.SUCCESS;
    }

    public abstract Vec3D getPosition();

    public abstract CommandListenerWrapper createCommandSourceStack(ICommandListener var1);

    public abstract boolean isValid();

    protected class CloseableCommandBlockSource
    implements ICommandListener,
    AutoCloseable {
        private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss", Locale.ROOT);
        private boolean closed;

        protected CloseableCommandBlockSource() {
        }

        @Override
        public boolean acceptsSuccess() {
            return !this.closed && CommandBlockListenerAbstract.this.getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK);
        }

        @Override
        public boolean acceptsFailure() {
            return !this.closed;
        }

        @Override
        public boolean shouldInformAdmins() {
            return !this.closed && CommandBlockListenerAbstract.this.getLevel().getGameRules().getBoolean(GameRules.RULE_COMMANDBLOCKOUTPUT);
        }

        @Override
        public void sendSystemMessage(IChatBaseComponent var0) {
            if (!this.closed) {
                CommandBlockListenerAbstract.this.lastOutput = IChatBaseComponent.literal("[" + TIME_FORMAT.format(ZonedDateTime.now()) + "] ").append(var0);
                CommandBlockListenerAbstract.this.onUpdated();
            }
        }

        @Override
        public void close() throws Exception {
            this.closed = true;
        }
    }
}

