/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SmithingRecipeDisplay;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.item.equipment.trim.TrimPattern;

public class SmithingTrimRecipe
implements SmithingRecipe {
    final RecipeItemStack template;
    final RecipeItemStack base;
    final RecipeItemStack addition;
    final Holder<TrimPattern> pattern;
    @Nullable
    private PlacementInfo placementInfo;

    public SmithingTrimRecipe(RecipeItemStack var0, RecipeItemStack var1, RecipeItemStack var2, Holder<TrimPattern> var3) {
        this.template = var0;
        this.base = var1;
        this.addition = var2;
        this.pattern = var3;
    }

    @Override
    public ItemStack assemble(SmithingRecipeInput var0, HolderLookup.a var1) {
        return SmithingTrimRecipe.applyTrim(var1, var0.base(), var0.addition(), this.pattern);
    }

    public static ItemStack applyTrim(HolderLookup.a var0, ItemStack var1, ItemStack var2, Holder<TrimPattern> var3) {
        Optional<Holder<TrimMaterial>> var4 = TrimMaterials.getFromIngredient(var0, var2);
        if (var4.isPresent()) {
            ArmorTrim var6;
            ArmorTrim var5 = var1.get(DataComponents.TRIM);
            if (Objects.equals(var5, var6 = new ArmorTrim(var4.get(), var3))) {
                return ItemStack.EMPTY;
            }
            ItemStack var7 = var1.copyWithCount(1);
            var7.set(DataComponents.TRIM, var6);
            return var7;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public Optional<RecipeItemStack> templateIngredient() {
        return Optional.of(this.template);
    }

    @Override
    public RecipeItemStack baseIngredient() {
        return this.base;
    }

    @Override
    public Optional<RecipeItemStack> additionIngredient() {
        return Optional.of(this.addition);
    }

    @Override
    public RecipeSerializer<SmithingTrimRecipe> getSerializer() {
        return RecipeSerializer.SMITHING_TRIM;
    }

    @Override
    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.create(List.of(this.template, this.base, this.addition));
        }
        return this.placementInfo;
    }

    @Override
    public List<RecipeDisplay> display() {
        SlotDisplay var0 = this.base.display();
        SlotDisplay var1 = this.addition.display();
        SlotDisplay var2 = this.template.display();
        return List.of(new SmithingRecipeDisplay(var2, var0, var1, new SlotDisplay.g(var0, var1, this.pattern), new SlotDisplay.d(Items.SMITHING_TABLE)));
    }

    public static class a
    implements RecipeSerializer<SmithingTrimRecipe> {
        private static final MapCodec<SmithingTrimRecipe> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)RecipeItemStack.CODEC.fieldOf("template").forGetter(var0 -> var0.template), (App)RecipeItemStack.CODEC.fieldOf("base").forGetter(var0 -> var0.base), (App)RecipeItemStack.CODEC.fieldOf("addition").forGetter(var0 -> var0.addition), (App)TrimPattern.CODEC.fieldOf("pattern").forGetter(var0 -> var0.pattern)).apply((Applicative)var02, SmithingTrimRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SmithingTrimRecipe> STREAM_CODEC = StreamCodec.composite(RecipeItemStack.CONTENTS_STREAM_CODEC, var0 -> var0.template, RecipeItemStack.CONTENTS_STREAM_CODEC, var0 -> var0.base, RecipeItemStack.CONTENTS_STREAM_CODEC, var0 -> var0.addition, TrimPattern.STREAM_CODEC, var0 -> var0.pattern, SmithingTrimRecipe::new);

        @Override
        public MapCodec<SmithingTrimRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, SmithingTrimRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

