/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;

public abstract class ItemProjectileWeapon
extends Item {
    public static final Predicate<ItemStack> ARROW_ONLY = var0 -> var0.is(TagsItem.ARROWS);
    public static final Predicate<ItemStack> ARROW_OR_FIREWORK = ARROW_ONLY.or(var0 -> var0.is(Items.FIREWORK_ROCKET));

    public ItemProjectileWeapon(Item.Info var0) {
        super(var0);
    }

    public Predicate<ItemStack> getSupportedHeldProjectiles() {
        return this.getAllSupportedProjectiles();
    }

    public abstract Predicate<ItemStack> getAllSupportedProjectiles();

    public static ItemStack getHeldProjectile(EntityLiving var0, Predicate<ItemStack> var1) {
        if (var1.test(var0.getItemInHand(EnumHand.OFF_HAND))) {
            return var0.getItemInHand(EnumHand.OFF_HAND);
        }
        if (var1.test(var0.getItemInHand(EnumHand.MAIN_HAND))) {
            return var0.getItemInHand(EnumHand.MAIN_HAND);
        }
        return ItemStack.EMPTY;
    }

    public abstract int getDefaultProjectileRange();

    protected void shoot(WorldServer var0, EntityLiving var1, EnumHand var2, ItemStack var3, List<ItemStack> var4, float var5, float var62, boolean var7, @Nullable EntityLiving var8) {
        float var9 = EnchantmentManager.processProjectileSpread(var0, var3, var1, 0.0f);
        float var10 = var4.size() == 1 ? 0.0f : 2.0f * var9 / (float)(var4.size() - 1);
        float var11 = (float)((var4.size() - 1) % 2) * var10 / 2.0f;
        float var12 = 1.0f;
        for (int var13 = 0; var13 < var4.size(); ++var13) {
            ItemStack var14 = var4.get(var13);
            if (var14.isEmpty()) continue;
            float var15 = var11 + var12 * (float)((var13 + 1) / 2) * var10;
            var12 = -var12;
            int var16 = var13;
            IProjectile.spawnProjectile(this.createProjectile(var0, var1, var3, var14, var7), var0, var14, var6 -> this.shootProjectile(var1, (IProjectile)var6, var16, var5, var62, var15, var8));
            var3.hurtAndBreak(this.getDurabilityUse(var14), var1, var2.asEquipmentSlot());
            if (var3.isEmpty()) break;
        }
    }

    protected int getDurabilityUse(ItemStack var0) {
        return 1;
    }

    protected abstract void shootProjectile(EntityLiving var1, IProjectile var2, int var3, float var4, float var5, float var6, @Nullable EntityLiving var7);

    protected IProjectile createProjectile(World var0, EntityLiving var1, ItemStack var2, ItemStack var3, boolean var4) {
        ItemArrow itemArrow;
        Object var6;
        Item item = var3.getItem();
        if (item instanceof ItemArrow) {
            var6 = (ItemArrow)item;
            itemArrow = var6;
        } else {
            itemArrow = (ItemArrow)Items.ARROW;
        }
        ItemArrow var5 = itemArrow;
        var6 = var5.createArrow(var0, var3, var1, var2);
        if (var4) {
            ((EntityArrow)var6).setCritArrow(true);
        }
        return var6;
    }

    protected static List<ItemStack> draw(ItemStack var0, ItemStack var1, EntityLiving var2) {
        int n2;
        Object var4;
        if (var1.isEmpty()) {
            return List.of();
        }
        World world = var2.level();
        if (world instanceof WorldServer) {
            var4 = (WorldServer)world;
            n2 = EnchantmentManager.processProjectileCount((WorldServer)var4, var0, var2, 1);
        } else {
            n2 = 1;
        }
        int var3 = n2;
        var4 = new ArrayList(var3);
        ItemStack var5 = var1.copy();
        for (int var6 = 0; var6 < var3; ++var6) {
            ItemStack var7 = ItemProjectileWeapon.useAmmo(var0, var6 == 0 ? var1 : var5, var2, var6 > 0);
            if (var7.isEmpty()) continue;
            var4.add(var7);
        }
        return var4;
    }

    protected static ItemStack useAmmo(ItemStack var0, ItemStack var1, EntityLiving var2, boolean var3) {
        int var4;
        Object var5;
        World world;
        if (!var3 && !var2.hasInfiniteMaterials() && (world = var2.level()) instanceof WorldServer) {
            var5 = (WorldServer)world;
            v0 = EnchantmentManager.processAmmoUse((WorldServer)var5, var0, var1, 1);
        } else {
            v0 = var4 = 0;
        }
        if (var4 > var1.getCount()) {
            return ItemStack.EMPTY;
        }
        if (var4 == 0) {
            var5 = var1.copyWithCount(1);
            ((ItemStack)var5).set(DataComponents.INTANGIBLE_PROJECTILE, Unit.INSTANCE);
            return var5;
        }
        var5 = var1.split(var4);
        if (var1.isEmpty() && var2 instanceof EntityHuman) {
            EntityHuman var6 = (EntityHuman)var2;
            var6.getInventory().removeItem(var1);
        }
        return var5;
    }
}

