/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class ItemMonsterEgg
extends Item {
    private static final Map<EntityTypes<?>, ItemMonsterEgg> BY_ID = Maps.newIdentityHashMap();

    public ItemMonsterEgg(Item.Info var0) {
        super(var0);
        TypedEntityData<EntityTypes<?>> var1 = this.components().get(DataComponents.ENTITY_DATA);
        if (var1 != null) {
            BY_ID.put(var1.type(), this);
        }
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        World var1 = var0.getLevel();
        if (!(var1 instanceof WorldServer)) {
            return EnumInteractionResult.SUCCESS;
        }
        WorldServer var2 = (WorldServer)var1;
        ItemStack var3 = var0.getItemInHand();
        BlockPosition var4 = var0.getClickedPos();
        EnumDirection var5 = var0.getClickedFace();
        IBlockData var6 = var1.getBlockState(var4);
        TileEntity tileEntity = var1.getBlockEntity(var4);
        if (tileEntity instanceof Spawner) {
            Spawner var7 = (Spawner)((Object)tileEntity);
            EntityTypes<?> var8 = this.getType(var3);
            if (var8 == null) {
                return EnumInteractionResult.FAIL;
            }
            if (!var2.getServer().isSpawnerBlockEnabled()) {
                EntityHuman entityHuman = var0.getPlayer();
                if (entityHuman instanceof EntityPlayer) {
                    EntityPlayer var9 = (EntityPlayer)entityHuman;
                    var9.sendSystemMessage(IChatBaseComponent.translatable("advMode.notEnabled.spawner"));
                }
                return EnumInteractionResult.FAIL;
            }
            var7.setEntityId(var8, var1.getRandom());
            var1.sendBlockUpdated(var4, var6, var6, 3);
            var1.gameEvent((Entity)var0.getPlayer(), GameEvent.BLOCK_CHANGE, var4);
            var3.shrink(1);
            return EnumInteractionResult.SUCCESS;
        }
        BlockPosition var7 = var6.getCollisionShape(var1, var4).isEmpty() ? var4 : var4.relative(var5);
        return this.spawnMob(var0.getPlayer(), var3, var1, var7, true, !Objects.equals(var4, var7) && var5 == EnumDirection.UP);
    }

    private EnumInteractionResult spawnMob(@Nullable EntityLiving var0, ItemStack var1, World var2, BlockPosition var3, boolean var4, boolean var5) {
        EntityTypes<?> var6 = this.getType(var1);
        if (var6 == null) {
            return EnumInteractionResult.FAIL;
        }
        if (!var6.isAllowedInPeaceful() && var2.getDifficulty() == EnumDifficulty.PEACEFUL) {
            return EnumInteractionResult.FAIL;
        }
        if (var6.spawn((WorldServer)var2, var1, var0, var3, EntitySpawnReason.SPAWN_ITEM_USE, var4, var5) != null) {
            var1.consume(1, var0);
            var2.gameEvent((Entity)var0, GameEvent.ENTITY_PLACE, var3);
        }
        return EnumInteractionResult.SUCCESS;
    }

    @Override
    public EnumInteractionResult use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        MovingObjectPositionBlock var4 = ItemMonsterEgg.getPlayerPOVHitResult(var0, var1, RayTrace.FluidCollisionOption.SOURCE_ONLY);
        if (var4.getType() != MovingObjectPosition.EnumMovingObjectType.BLOCK) {
            return EnumInteractionResult.PASS;
        }
        if (!(var0 instanceof WorldServer)) {
            return EnumInteractionResult.SUCCESS;
        }
        WorldServer var5 = (WorldServer)var0;
        BlockPosition var6 = var4.getBlockPos();
        if (!(var0.getBlockState(var6).getBlock() instanceof BlockFluids)) {
            return EnumInteractionResult.PASS;
        }
        if (!var0.mayInteract(var1, var6) || !var1.mayUseItemAt(var6, var4.getDirection(), var3)) {
            return EnumInteractionResult.FAIL;
        }
        EnumInteractionResult var7 = this.spawnMob(var1, var3, var0, var6, false, false);
        if (var7 == EnumInteractionResult.SUCCESS) {
            var1.awardStat(StatisticList.ITEM_USED.get(this));
        }
        return var7;
    }

    public boolean spawnsEntity(ItemStack var0, EntityTypes<?> var1) {
        return Objects.equals(this.getType(var0), var1);
    }

    @Nullable
    public static ItemMonsterEgg byId(@Nullable EntityTypes<?> var0) {
        return BY_ID.get(var0);
    }

    public static Iterable<ItemMonsterEgg> eggs() {
        return Iterables.unmodifiableIterable(BY_ID.values());
    }

    @Nullable
    public EntityTypes<?> getType(ItemStack var0) {
        TypedEntityData<EntityTypes<?>> var1 = var0.get(DataComponents.ENTITY_DATA);
        if (var1 != null) {
            return var1.type();
        }
        return null;
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return Optional.ofNullable(this.components().get(DataComponents.ENTITY_DATA)).map(TypedEntityData::type).map(EntityTypes::requiredFeatures).orElseGet(FeatureFlagSet::of);
    }

    public Optional<EntityInsentient> spawnOffspringFromSpawnEgg(EntityHuman var0, EntityInsentient var1, EntityTypes<? extends EntityInsentient> var2, WorldServer var3, Vec3D var4, ItemStack var5) {
        if (!this.spawnsEntity(var5, var2)) {
            return Optional.empty();
        }
        EntityInsentient var6 = var1 instanceof EntityAgeable ? ((EntityAgeable)var1).getBreedOffspring(var3, (EntityAgeable)var1) : var2.create(var3, EntitySpawnReason.SPAWN_ITEM_USE);
        if (var6 == null) {
            return Optional.empty();
        }
        var6.setBaby(true);
        if (!var6.isBaby()) {
            return Optional.empty();
        }
        var6.snapTo(var4.x(), var4.y(), var4.z(), 0.0f, 0.0f);
        var6.applyComponentsFromItemStack(var5);
        var3.addFreshEntityWithPassengers(var6);
        var5.consume(1, var0);
        return Optional.of(var6);
    }

    @Override
    public boolean shouldPrintOpWarning(ItemStack var0, @Nullable EntityHuman var1) {
        TypedEntityData<EntityTypes<?>> var2;
        if (var1 != null && var1.getPermissionLevel() >= 2 && (var2 = var0.get(DataComponents.ENTITY_DATA)) != null) {
            return var2.type().onlyOpCanSetNbt();
        }
        return false;
    }
}

