/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;

public class ItemLeash
extends Item {
    public ItemLeash(Item.Info var0) {
        super(var0);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        BlockPosition var2;
        World var1 = var0.getLevel();
        IBlockData var3 = var1.getBlockState(var2 = var0.getClickedPos());
        if (var3.is(TagsBlock.FENCES)) {
            EntityHuman var4 = var0.getPlayer();
            if (!var1.isClientSide() && var4 != null) {
                return ItemLeash.bindPlayerMobs(var4, var1, var2);
            }
        }
        return EnumInteractionResult.PASS;
    }

    public static EnumInteractionResult bindPlayerMobs(EntityHuman var0, World var12, BlockPosition var2) {
        EntityLeash var3 = null;
        List<Leashable> var4 = Leashable.leashableInArea(var12, Vec3D.atCenterOf(var2), var1 -> var1.getLeashHolder() == var0);
        boolean var5 = false;
        for (Leashable var7 : var4) {
            if (var3 == null) {
                var3 = EntityLeash.getOrCreateKnot(var12, var2);
                var3.playPlacementSound();
            }
            if (!var7.canHaveALeashAttachedTo(var3)) continue;
            var7.setLeashedTo(var3, true);
            var5 = true;
        }
        if (var5) {
            var12.gameEvent(GameEvent.BLOCK_ATTACH, var2, GameEvent.a.of(var0));
            return EnumInteractionResult.SUCCESS_SERVER;
        }
        return EnumInteractionResult.PASS;
    }
}

