/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;

public class ItemCombinerMenuSlotDefinition {
    private final List<b> slots;
    private final b resultSlot;

    ItemCombinerMenuSlotDefinition(List<b> var0, b var1) {
        if (var0.isEmpty() || var1.equals(b.EMPTY)) {
            throw new IllegalArgumentException("Need to define both inputSlots and resultSlot");
        }
        this.slots = var0;
        this.resultSlot = var1;
    }

    public static a create() {
        return new a();
    }

    public b getSlot(int var0) {
        return this.slots.get(var0);
    }

    public b getResultSlot() {
        return this.resultSlot;
    }

    public List<b> getSlots() {
        return this.slots;
    }

    public int getNumOfInputSlots() {
        return this.slots.size();
    }

    public int getResultSlotIndex() {
        return this.getNumOfInputSlots();
    }

    public static final class b
    extends Record {
        final int slotIndex;
        private final int x;
        private final int y;
        private final Predicate<ItemStack> mayPlace;
        static final b EMPTY = new b(0, 0, 0, var0 -> true);

        public b(int var0, int var1, int var2, Predicate<ItemStack> var3) {
            this.slotIndex = var0;
            this.x = var1;
            this.y = var2;
            this.mayPlace = var3;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "slotIndex;x;y;mayPlace", "slotIndex", "x", "y", "mayPlace"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "slotIndex;x;y;mayPlace", "slotIndex", "x", "y", "mayPlace"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "slotIndex;x;y;mayPlace", "slotIndex", "x", "y", "mayPlace"}, this, var0);
        }

        public int slotIndex() {
            return this.slotIndex;
        }

        public int x() {
            return this.x;
        }

        public int y() {
            return this.y;
        }

        public Predicate<ItemStack> mayPlace() {
            return this.mayPlace;
        }
    }

    public static class a {
        private final List<b> inputSlots = new ArrayList<b>();
        private b resultSlot = b.EMPTY;

        public a withSlot(int var0, int var1, int var2, Predicate<ItemStack> var3) {
            this.inputSlots.add(new b(var0, var1, var2, var3));
            return this;
        }

        public a withResultSlot(int var02, int var1, int var2) {
            this.resultSlot = new b(var02, var1, var2, var0 -> false);
            return this;
        }

        public ItemCombinerMenuSlotDefinition build() {
            int var0 = this.inputSlots.size();
            for (int var1 = 0; var1 < var0; ++var1) {
                b var2 = this.inputSlots.get(var1);
                if (var2.slotIndex == var1) continue;
                throw new IllegalArgumentException("Expected input slots to have continous indexes");
            }
            if (this.resultSlot.slotIndex != var0) {
                throw new IllegalArgumentException("Expected result slot index to follow last input slot");
            }
            return new ItemCombinerMenuSlotDefinition(this.inputSlots, this.resultSlot);
        }
    }
}

