/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.windcharge;

import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.SimpleExplosionDamageCalculator;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public abstract class AbstractWindCharge
extends EntityFireball
implements ItemSupplier {
    public static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new SimpleExplosionDamageCalculator(true, false, Optional.empty(), BuiltInRegistries.BLOCK.get(TagsBlock.BLOCKS_WIND_CHARGE_EXPLOSIONS).map(Function.identity()));
    public static final double JUMP_SCALE = 0.25;

    public AbstractWindCharge(EntityTypes<? extends AbstractWindCharge> var0, World var1) {
        super((EntityTypes<? extends EntityFireball>)var0, var1);
        this.accelerationPower = 0.0;
    }

    public AbstractWindCharge(EntityTypes<? extends AbstractWindCharge> var0, World var1, Entity var2, double var3, double var5, double var7) {
        super(var0, var3, var5, var7, var1);
        this.setOwner(var2);
        this.accelerationPower = 0.0;
    }

    AbstractWindCharge(EntityTypes<? extends AbstractWindCharge> var0, double var1, double var3, double var5, Vec3D var7, World var8) {
        super(var0, var1, var3, var5, var7, var8);
        this.accelerationPower = 0.0;
    }

    @Override
    protected AxisAlignedBB makeBoundingBox(Vec3D var0) {
        float var1 = this.getType().getDimensions().width() / 2.0f;
        float var2 = this.getType().getDimensions().height();
        float var3 = 0.15f;
        return new AxisAlignedBB(var0.x - (double)var1, var0.y - (double)0.15f, var0.z - (double)var1, var0.x + (double)var1, var0.y - (double)0.15f + (double)var2, var0.z + (double)var1);
    }

    @Override
    public boolean canCollideWith(Entity var0) {
        if (var0 instanceof AbstractWindCharge) {
            return false;
        }
        return super.canCollideWith(var0);
    }

    @Override
    protected boolean canHitEntity(Entity var0) {
        if (var0 instanceof AbstractWindCharge) {
            return false;
        }
        if (var0.getType() == EntityTypes.END_CRYSTAL) {
            return false;
        }
        return super.canHitEntity(var0);
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        DamageSource var4;
        EntityLiving entityLiving;
        Entity var3;
        super.onHitEntity(var0);
        World world = this.level();
        if (!(world instanceof WorldServer)) {
            return;
        }
        WorldServer var1 = (WorldServer)world;
        Entity entity = this.getOwner();
        if (entity instanceof EntityLiving) {
            var3 = (EntityLiving)entity;
            entityLiving = var3;
        } else {
            entityLiving = null;
        }
        EntityLiving var2 = entityLiving;
        var3 = var0.getEntity();
        if (var2 != null) {
            var2.setLastHurtMob(var3);
        }
        if (var3.hurtServer(var1, var4 = this.damageSources().windCharge(this, var2), 1.0f) && var3 instanceof EntityLiving) {
            EntityLiving var5 = (EntityLiving)var3;
            EnchantmentManager.doPostAttackEffects(var1, var5, var4);
        }
        this.explode(this.position());
    }

    @Override
    public void push(double var0, double var2, double var4) {
    }

    public abstract void explode(Vec3D var1);

    @Override
    protected void onHitBlock(MovingObjectPositionBlock var0) {
        super.onHitBlock(var0);
        if (!this.level().isClientSide()) {
            BaseBlockPosition var1 = var0.getDirection().getUnitVec3i();
            Vec3D var2 = Vec3D.atLowerCornerOf(var1).multiply(0.25, 0.25, 0.25);
            Vec3D var3 = var0.getLocation().add(var2);
            this.explode(var3);
            this.discard();
        }
    }

    @Override
    protected void onHit(MovingObjectPosition var0) {
        super.onHit(var0);
        if (!this.level().isClientSide()) {
            this.discard();
        }
    }

    @Override
    protected boolean shouldBurn() {
        return false;
    }

    @Override
    public ItemStack getItem() {
        return ItemStack.EMPTY;
    }

    @Override
    protected float getInertia() {
        return 1.0f;
    }

    @Override
    protected float getLiquidInertia() {
        return this.getInertia();
    }

    @Override
    @Nullable
    protected ParticleParam getTrailParticle() {
        return null;
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide() && this.getBlockY() > this.level().getMaxY() + 30) {
            this.explode(this.position());
            this.discard();
        } else {
            super.tick();
        }
    }
}

