/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.World;

public class EntityTippedArrow
extends EntityArrow {
    private static final int EXPOSED_POTION_DECAY_TIME = 600;
    private static final int NO_EFFECT_COLOR = -1;
    private static final DataWatcherObject<Integer> ID_EFFECT_COLOR = DataWatcher.defineId(EntityTippedArrow.class, DataWatcherRegistry.INT);
    private static final byte EVENT_POTION_PUFF = 0;

    public EntityTippedArrow(EntityTypes<? extends EntityTippedArrow> var0, World var1) {
        super((EntityTypes<? extends EntityArrow>)var0, var1);
    }

    public EntityTippedArrow(World var0, double var1, double var3, double var5, ItemStack var7, @Nullable ItemStack var8) {
        super(EntityTypes.ARROW, var1, var3, var5, var0, var7, var8);
        this.updateColor();
    }

    public EntityTippedArrow(World var0, EntityLiving var1, ItemStack var2, @Nullable ItemStack var3) {
        super(EntityTypes.ARROW, var1, var0, var2, var3);
        this.updateColor();
    }

    public PotionContents getPotionContents() {
        return this.getPickupItemStackOrigin().getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
    }

    private float getPotionDurationScale() {
        return this.getPickupItemStackOrigin().getOrDefault(DataComponents.POTION_DURATION_SCALE, Float.valueOf(1.0f)).floatValue();
    }

    public void setPotionContents(PotionContents var0) {
        this.getPickupItemStackOrigin().set(DataComponents.POTION_CONTENTS, var0);
        this.updateColor();
    }

    @Override
    protected void setPickupItemStack(ItemStack var0) {
        super.setPickupItemStack(var0);
        this.updateColor();
    }

    public void updateColor() {
        PotionContents var0 = this.getPotionContents();
        this.entityData.set(ID_EFFECT_COLOR, var0.equals(PotionContents.EMPTY) ? -1 : var0.getColor());
    }

    public void addEffect(MobEffect var0) {
        this.setPotionContents(this.getPotionContents().withEffectAdded(var0));
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(ID_EFFECT_COLOR, -1);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            if (this.isInGround()) {
                if (this.inGroundTime % 5 == 0) {
                    this.makeParticle(1);
                }
            } else {
                this.makeParticle(2);
            }
        } else if (this.isInGround() && this.inGroundTime != 0 && !this.getPotionContents().equals(PotionContents.EMPTY) && this.inGroundTime >= 600) {
            this.level().broadcastEntityEvent(this, (byte)0);
            this.setPickupItemStack(new ItemStack(Items.ARROW));
        }
    }

    private void makeParticle(int var0) {
        int var1 = this.getColor();
        if (var1 == -1 || var0 <= 0) {
            return;
        }
        for (int var2 = 0; var2 < var0; ++var2) {
            this.level().addParticle(ColorParticleOption.create(Particles.ENTITY_EFFECT, var1), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
        }
    }

    public int getColor() {
        return this.entityData.get(ID_EFFECT_COLOR);
    }

    @Override
    protected void doPostHurtEffects(EntityLiving var0) {
        super.doPostHurtEffects(var0);
        Entity var1 = this.getEffectSource();
        PotionContents var22 = this.getPotionContents();
        float var3 = this.getPotionDurationScale();
        var22.forEachEffect(var2 -> var0.addEffect((MobEffect)var2, var1), var3);
    }

    @Override
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack(Items.ARROW);
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 0) {
            int var1 = this.getColor();
            if (var1 != -1) {
                float var2 = (float)(var1 >> 16 & 0xFF) / 255.0f;
                float var3 = (float)(var1 >> 8 & 0xFF) / 255.0f;
                float var4 = (float)(var1 >> 0 & 0xFF) / 255.0f;
                for (int var5 = 0; var5 < 20; ++var5) {
                    this.level().addParticle(ColorParticleOption.create(Particles.ENTITY_EFFECT, var2, var3, var4), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
                }
            }
        } else {
            super.handleEntityEvent(var0);
        }
    }
}

