/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntityBlaze;
import net.minecraft.world.entity.projectile.EntityProjectileThrowable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;

public class EntitySnowball
extends EntityProjectileThrowable {
    public EntitySnowball(EntityTypes<? extends EntitySnowball> var0, World var1) {
        super((EntityTypes<? extends EntityProjectileThrowable>)var0, var1);
    }

    public EntitySnowball(World var0, EntityLiving var1, ItemStack var2) {
        super(EntityTypes.SNOWBALL, var1, var0, var2);
    }

    public EntitySnowball(World var0, double var1, double var3, double var5, ItemStack var7) {
        super(EntityTypes.SNOWBALL, var1, var3, var5, var0, var7);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.SNOWBALL;
    }

    private ParticleParam getParticle() {
        ItemStack var0 = this.getItem();
        return var0.isEmpty() ? Particles.ITEM_SNOWBALL : new ParticleParamItem(Particles.ITEM, var0);
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 3) {
            ParticleParam var1 = this.getParticle();
            for (int var2 = 0; var2 < 8; ++var2) {
                this.level().addParticle(var1, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        super.onHitEntity(var0);
        Entity var1 = var0.getEntity();
        int var2 = var1 instanceof EntityBlaze ? 3 : 0;
        var1.hurt(this.damageSources().thrown(this, this.getOwner()), var2);
    }

    @Override
    protected void onHit(MovingObjectPosition var0) {
        super.onHit(var0);
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent(this, (byte)3);
            this.discard();
        }
    }
}

