/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.ClientboundSetPlayerInventoryPacket;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class PlayerInventory
implements IInventory,
INamableTileEntity {
    public static final int POP_TIME_DURATION = 5;
    public static final int INVENTORY_SIZE = 36;
    public static final int SELECTION_SIZE = 9;
    public static final int SLOT_OFFHAND = 40;
    public static final int SLOT_BODY_ARMOR = 41;
    public static final int SLOT_SADDLE = 42;
    public static final int NOT_FOUND_INDEX = -1;
    public static final Int2ObjectMap<EnumItemSlot> EQUIPMENT_SLOT_MAPPING = new Int2ObjectArrayMap(Map.of(EnumItemSlot.FEET.getIndex(36), EnumItemSlot.FEET, EnumItemSlot.LEGS.getIndex(36), EnumItemSlot.LEGS, EnumItemSlot.CHEST.getIndex(36), EnumItemSlot.CHEST, EnumItemSlot.HEAD.getIndex(36), EnumItemSlot.HEAD, 40, EnumItemSlot.OFFHAND, 41, EnumItemSlot.BODY, 42, EnumItemSlot.SADDLE));
    private static final IChatBaseComponent DEFAULT_NAME = IChatBaseComponent.translatable("container.inventory");
    private final NonNullList<ItemStack> items = NonNullList.withSize(36, ItemStack.EMPTY);
    private int selected;
    public final EntityHuman player;
    private final EntityEquipment equipment;
    private int timesChanged;

    public PlayerInventory(EntityHuman var0, EntityEquipment var1) {
        this.player = var0;
        this.equipment = var1;
    }

    public int getSelectedSlot() {
        return this.selected;
    }

    public void setSelectedSlot(int var0) {
        if (!PlayerInventory.isHotbarSlot(var0)) {
            throw new IllegalArgumentException("Invalid selected slot");
        }
        this.selected = var0;
    }

    public ItemStack getSelectedItem() {
        return this.items.get(this.selected);
    }

    public ItemStack setSelectedItem(ItemStack var0) {
        return this.items.set(this.selected, var0);
    }

    public static int getSelectionSize() {
        return 9;
    }

    public NonNullList<ItemStack> getNonEquipmentItems() {
        return this.items;
    }

    private boolean hasRemainingSpaceForItem(ItemStack var0, ItemStack var1) {
        return !var0.isEmpty() && ItemStack.isSameItemSameComponents(var0, var1) && var0.isStackable() && var0.getCount() < this.getMaxStackSize(var0);
    }

    public int getFreeSlot() {
        for (int var0 = 0; var0 < this.items.size(); ++var0) {
            if (!this.items.get(var0).isEmpty()) continue;
            return var0;
        }
        return -1;
    }

    public void addAndPickItem(ItemStack var0) {
        int var1;
        this.setSelectedSlot(this.getSuitableHotbarSlot());
        if (!this.items.get(this.selected).isEmpty() && (var1 = this.getFreeSlot()) != -1) {
            this.items.set(var1, this.items.get(this.selected));
        }
        this.items.set(this.selected, var0);
    }

    public void pickSlot(int var0) {
        this.setSelectedSlot(this.getSuitableHotbarSlot());
        ItemStack var1 = this.items.get(this.selected);
        this.items.set(this.selected, this.items.get(var0));
        this.items.set(var0, var1);
    }

    public static boolean isHotbarSlot(int var0) {
        return var0 >= 0 && var0 < 9;
    }

    public int findSlotMatchingItem(ItemStack var0) {
        for (int var1 = 0; var1 < this.items.size(); ++var1) {
            if (this.items.get(var1).isEmpty() || !ItemStack.isSameItemSameComponents(var0, this.items.get(var1))) continue;
            return var1;
        }
        return -1;
    }

    public static boolean isUsableForCrafting(ItemStack var0) {
        return !var0.isDamaged() && !var0.isEnchanted() && !var0.has(DataComponents.CUSTOM_NAME);
    }

    public int findSlotMatchingCraftingIngredient(Holder<Item> var0, ItemStack var1) {
        for (int var2 = 0; var2 < this.items.size(); ++var2) {
            ItemStack var3 = this.items.get(var2);
            if (var3.isEmpty() || !var3.is(var0) || !PlayerInventory.isUsableForCrafting(var3) || !var1.isEmpty() && !ItemStack.isSameItemSameComponents(var1, var3)) continue;
            return var2;
        }
        return -1;
    }

    public int getSuitableHotbarSlot() {
        int var1;
        int var0;
        for (var0 = 0; var0 < 9; ++var0) {
            var1 = (this.selected + var0) % 9;
            if (!this.items.get(var1).isEmpty()) continue;
            return var1;
        }
        for (var0 = 0; var0 < 9; ++var0) {
            var1 = (this.selected + var0) % 9;
            if (this.items.get(var1).isEnchanted()) continue;
            return var1;
        }
        return this.selected;
    }

    public int clearOrCountMatchingItems(Predicate<ItemStack> var0, int var1, IInventory var2) {
        int var3 = 0;
        boolean var4 = var1 == 0;
        var3 += ContainerUtil.clearOrCountMatchingItems(this, var0, var1 - var3, var4);
        var3 += ContainerUtil.clearOrCountMatchingItems(var2, var0, var1 - var3, var4);
        ItemStack var5 = this.player.containerMenu.getCarried();
        var3 += ContainerUtil.clearOrCountMatchingItems(var5, var0, var1 - var3, var4);
        if (var5.isEmpty()) {
            this.player.containerMenu.setCarried(ItemStack.EMPTY);
        }
        return var3;
    }

    private int addResource(ItemStack var0) {
        int var1 = this.getSlotWithRemainingSpace(var0);
        if (var1 == -1) {
            var1 = this.getFreeSlot();
        }
        if (var1 == -1) {
            return var0.getCount();
        }
        return this.addResource(var1, var0);
    }

    private int addResource(int var0, ItemStack var1) {
        int var4;
        int var5;
        int var2 = var1.getCount();
        ItemStack var3 = this.getItem(var0);
        if (var3.isEmpty()) {
            var3 = var1.copyWithCount(0);
            this.setItem(var0, var3);
        }
        if ((var5 = Math.min(var2, var4 = this.getMaxStackSize(var3) - var3.getCount())) == 0) {
            return var2;
        }
        var3.grow(var5);
        var3.setPopTime(5);
        return var2 -= var5;
    }

    public int getSlotWithRemainingSpace(ItemStack var0) {
        if (this.hasRemainingSpaceForItem(this.getItem(this.selected), var0)) {
            return this.selected;
        }
        if (this.hasRemainingSpaceForItem(this.getItem(40), var0)) {
            return 40;
        }
        for (int var1 = 0; var1 < this.items.size(); ++var1) {
            if (!this.hasRemainingSpaceForItem(this.items.get(var1), var0)) continue;
            return var1;
        }
        return -1;
    }

    public void tick() {
        for (int var0 = 0; var0 < this.items.size(); ++var0) {
            ItemStack var1 = this.getItem(var0);
            if (var1.isEmpty()) continue;
            var1.inventoryTick(this.player.level(), this.player, var0 == this.selected ? EnumItemSlot.MAINHAND : null);
        }
    }

    public boolean add(ItemStack var0) {
        return this.add(-1, var0);
    }

    public boolean add(int var0, ItemStack var1) {
        if (var1.isEmpty()) {
            return false;
        }
        try {
            if (!var1.isDamaged()) {
                int var2;
                do {
                    var2 = var1.getCount();
                    if (var0 == -1) {
                        var1.setCount(this.addResource(var1));
                        continue;
                    }
                    var1.setCount(this.addResource(var0, var1));
                } while (!var1.isEmpty() && var1.getCount() < var2);
                if (var1.getCount() == var2 && this.player.hasInfiniteMaterials()) {
                    var1.setCount(0);
                    return true;
                }
                return var1.getCount() < var2;
            }
            if (var0 == -1) {
                var0 = this.getFreeSlot();
            }
            if (var0 >= 0) {
                this.items.set(var0, var1.copyAndClear());
                this.items.get(var0).setPopTime(5);
                return true;
            }
            if (this.player.hasInfiniteMaterials()) {
                var1.setCount(0);
                return true;
            }
            return false;
        }
        catch (Throwable var2) {
            CrashReport var3 = CrashReport.forThrowable(var2, "Adding item to inventory");
            CrashReportSystemDetails var4 = var3.addCategory("Item being added");
            var4.setDetail("Item ID", Item.getId(var1.getItem()));
            var4.setDetail("Item data", var1.getDamageValue());
            var4.setDetail("Item name", () -> var1.getHoverName().getString());
            throw new ReportedException(var3);
        }
    }

    public void placeItemBackInInventory(ItemStack var0) {
        this.placeItemBackInInventory(var0, true);
    }

    public void placeItemBackInInventory(ItemStack var0, boolean var1) {
        while (!var0.isEmpty()) {
            EntityHuman entityHuman;
            int var2 = this.getSlotWithRemainingSpace(var0);
            if (var2 == -1) {
                var2 = this.getFreeSlot();
            }
            if (var2 == -1) {
                this.player.drop(var0, false);
                break;
            }
            int var3 = var0.getMaxStackSize() - this.getItem(var2).getCount();
            if (!this.add(var2, var0.split(var3)) || !var1 || !((entityHuman = this.player) instanceof EntityPlayer)) continue;
            EntityPlayer var4 = (EntityPlayer)entityHuman;
            var4.connection.send(this.createInventoryUpdatePacket(var2));
        }
    }

    public ClientboundSetPlayerInventoryPacket createInventoryUpdatePacket(int var0) {
        return new ClientboundSetPlayerInventoryPacket(var0, this.getItem(var0).copy());
    }

    @Override
    public ItemStack removeItem(int var0, int var1) {
        ItemStack var3;
        if (var0 < this.items.size()) {
            return ContainerUtil.removeItem(this.items, var0, var1);
        }
        EnumItemSlot var2 = (EnumItemSlot)EQUIPMENT_SLOT_MAPPING.get(var0);
        if (var2 != null && !(var3 = this.equipment.get(var2)).isEmpty()) {
            return var3.split(var1);
        }
        return ItemStack.EMPTY;
    }

    public void removeItem(ItemStack var0) {
        for (int var1 = 0; var1 < this.items.size(); ++var1) {
            if (this.items.get(var1) != var0) continue;
            this.items.set(var1, ItemStack.EMPTY);
            return;
        }
        for (EnumItemSlot var2 : EQUIPMENT_SLOT_MAPPING.values()) {
            ItemStack var3 = this.equipment.get(var2);
            if (var3 != var0) continue;
            this.equipment.set(var2, ItemStack.EMPTY);
            return;
        }
    }

    @Override
    public ItemStack removeItemNoUpdate(int var0) {
        if (var0 < this.items.size()) {
            ItemStack var1 = this.items.get(var0);
            this.items.set(var0, ItemStack.EMPTY);
            return var1;
        }
        EnumItemSlot var1 = (EnumItemSlot)EQUIPMENT_SLOT_MAPPING.get(var0);
        if (var1 != null) {
            return this.equipment.set(var1, ItemStack.EMPTY);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void setItem(int var0, ItemStack var1) {
        EnumItemSlot var2;
        if (var0 < this.items.size()) {
            this.items.set(var0, var1);
        }
        if ((var2 = (EnumItemSlot)EQUIPMENT_SLOT_MAPPING.get(var0)) != null) {
            this.equipment.set(var2, var1);
        }
    }

    public void save(ValueOutput.a<ItemStackWithSlot> var0) {
        for (int var1 = 0; var1 < this.items.size(); ++var1) {
            ItemStack var2 = this.items.get(var1);
            if (var2.isEmpty()) continue;
            var0.add(new ItemStackWithSlot(var1, var2));
        }
    }

    public void load(ValueInput.a<ItemStackWithSlot> var0) {
        this.items.clear();
        for (ItemStackWithSlot var2 : var0) {
            if (!var2.isValidInContainer(this.items.size())) continue;
            this.setItem(var2.slot(), var2.stack());
        }
    }

    @Override
    public int getContainerSize() {
        return this.items.size() + EQUIPMENT_SLOT_MAPPING.size();
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack itemStack : this.items) {
            if (itemStack.isEmpty()) continue;
            return false;
        }
        for (EnumItemSlot enumItemSlot : EQUIPMENT_SLOT_MAPPING.values()) {
            if (this.equipment.get(enumItemSlot).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getItem(int var0) {
        if (var0 < this.items.size()) {
            return this.items.get(var0);
        }
        EnumItemSlot var1 = (EnumItemSlot)EQUIPMENT_SLOT_MAPPING.get(var0);
        if (var1 != null) {
            return this.equipment.get(var1);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public IChatBaseComponent getName() {
        return DEFAULT_NAME;
    }

    public void dropAll() {
        for (int var0 = 0; var0 < this.items.size(); ++var0) {
            ItemStack var1 = this.items.get(var0);
            if (var1.isEmpty()) continue;
            this.player.drop(var1, true, false);
            this.items.set(var0, ItemStack.EMPTY);
        }
        this.equipment.dropAll(this.player);
    }

    @Override
    public void setChanged() {
        ++this.timesChanged;
    }

    public int getTimesChanged() {
        return this.timesChanged;
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return true;
    }

    public boolean contains(ItemStack var0) {
        for (ItemStack var2 : this) {
            if (var2.isEmpty() || !ItemStack.isSameItemSameComponents(var2, var0)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(TagKey<Item> var0) {
        for (ItemStack var2 : this) {
            if (var2.isEmpty() || !var2.is(var0)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Predicate<ItemStack> var0) {
        for (ItemStack var2 : this) {
            if (!var0.test(var2)) continue;
            return true;
        }
        return false;
    }

    public void replaceWith(PlayerInventory var0) {
        for (int var1 = 0; var1 < this.getContainerSize(); ++var1) {
            this.setItem(var1, var0.getItem(var1));
        }
        this.setSelectedSlot(var0.getSelectedSlot());
    }

    @Override
    public void clearContent() {
        this.items.clear();
        this.equipment.clear();
    }

    public void fillStackedContents(StackedItemContents var0) {
        for (ItemStack var2 : this.items) {
            var0.accountSimpleStack(var2);
        }
    }

    public ItemStack removeFromSelected(boolean var0) {
        ItemStack var1 = this.getSelectedItem();
        if (var1.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return this.removeItem(this.selected, var0 ? var1.getCount() : 1);
    }
}

