/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class EntityStrider
extends EntityAnimal
implements ISteerable {
    private static final MinecraftKey SUFFOCATING_MODIFIER_ID = MinecraftKey.withDefaultNamespace("suffocating");
    private static final AttributeModifier SUFFOCATING_MODIFIER = new AttributeModifier(SUFFOCATING_MODIFIER_ID, -0.34f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final float SUFFOCATE_STEERING_MODIFIER = 0.35f;
    private static final float STEERING_MODIFIER = 0.55f;
    private static final DataWatcherObject<Integer> DATA_BOOST_TIME = DataWatcher.defineId(EntityStrider.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Boolean> DATA_SUFFOCATING = DataWatcher.defineId(EntityStrider.class, DataWatcherRegistry.BOOLEAN);
    public final SaddleStorage steering;
    @Nullable
    private PathfinderGoalTempt temptGoal;

    public EntityStrider(EntityTypes<? extends EntityStrider> var0, World var1) {
        super((EntityTypes<? extends EntityAnimal>)var0, var1);
        this.steering = new SaddleStorage(this.entityData, DATA_BOOST_TIME);
        this.blocksBuilding = true;
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.LAVA, 0.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
    }

    public static boolean checkStriderSpawnRules(EntityTypes<EntityStrider> var0, GeneratorAccess var1, EntitySpawnReason var2, BlockPosition var3, RandomSource var4) {
        BlockPosition.MutableBlockPosition var5 = var3.mutable();
        do {
            var5.move(EnumDirection.UP);
        } while (var1.getFluidState(var5).is(TagsFluid.LAVA));
        return var1.getBlockState(var5).isAir();
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (DATA_BOOST_TIME.equals(var0) && this.level().isClientSide()) {
            this.steering.onSynced();
        }
        super.onSyncedDataUpdated(var0);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_BOOST_TIME, 0);
        var0.define(DATA_SUFFOCATING, false);
    }

    @Override
    public boolean canUseSlot(EnumItemSlot var0) {
        if (var0 == EnumItemSlot.SADDLE) {
            return this.isAlive() && !this.isBaby();
        }
        return super.canUseSlot(var0);
    }

    @Override
    protected boolean canDispenserEquipIntoSlot(EnumItemSlot var0) {
        return var0 == EnumItemSlot.SADDLE || super.canDispenserEquipIntoSlot(var0);
    }

    @Override
    protected Holder<SoundEffect> getEquipSound(EnumItemSlot var0, ItemStack var1, Equippable var2) {
        if (var0 == EnumItemSlot.SADDLE) {
            return SoundEffects.STRIDER_SADDLE;
        }
        return super.getEquipSound(var0, var1, var2);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new PathfinderGoalPanic(this, 1.65));
        this.goalSelector.addGoal(2, new PathfinderGoalBreed(this, 1.0));
        this.temptGoal = new PathfinderGoalTempt(this, 1.4, var0 -> var0.is(TagsItem.STRIDER_TEMPT_ITEMS), false);
        this.goalSelector.addGoal(3, this.temptGoal);
        this.goalSelector.addGoal(4, new a(this, 1.0));
        this.goalSelector.addGoal(5, new PathfinderGoalFollowParent(this, 1.0));
        this.goalSelector.addGoal(7, new PathfinderGoalRandomStroll(this, 1.0, 60));
        this.goalSelector.addGoal(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.addGoal(8, new PathfinderGoalRandomLookaround(this));
        this.goalSelector.addGoal(9, new PathfinderGoalLookAtPlayer(this, EntityStrider.class, 8.0f));
    }

    public void setSuffocating(boolean var0) {
        this.entityData.set(DATA_SUFFOCATING, var0);
        AttributeModifiable var1 = this.getAttribute(GenericAttributes.MOVEMENT_SPEED);
        if (var1 != null) {
            if (var0) {
                var1.addOrUpdateTransientModifier(SUFFOCATING_MODIFIER);
            } else {
                var1.removeModifier(SUFFOCATING_MODIFIER_ID);
            }
        }
    }

    public boolean isSuffocating() {
        return this.entityData.get(DATA_SUFFOCATING);
    }

    @Override
    public boolean canStandOnFluid(Fluid var0) {
        return var0.is(TagsFluid.LAVA);
    }

    @Override
    protected Vec3D getPassengerAttachmentPoint(Entity var0, EntitySize var1, float var2) {
        if (!this.level().isClientSide()) {
            return super.getPassengerAttachmentPoint(var0, var1, var2);
        }
        float var3 = Math.min(0.25f, this.walkAnimation.speed());
        float var4 = this.walkAnimation.position();
        float var5 = 0.12f * MathHelper.cos(var4 * 1.5f) * 2.0f * var3;
        return super.getPassengerAttachmentPoint(var0, var1, var2).add(0.0, var5 * var2, 0.0);
    }

    @Override
    public boolean checkSpawnObstruction(IWorldReader var0) {
        return var0.isUnobstructed(this);
    }

    @Override
    @Nullable
    public EntityLiving getControllingPassenger() {
        EntityHuman var0;
        Entity entity;
        if (this.isSaddled() && (entity = this.getFirstPassenger()) instanceof EntityHuman && (var0 = (EntityHuman)entity).isHolding(Items.WARPED_FUNGUS_ON_A_STICK)) {
            return var0;
        }
        return super.getControllingPassenger();
    }

    @Override
    public Vec3D getDismountLocationForPassenger(EntityLiving var0) {
        Vec3D[] var1 = new Vec3D[]{EntityStrider.getCollisionHorizontalEscapeVector(this.getBbWidth(), var0.getBbWidth(), var0.getYRot()), EntityStrider.getCollisionHorizontalEscapeVector(this.getBbWidth(), var0.getBbWidth(), var0.getYRot() - 22.5f), EntityStrider.getCollisionHorizontalEscapeVector(this.getBbWidth(), var0.getBbWidth(), var0.getYRot() + 22.5f), EntityStrider.getCollisionHorizontalEscapeVector(this.getBbWidth(), var0.getBbWidth(), var0.getYRot() - 45.0f), EntityStrider.getCollisionHorizontalEscapeVector(this.getBbWidth(), var0.getBbWidth(), var0.getYRot() + 45.0f)};
        LinkedHashSet var2 = Sets.newLinkedHashSet();
        double var3 = this.getBoundingBox().maxY;
        double var5 = this.getBoundingBox().minY - 0.5;
        BlockPosition.MutableBlockPosition var7 = new BlockPosition.MutableBlockPosition();
        for (Vec3D var11 : var1) {
            var7.set(this.getX() + var11.x, var3, this.getZ() + var11.z);
            for (double var12 = var3; var12 > var5; var12 -= 1.0) {
                var2.add(var7.immutable());
                var7.move(EnumDirection.DOWN);
            }
        }
        for (BlockPosition var9 : var2) {
            double var10;
            if (this.level().getFluidState(var9).is(TagsFluid.LAVA) || !DismountUtil.isBlockFloorValid(var10 = this.level().getBlockFloorHeight(var9))) continue;
            Vec3D var12 = Vec3D.upFromBottomCenterOf(var9, var10);
            for (EntityPose var14 : var0.getDismountPoses()) {
                AxisAlignedBB var15 = var0.getLocalBoundsForPose(var14);
                if (!DismountUtil.canDismountTo(this.level(), var0, var15.move(var12))) continue;
                var0.setPose(var14);
                return var12;
            }
        }
        return new Vec3D(this.getX(), this.getBoundingBox().maxY, this.getZ());
    }

    @Override
    protected void tickRidden(EntityHuman var0, Vec3D var1) {
        this.setRot(var0.getYRot(), var0.getXRot() * 0.5f);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
        this.steering.tickBoost();
        super.tickRidden(var0, var1);
    }

    @Override
    protected Vec3D getRiddenInput(EntityHuman var0, Vec3D var1) {
        return new Vec3D(0.0, 0.0, 1.0);
    }

    @Override
    protected float getRiddenSpeed(EntityHuman var0) {
        return (float)(this.getAttributeValue(GenericAttributes.MOVEMENT_SPEED) * (double)(this.isSuffocating() ? 0.35f : 0.55f) * (double)this.steering.boostFactor());
    }

    @Override
    protected float nextStep() {
        return this.moveDist + 0.6f;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(this.isInLava() ? SoundEffects.STRIDER_STEP_LAVA : SoundEffects.STRIDER_STEP, 1.0f, 1.0f);
    }

    @Override
    public boolean boost() {
        return this.steering.boost(this.getRandom());
    }

    @Override
    protected void checkFallDamage(double var0, boolean var2, IBlockData var3, BlockPosition var4) {
        if (this.isInLava()) {
            this.resetFallDistance();
            return;
        }
        super.checkFallDamage(var0, var2, var3, var4);
    }

    @Override
    public void tick() {
        if (this.isBeingTempted() && this.random.nextInt(140) == 0) {
            this.makeSound(SoundEffects.STRIDER_HAPPY);
        } else if (this.isPanicking() && this.random.nextInt(60) == 0) {
            this.makeSound(SoundEffects.STRIDER_RETREAT);
        }
        if (!this.isNoAi()) {
            EntityStrider var4;
            IBlockData var0 = this.level().getBlockState(this.blockPosition());
            IBlockData var1 = this.getBlockStateOnLegacy();
            boolean var2 = var0.is(TagsBlock.STRIDER_WARM_BLOCKS) || var1.is(TagsBlock.STRIDER_WARM_BLOCKS) || this.getFluidHeight(TagsFluid.LAVA) > 0.0;
            Entity entity = this.getVehicle();
            boolean var3 = entity instanceof EntityStrider && (var4 = (EntityStrider)entity).isSuffocating();
            this.setSuffocating(!var2 || var3);
        }
        super.tick();
        this.floatStrider();
    }

    private boolean isBeingTempted() {
        return this.temptGoal != null && this.temptGoal.isRunning();
    }

    @Override
    protected boolean shouldPassengersInheritMalus() {
        return true;
    }

    private void floatStrider() {
        if (this.isInLava()) {
            VoxelShapeCollision var0 = VoxelShapeCollision.of(this);
            if (!var0.isAbove(BlockFluids.SHAPE_STABLE, this.blockPosition(), true) || this.level().getFluidState(this.blockPosition().above()).is(TagsFluid.LAVA)) {
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5).add(0.0, 0.05, 0.0));
            } else {
                this.setOnGround(true);
            }
        }
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityAnimal.createAnimalAttributes().add(GenericAttributes.MOVEMENT_SPEED, 0.175f);
    }

    @Override
    @Nullable
    protected SoundEffect getAmbientSound() {
        if (this.isPanicking() || this.isBeingTempted()) {
            return null;
        }
        return SoundEffects.STRIDER_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.STRIDER_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.STRIDER_DEATH;
    }

    @Override
    protected boolean canAddPassenger(Entity var0) {
        return !this.isVehicle() && !this.isEyeInFluid(TagsFluid.LAVA);
    }

    @Override
    public boolean isSensitiveToWater() {
        return true;
    }

    @Override
    public boolean isOnFire() {
        return false;
    }

    @Override
    protected NavigationAbstract createNavigation(World var0) {
        return new b(this, var0);
    }

    @Override
    public float getWalkTargetValue(BlockPosition var0, IWorldReader var1) {
        if (var1.getBlockState(var0).getFluidState().is(TagsFluid.LAVA)) {
            return 10.0f;
        }
        return this.isInLava() ? Float.NEGATIVE_INFINITY : 0.0f;
    }

    @Override
    @Nullable
    public EntityStrider getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        return EntityTypes.STRIDER.create(var0, EntitySpawnReason.BREEDING);
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return var0.is(TagsItem.STRIDER_FOOD);
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        boolean var2 = this.isFood(var0.getItemInHand(var1));
        if (!var2 && this.isSaddled() && !this.isVehicle() && !var0.isSecondaryUseActive()) {
            if (!this.level().isClientSide()) {
                var0.startRiding(this);
            }
            return EnumInteractionResult.SUCCESS;
        }
        EnumInteractionResult var3 = super.mobInteract(var0, var1);
        if (!var3.consumesAction()) {
            ItemStack var4 = var0.getItemInHand(var1);
            if (this.isEquippableInSlot(var4, EnumItemSlot.SADDLE)) {
                return var4.interactLivingEntity(var0, this, var1);
            }
            return EnumInteractionResult.PASS;
        }
        if (var2 && !this.isSilent()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEffects.STRIDER_EAT, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        return var3;
    }

    @Override
    public Vec3D getLeashOffset() {
        return new Vec3D(0.0, 0.6f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        if (this.isBaby()) {
            return super.finalizeSpawn(var0, var1, var2, var3);
        }
        RandomSource var4 = var0.getRandom();
        if (var4.nextInt(30) == 0) {
            EntityInsentient var5 = EntityTypes.ZOMBIFIED_PIGLIN.create(var0.getLevel(), EntitySpawnReason.JOCKEY);
            if (var5 != null) {
                var3 = this.spawnJockey(var0, var1, var5, new EntityZombie.GroupDataZombie(EntityZombie.getSpawnAsBabyOdds(var4), false));
                var5.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.WARPED_FUNGUS_ON_A_STICK));
                this.setItemSlot(EnumItemSlot.SADDLE, new ItemStack(Items.SADDLE));
                this.setGuaranteedDrop(EnumItemSlot.SADDLE);
            }
        } else if (var4.nextInt(10) == 0) {
            EntityAgeable var5 = EntityTypes.STRIDER.create(var0.getLevel(), EntitySpawnReason.JOCKEY);
            if (var5 != null) {
                var5.setAge(-24000);
                var3 = this.spawnJockey(var0, var1, var5, null);
            }
        } else {
            var3 = new EntityAgeable.a(0.5f);
        }
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    private GroupDataEntity spawnJockey(WorldAccess var0, DifficultyDamageScaler var1, EntityInsentient var2, @Nullable GroupDataEntity var3) {
        var2.snapTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
        var2.finalizeSpawn(var0, var1, EntitySpawnReason.JOCKEY, var3);
        var2.startRiding(this, true, false);
        return new EntityAgeable.a(0.0f);
    }

    @Override
    @Nullable
    public /* synthetic */ EntityAgeable getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }

    static class a
    extends PathfinderGoalGotoTarget {
        private final EntityStrider strider;

        a(EntityStrider var0, double var1) {
            super(var0, var1, 8, 2);
            this.strider = var0;
        }

        @Override
        public BlockPosition getMoveToTarget() {
            return this.blockPos;
        }

        @Override
        public boolean canContinueToUse() {
            return !this.strider.isInLava() && this.isValidTarget(this.strider.level(), this.blockPos);
        }

        @Override
        public boolean canUse() {
            return !this.strider.isInLava() && super.canUse();
        }

        @Override
        public boolean shouldRecalculatePath() {
            return this.tryTicks % 20 == 0;
        }

        @Override
        protected boolean isValidTarget(IWorldReader var0, BlockPosition var1) {
            return var0.getBlockState(var1).is(Blocks.LAVA) && var0.getBlockState(var1.above()).isPathfindable(PathMode.LAND);
        }
    }

    static class b
    extends Navigation {
        b(EntityStrider var0, World var1) {
            super(var0, var1);
        }

        @Override
        protected Pathfinder createPathFinder(int var0) {
            this.nodeEvaluator = new PathfinderNormal();
            return new Pathfinder(this.nodeEvaluator, var0);
        }

        @Override
        protected boolean hasValidPathType(PathType var0) {
            if (var0 == PathType.LAVA || var0 == PathType.DAMAGE_FIRE || var0 == PathType.DANGER_FIRE) {
                return true;
            }
            return super.hasValidPathType(var0);
        }

        @Override
        public boolean isStableDestination(BlockPosition var0) {
            return this.level.getBlockState(var0).is(Blocks.LAVA) || super.isStableDestination(var0);
        }
    }
}

