/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.BlockAttachedEntity;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDiodeAbstract;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.Validate;

public abstract class EntityHanging
extends BlockAttachedEntity {
    private static final DataWatcherObject<EnumDirection> DATA_DIRECTION = DataWatcher.defineId(EntityHanging.class, DataWatcherRegistry.DIRECTION);
    private static final EnumDirection DEFAULT_DIRECTION = EnumDirection.SOUTH;

    protected EntityHanging(EntityTypes<? extends EntityHanging> var0, World var1) {
        super((EntityTypes<? extends BlockAttachedEntity>)var0, var1);
    }

    protected EntityHanging(EntityTypes<? extends EntityHanging> var0, World var1, BlockPosition var2) {
        this(var0, var1);
        this.pos = var2;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        var0.define(DATA_DIRECTION, DEFAULT_DIRECTION);
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        super.onSyncedDataUpdated(var0);
        if (var0.equals(DATA_DIRECTION)) {
            this.setDirection(this.getDirection());
        }
    }

    @Override
    public EnumDirection getDirection() {
        return this.entityData.get(DATA_DIRECTION);
    }

    protected void setDirectionRaw(EnumDirection var0) {
        this.entityData.set(DATA_DIRECTION, var0);
    }

    public void setDirection(EnumDirection var0) {
        Objects.requireNonNull(var0);
        Validate.isTrue((boolean)var0.getAxis().isHorizontal());
        this.setDirectionRaw(var0);
        this.setYRot(var0.get2DDataValue() * 90);
        this.yRotO = this.getYRot();
        this.recalculateBoundingBox();
    }

    @Override
    protected void recalculateBoundingBox() {
        if (this.getDirection() == null) {
            return;
        }
        AxisAlignedBB var0 = this.calculateBoundingBox(this.pos, this.getDirection());
        Vec3D var1 = var0.getCenter();
        this.setPosRaw(var1.x, var1.y, var1.z);
        this.setBoundingBox(var0);
    }

    protected abstract AxisAlignedBB calculateBoundingBox(BlockPosition var1, EnumDirection var2);

    @Override
    public boolean survives() {
        if (!this.level().noCollision(this, this.getPopBox())) {
            return false;
        }
        boolean var02 = BlockPosition.betweenClosedStream(this.calculateSupportBox()).allMatch(var0 -> {
            IBlockData var1 = this.level().getBlockState((BlockPosition)var0);
            return var1.isSolid() || BlockDiodeAbstract.isDiode(var1);
        });
        return var02 && this.canCoexist(false);
    }

    protected AxisAlignedBB calculateSupportBox() {
        return this.getBoundingBox().move(this.getDirection().step().mul(-0.5f)).deflate(1.0E-7);
    }

    protected boolean canCoexist(boolean var0) {
        Predicate<EntityHanging> var12 = var1 -> {
            boolean var2 = !var0 && var1.getType() == this.getType();
            boolean var3 = var1.getDirection() == this.getDirection();
            return var1 != this && (var2 || var3);
        };
        return !this.level().hasEntities(EntityTypeTest.forClass(EntityHanging.class), this.getPopBox(), var12);
    }

    protected AxisAlignedBB getPopBox() {
        return this.getBoundingBox();
    }

    public abstract void playPlacementSound();

    @Override
    public EntityItem spawnAtLocation(WorldServer var0, ItemStack var1, float var2) {
        EntityItem var3 = new EntityItem(this.level(), this.getX() + (double)((float)this.getDirection().getStepX() * 0.15f), this.getY() + (double)var2, this.getZ() + (double)((float)this.getDirection().getStepZ() * 0.15f), var1);
        var3.setDefaultPickUpDelay();
        this.level().addFreshEntity(var3);
        return var3;
    }

    @Override
    public float rotate(EnumBlockRotation var0) {
        EnumDirection var1 = this.getDirection();
        if (var1.getAxis() != EnumDirection.EnumAxis.Y) {
            switch (var0) {
                case CLOCKWISE_180: {
                    var1 = var1.getOpposite();
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    var1 = var1.getCounterClockWise();
                    break;
                }
                case CLOCKWISE_90: {
                    var1 = var1.getClockWise();
                    break;
                }
            }
            this.setDirection(var1);
        }
        float var2 = MathHelper.wrapDegrees(this.getYRot());
        return switch (var0) {
            case EnumBlockRotation.CLOCKWISE_180 -> var2 + 180.0f;
            case EnumBlockRotation.COUNTERCLOCKWISE_90 -> var2 + 90.0f;
            case EnumBlockRotation.CLOCKWISE_90 -> var2 + 270.0f;
            default -> var2;
        };
    }

    @Override
    public float mirror(EnumBlockMirror var0) {
        return this.rotate(var0.getRotation(this.getDirection()));
    }
}

