/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.EntityFishSchool;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class EntitySalmon
extends EntityFishSchool {
    private static final String TAG_TYPE = "type";
    private static final DataWatcherObject<Integer> DATA_TYPE = DataWatcher.defineId(EntitySalmon.class, DataWatcherRegistry.INT);

    public EntitySalmon(EntityTypes<? extends EntitySalmon> var0, World var1) {
        super((EntityTypes<? extends EntityFishSchool>)var0, var1);
        this.refreshDimensions();
    }

    @Override
    public int getMaxSchoolSize() {
        return 5;
    }

    @Override
    public ItemStack getBucketItemStack() {
        return new ItemStack(Items.SALMON_BUCKET);
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.SALMON_AMBIENT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.SALMON_DEATH;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.SALMON_HURT;
    }

    @Override
    protected SoundEffect getFlopSound() {
        return SoundEffects.SALMON_FLOP;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_TYPE, Variant.DEFAULT.id());
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        super.onSyncedDataUpdated(var0);
        if (DATA_TYPE.equals(var0)) {
            this.refreshDimensions();
        }
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.store(TAG_TYPE, Variant.CODEC, this.getVariant());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.setVariant(var0.read(TAG_TYPE, Variant.CODEC).orElse(Variant.DEFAULT));
    }

    @Override
    public void saveToBucketTag(ItemStack var0) {
        Bucketable.saveDefaultDataToBucketTag(this, var0);
        var0.copyFrom(DataComponents.SALMON_SIZE, this);
    }

    public void setVariant(Variant var0) {
        this.entityData.set(DATA_TYPE, var0.id);
    }

    public Variant getVariant() {
        return Variant.BY_ID.apply(this.entityData.get(DATA_TYPE));
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> var0) {
        if (var0 == DataComponents.SALMON_SIZE) {
            return EntitySalmon.castComponentValue(var0, this.getVariant());
        }
        return super.get(var0);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter var0) {
        this.applyImplicitComponentIfPresent(var0, DataComponents.SALMON_SIZE);
        super.applyImplicitComponents(var0);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> var0, T var1) {
        if (var0 == DataComponents.SALMON_SIZE) {
            this.setVariant(EntitySalmon.castComponentValue(DataComponents.SALMON_SIZE, var1));
            return true;
        }
        return super.applyImplicitComponent(var0, var1);
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        WeightedList.a<Variant> var4 = WeightedList.builder();
        var4.add(Variant.SMALL, 30);
        var4.add(Variant.MEDIUM, 50);
        var4.add(Variant.LARGE, 15);
        var4.build().getRandom(this.random).ifPresent(this::setVariant);
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    public float getSalmonScale() {
        return this.getVariant().boundingBoxScale;
    }

    @Override
    protected EntitySize getDefaultDimensions(EntityPose var0) {
        return super.getDefaultDimensions(var0).scale(this.getSalmonScale());
    }

    public static final class Variant
    extends Enum<Variant>
    implements INamable {
        public static final /* enum */ Variant SMALL = new Variant("small", 0, 0.5f);
        public static final /* enum */ Variant MEDIUM = new Variant("medium", 1, 1.0f);
        public static final /* enum */ Variant LARGE = new Variant("large", 2, 1.5f);
        public static final Variant DEFAULT;
        public static final INamable.a<Variant> CODEC;
        static final IntFunction<Variant> BY_ID;
        public static final StreamCodec<ByteBuf, Variant> STREAM_CODEC;
        private final String name;
        final int id;
        final float boundingBoxScale;
        private static final /* synthetic */ Variant[] k;

        public static Variant[] values() {
            return (Variant[])k.clone();
        }

        public static Variant valueOf(String var0) {
            return Enum.valueOf(Variant.class, var0);
        }

        private Variant(String var2, int var3, float var4) {
            this.name = var2;
            this.id = var3;
            this.boundingBoxScale = var4;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        int id() {
            return this.id;
        }

        private static /* synthetic */ Variant[] b() {
            return new Variant[]{SMALL, MEDIUM, LARGE};
        }

        static {
            k = Variant.b();
            DEFAULT = MEDIUM;
            CODEC = INamable.fromEnum(Variant::values);
            BY_ID = ByIdMap.continuous(Variant::id, Variant.values(), ByIdMap.a.CLAMP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Variant::id);
        }
    }
}

