/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village.poi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.debug.DebugPoiInfo;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import org.slf4j.Logger;

public class VillagePlaceSection {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Short2ObjectMap<VillagePlaceRecord> records = new Short2ObjectOpenHashMap();
    private final Map<Holder<VillagePlaceType>, Set<VillagePlaceRecord>> byType = Maps.newHashMap();
    private final Runnable setDirty;
    private boolean isValid;

    public VillagePlaceSection(Runnable var0) {
        this(var0, true, (List<VillagePlaceRecord>)ImmutableList.of());
    }

    VillagePlaceSection(Runnable var0, boolean var1, List<VillagePlaceRecord> var2) {
        this.setDirty = var0;
        this.isValid = var1;
        var2.forEach(this::add);
    }

    public a pack() {
        return new a(this.isValid, this.records.values().stream().map(VillagePlaceRecord::pack).toList());
    }

    public Stream<VillagePlaceRecord> getRecords(Predicate<Holder<VillagePlaceType>> var02, VillagePlace.Occupancy var12) {
        return this.byType.entrySet().stream().filter(var1 -> var02.test((Holder)var1.getKey())).flatMap(var0 -> ((Set)var0.getValue()).stream()).filter(var12.getTest());
    }

    @Nullable
    public VillagePlaceRecord add(BlockPosition var0, Holder<VillagePlaceType> var1) {
        VillagePlaceRecord var2 = new VillagePlaceRecord(var0, var1, this.setDirty);
        if (this.add(var2)) {
            LOGGER.debug("Added POI of type {} @ {}", (Object)var1.getRegisteredName(), (Object)var0);
            this.setDirty.run();
            return var2;
        }
        return null;
    }

    private boolean add(VillagePlaceRecord var02) {
        BlockPosition var1 = var02.getPos();
        Holder<VillagePlaceType> var2 = var02.getPoiType();
        short var3 = SectionPosition.sectionRelativePos(var1);
        VillagePlaceRecord var4 = (VillagePlaceRecord)this.records.get(var3);
        if (var4 != null) {
            if (var2.equals(var4.getPoiType())) {
                return false;
            }
            SystemUtils.logAndPauseIfInIde("POI data mismatch: already registered at " + String.valueOf(var1));
        }
        this.records.put(var3, (Object)var02);
        this.byType.computeIfAbsent(var2, var0 -> Sets.newHashSet()).add(var02);
        return true;
    }

    public void remove(BlockPosition var0) {
        VillagePlaceRecord var1 = (VillagePlaceRecord)this.records.remove(SectionPosition.sectionRelativePos(var0));
        if (var1 == null) {
            LOGGER.error("POI data mismatch: never registered at {}", (Object)var0);
            return;
        }
        this.byType.get(var1.getPoiType()).remove(var1);
        LOGGER.debug("Removed POI of type {} @ {}", LogUtils.defer(var1::getPoiType), LogUtils.defer(var1::getPos));
        this.setDirty.run();
    }

    @Deprecated
    @VisibleForDebug
    public int getFreeTickets(BlockPosition var0) {
        return this.getPoiRecord(var0).map(VillagePlaceRecord::getFreeTickets).orElse(0);
    }

    public boolean release(BlockPosition var0) {
        VillagePlaceRecord var1 = (VillagePlaceRecord)this.records.get(SectionPosition.sectionRelativePos(var0));
        if (var1 == null) {
            throw SystemUtils.pauseInIde(new IllegalStateException("POI never registered at " + String.valueOf(var0)));
        }
        boolean var2 = var1.releaseTicket();
        this.setDirty.run();
        return var2;
    }

    public boolean exists(BlockPosition var0, Predicate<Holder<VillagePlaceType>> var1) {
        return this.getType(var0).filter(var1).isPresent();
    }

    public Optional<Holder<VillagePlaceType>> getType(BlockPosition var0) {
        return this.getPoiRecord(var0).map(VillagePlaceRecord::getPoiType);
    }

    private Optional<VillagePlaceRecord> getPoiRecord(BlockPosition var0) {
        return Optional.ofNullable((VillagePlaceRecord)this.records.get(SectionPosition.sectionRelativePos(var0)));
    }

    public Optional<DebugPoiInfo> getDebugPoiInfo(BlockPosition var0) {
        return this.getPoiRecord(var0).map(DebugPoiInfo::new);
    }

    public void refresh(Consumer<BiConsumer<BlockPosition, Holder<VillagePlaceType>>> var0) {
        if (!this.isValid) {
            Short2ObjectOpenHashMap var1 = new Short2ObjectOpenHashMap(this.records);
            this.clear();
            var0.accept((arg_0, arg_1) -> this.a((Short2ObjectMap)var1, arg_0, arg_1));
            this.isValid = true;
            this.setDirty.run();
        }
    }

    private void clear() {
        this.records.clear();
        this.byType.clear();
    }

    boolean isValid() {
        return this.isValid;
    }

    private /* synthetic */ void a(Short2ObjectMap var0, BlockPosition var1, Holder var22) {
        short var3 = SectionPosition.sectionRelativePos(var1);
        VillagePlaceRecord var4 = (VillagePlaceRecord)var0.computeIfAbsent(var3, var2 -> new VillagePlaceRecord(var1, var22, this.setDirty));
        this.add(var4);
    }

    public record a(boolean isValid, List<VillagePlaceRecord.a> records) {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.BOOL.lenientOptionalFieldOf("Valid", (Object)false).forGetter(a::isValid), (App)VillagePlaceRecord.a.CODEC.listOf().fieldOf("Records").forGetter(a::records)).apply((Applicative)var0, a::new));

        public VillagePlaceSection unpack(Runnable var0) {
            return new VillagePlaceSection(var0, this.isValid, this.records.stream().map(var1 -> var1.unpack(var0)).toList());
        }
    }
}

