/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village.poi;

import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.LightEngineGraphSection;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.debug.DebugPoiInfo;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceSection;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.RegionFileSection;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;

public class VillagePlace
extends RegionFileSection<VillagePlaceSection, VillagePlaceSection.a> {
    public static final int MAX_VILLAGE_DISTANCE = 6;
    public static final int VILLAGE_SECTION_SIZE = 1;
    private final a distanceTracker;
    private final LongSet loadedChunks = new LongOpenHashSet();

    public VillagePlace(RegionStorageInfo var0, Path var1, DataFixer var2, boolean var3, IRegistryCustom var4, ChunkIOErrorReporter var5, LevelHeightAccessor var6) {
        super(new SimpleRegionStorage(var0, var1, var2, var3, DataFixTypes.POI_CHUNK), VillagePlaceSection.a.CODEC, VillagePlaceSection::pack, VillagePlaceSection.a::unpack, VillagePlaceSection::new, var4, var5, var6);
        this.distanceTracker = new a();
    }

    @Nullable
    public VillagePlaceRecord add(BlockPosition var0, Holder<VillagePlaceType> var1) {
        return ((VillagePlaceSection)this.getOrCreate(SectionPosition.asLong(var0))).add(var0, var1);
    }

    public void remove(BlockPosition var0) {
        this.getOrLoad(SectionPosition.asLong(var0)).ifPresent(var1 -> var1.remove(var0));
    }

    public long getCountInRange(Predicate<Holder<VillagePlaceType>> var0, BlockPosition var1, int var2, Occupancy var3) {
        return this.getInRange(var0, var1, var2, var3).count();
    }

    public boolean existsAtPosition(ResourceKey<VillagePlaceType> var0, BlockPosition var12) {
        return this.exists(var12, var1 -> var1.is(var0));
    }

    public Stream<VillagePlaceRecord> getInSquare(Predicate<Holder<VillagePlaceType>> var0, BlockPosition var1, int var22, Occupancy var3) {
        int var4 = Math.floorDiv(var22, 16) + 1;
        return ChunkCoordIntPair.rangeClosed(new ChunkCoordIntPair(var1), var4).flatMap(var2 -> this.getInChunk(var0, (ChunkCoordIntPair)var2, var3)).filter(var2 -> {
            BlockPosition var3 = var2.getPos();
            return Math.abs(var3.getX() - var1.getX()) <= var22 && Math.abs(var3.getZ() - var1.getZ()) <= var22;
        });
    }

    public Stream<VillagePlaceRecord> getInRange(Predicate<Holder<VillagePlaceType>> var0, BlockPosition var1, int var22, Occupancy var3) {
        int var4 = var22 * var22;
        return this.getInSquare(var0, var1, var22, var3).filter(var2 -> var2.getPos().distSqr(var1) <= (double)var4);
    }

    @VisibleForDebug
    public Stream<VillagePlaceRecord> getInChunk(Predicate<Holder<VillagePlaceType>> var0, ChunkCoordIntPair var12, Occupancy var22) {
        return IntStream.rangeClosed(this.levelHeightAccessor.getMinSectionY(), this.levelHeightAccessor.getMaxSectionY()).boxed().map(var1 -> this.getOrLoad(SectionPosition.of(var12, var1).asLong())).filter(Optional::isPresent).flatMap(var2 -> ((VillagePlaceSection)var2.get()).getRecords(var0, var22));
    }

    public Stream<BlockPosition> findAll(Predicate<Holder<VillagePlaceType>> var0, Predicate<BlockPosition> var1, BlockPosition var2, int var3, Occupancy var4) {
        return this.getInRange(var0, var2, var3, var4).map(VillagePlaceRecord::getPos).filter(var1);
    }

    public Stream<Pair<Holder<VillagePlaceType>, BlockPosition>> findAllWithType(Predicate<Holder<VillagePlaceType>> var02, Predicate<BlockPosition> var12, BlockPosition var2, int var3, Occupancy var4) {
        return this.getInRange(var02, var2, var3, var4).filter(var1 -> var12.test(var1.getPos())).map(var0 -> Pair.of(var0.getPoiType(), (Object)var0.getPos()));
    }

    public Stream<Pair<Holder<VillagePlaceType>, BlockPosition>> findAllClosestFirstWithType(Predicate<Holder<VillagePlaceType>> var0, Predicate<BlockPosition> var12, BlockPosition var2, int var3, Occupancy var4) {
        return this.findAllWithType(var0, var12, var2, var3, var4).sorted(Comparator.comparingDouble(var1 -> ((BlockPosition)var1.getSecond()).distSqr(var2)));
    }

    public Optional<BlockPosition> find(Predicate<Holder<VillagePlaceType>> var0, Predicate<BlockPosition> var1, BlockPosition var2, int var3, Occupancy var4) {
        return this.findAll(var0, var1, var2, var3, var4).findFirst();
    }

    public Optional<BlockPosition> findClosest(Predicate<Holder<VillagePlaceType>> var0, BlockPosition var12, int var2, Occupancy var3) {
        return this.getInRange(var0, var12, var2, var3).map(VillagePlaceRecord::getPos).min(Comparator.comparingDouble(var1 -> var1.distSqr(var12)));
    }

    public Optional<Pair<Holder<VillagePlaceType>, BlockPosition>> findClosestWithType(Predicate<Holder<VillagePlaceType>> var02, BlockPosition var12, int var2, Occupancy var3) {
        return this.getInRange(var02, var12, var2, var3).min(Comparator.comparingDouble(var1 -> var1.getPos().distSqr(var12))).map(var0 -> Pair.of(var0.getPoiType(), (Object)var0.getPos()));
    }

    public Optional<BlockPosition> findClosest(Predicate<Holder<VillagePlaceType>> var0, Predicate<BlockPosition> var12, BlockPosition var2, int var3, Occupancy var4) {
        return this.getInRange(var0, var2, var3, var4).map(VillagePlaceRecord::getPos).filter(var12).min(Comparator.comparingDouble(var1 -> var1.distSqr(var2)));
    }

    public Optional<BlockPosition> take(Predicate<Holder<VillagePlaceType>> var02, BiPredicate<Holder<VillagePlaceType>, BlockPosition> var12, BlockPosition var2, int var3) {
        return this.getInRange(var02, var2, var3, Occupancy.HAS_SPACE).filter(var1 -> var12.test(var1.getPoiType(), var1.getPos())).findFirst().map(var0 -> {
            var0.acquireTicket();
            return var0.getPos();
        });
    }

    public Optional<BlockPosition> getRandom(Predicate<Holder<VillagePlaceType>> var0, Predicate<BlockPosition> var12, Occupancy var2, BlockPosition var3, int var4, RandomSource var5) {
        List<VillagePlaceRecord> var6 = SystemUtils.toShuffledList(this.getInRange(var0, var3, var4, var2), var5);
        return var6.stream().filter(var1 -> var12.test(var1.getPos())).findFirst().map(VillagePlaceRecord::getPos);
    }

    public boolean release(BlockPosition var0) {
        return this.getOrLoad(SectionPosition.asLong(var0)).map(var1 -> var1.release(var0)).orElseThrow(() -> SystemUtils.pauseInIde(new IllegalStateException("POI never registered at " + String.valueOf(var0))));
    }

    public boolean exists(BlockPosition var0, Predicate<Holder<VillagePlaceType>> var1) {
        return this.getOrLoad(SectionPosition.asLong(var0)).map(var2 -> var2.exists(var0, var1)).orElse(false);
    }

    public Optional<Holder<VillagePlaceType>> getType(BlockPosition var0) {
        return this.getOrLoad(SectionPosition.asLong(var0)).flatMap(var1 -> var1.getType(var0));
    }

    @Nullable
    @VisibleForDebug
    public DebugPoiInfo getDebugPoiInfo(BlockPosition var0) {
        return this.getOrLoad(SectionPosition.asLong(var0)).flatMap(var1 -> var1.getDebugPoiInfo(var0)).orElse(null);
    }

    public int sectionsToVillage(SectionPosition var0) {
        this.distanceTracker.runAllUpdates();
        return this.distanceTracker.getLevel(var0.asLong());
    }

    boolean isVillageCenter(long var0) {
        Optional var2 = this.get(var0);
        if (var2 == null) {
            return false;
        }
        return var2.map(var02 -> var02.getRecords(var0 -> var0.is(PoiTypeTags.VILLAGE), Occupancy.IS_OCCUPIED).findAny().isPresent()).orElse(false);
    }

    @Override
    public void tick(BooleanSupplier var0) {
        super.tick(var0);
        this.distanceTracker.runAllUpdates();
    }

    @Override
    protected void setDirty(long var0) {
        super.setDirty(var0);
        this.distanceTracker.update(var0, this.distanceTracker.getLevelFromSource(var0), false);
    }

    @Override
    protected void onSectionLoad(long var0) {
        this.distanceTracker.update(var0, this.distanceTracker.getLevelFromSource(var0), false);
    }

    public void checkConsistencyWithBlocks(SectionPosition var0, ChunkSection var1) {
        SystemUtils.ifElse(this.getOrLoad(var0.asLong()), var22 -> var22.refresh(var2 -> {
            if (VillagePlace.mayHavePoi(var1)) {
                this.updateFromSection(var1, var0, (BiConsumer<BlockPosition, Holder<VillagePlaceType>>)var2);
            }
        }), () -> {
            if (VillagePlace.mayHavePoi(var1)) {
                VillagePlaceSection var2 = (VillagePlaceSection)this.getOrCreate(var0.asLong());
                this.updateFromSection(var1, var0, var2::add);
            }
        });
    }

    private static boolean mayHavePoi(ChunkSection var0) {
        return var0.maybeHas(PoiTypes::hasPoi);
    }

    private void updateFromSection(ChunkSection var0, SectionPosition var1, BiConsumer<BlockPosition, Holder<VillagePlaceType>> var2) {
        var1.blocksInside().forEach(var22 -> {
            IBlockData var3 = var0.getBlockState(SectionPosition.sectionRelative(var22.getX()), SectionPosition.sectionRelative(var22.getY()), SectionPosition.sectionRelative(var22.getZ()));
            PoiTypes.forState(var3).ifPresent(var2 -> var2.accept((BlockPosition)var22, (Holder<VillagePlaceType>)var2));
        });
    }

    public void ensureLoadedAndValid(IWorldReader var02, BlockPosition var12, int var2) {
        SectionPosition.aroundChunk(new ChunkCoordIntPair(var12), Math.floorDiv(var2, 16), this.levelHeightAccessor.getMinSectionY(), this.levelHeightAccessor.getMaxSectionY()).map(var0 -> Pair.of((Object)var0, this.getOrLoad(var0.asLong()))).filter(var0 -> ((Optional)var0.getSecond()).map(VillagePlaceSection::isValid).orElse(false) == false).map(var0 -> ((SectionPosition)var0.getFirst()).chunk()).filter(var0 -> this.loadedChunks.add(var0.toLong())).forEach(var1 -> var02.getChunk(var1.x, var1.z, ChunkStatus.EMPTY));
    }

    final class a
    extends LightEngineGraphSection {
        private final Long2ByteMap levels;

        protected a() {
            super(7, 16, 256);
            this.levels = new Long2ByteOpenHashMap();
            this.levels.defaultReturnValue((byte)7);
        }

        @Override
        protected int getLevelFromSource(long var0) {
            return VillagePlace.this.isVillageCenter(var0) ? 0 : 7;
        }

        @Override
        protected int getLevel(long var0) {
            return this.levels.get(var0);
        }

        @Override
        protected void setLevel(long var0, int var2) {
            if (var2 > 6) {
                this.levels.remove(var0);
            } else {
                this.levels.put(var0, (byte)var2);
            }
        }

        public void runAllUpdates() {
            super.runUpdates(Integer.MAX_VALUE);
        }
    }

    public static final class Occupancy
    extends Enum<Occupancy> {
        public static final /* enum */ Occupancy HAS_SPACE = new Occupancy(VillagePlaceRecord::hasSpace);
        public static final /* enum */ Occupancy IS_OCCUPIED = new Occupancy(VillagePlaceRecord::isOccupied);
        public static final /* enum */ Occupancy ANY = new Occupancy(var0 -> true);
        private final Predicate<? super VillagePlaceRecord> test;
        private static final /* synthetic */ Occupancy[] e;

        public static Occupancy[] values() {
            return (Occupancy[])e.clone();
        }

        public static Occupancy valueOf(String var0) {
            return Enum.valueOf(Occupancy.class, var0);
        }

        private Occupancy(Predicate var2) {
            this.test = var2;
        }

        public Predicate<? super VillagePlaceRecord> getTest() {
            return this.test;
        }

        private static /* synthetic */ Occupancy[] b() {
            return new Occupancy[]{HAS_SPACE, IS_OCCUPIED, ANY};
        }

        static {
            e = Occupancy.b();
        }
    }
}

