/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;

public class EntitySenses {
    private final EntityInsentient mob;
    private final IntSet seen = new IntOpenHashSet();
    private final IntSet unseen = new IntOpenHashSet();

    public EntitySenses(EntityInsentient var0) {
        this.mob = var0;
    }

    public void tick() {
        this.seen.clear();
        this.unseen.clear();
    }

    public boolean hasLineOfSight(Entity var0) {
        int var1 = var0.getId();
        if (this.seen.contains(var1)) {
            return true;
        }
        if (this.unseen.contains(var1)) {
            return false;
        }
        GameProfilerFiller var2 = Profiler.get();
        var2.push("hasLineOfSight");
        boolean var3 = this.mob.hasLineOfSight(var0);
        var2.pop();
        if (var3) {
            this.seen.add(var1);
        } else {
            this.unseen.add(var1);
        }
        return var3;
    }
}

