/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal.target;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.phys.AxisAlignedBB;

public class PathfinderGoalDefendVillage
extends PathfinderGoalTarget {
    private final EntityIronGolem golem;
    @Nullable
    private EntityLiving potentialTarget;
    private final PathfinderTargetCondition attackTargeting = PathfinderTargetCondition.forCombat().range(64.0);

    public PathfinderGoalDefendVillage(EntityIronGolem var0) {
        super(var0, false, true);
        this.golem = var0;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.TARGET));
    }

    @Override
    public boolean canUse() {
        EntityHuman var4;
        AxisAlignedBB var0 = this.golem.getBoundingBox().inflate(10.0, 8.0, 10.0);
        WorldServer var1 = PathfinderGoalDefendVillage.getServerLevel(this.golem);
        List<EntityVillager> var2 = var1.getNearbyEntities(EntityVillager.class, this.attackTargeting, this.golem, var0);
        List<EntityHuman> var3 = var1.getNearbyPlayers(this.attackTargeting, this.golem, var0);
        for (EntityLiving entityLiving : var2) {
            EntityVillager var6 = (EntityVillager)entityLiving;
            for (EntityHuman var8 : var3) {
                int var9 = var6.getPlayerReputation(var8);
                if (var9 > -100) continue;
                this.potentialTarget = var8;
            }
        }
        if (this.potentialTarget == null) {
            return false;
        }
        EntityLiving entityLiving = this.potentialTarget;
        return !(entityLiving instanceof EntityHuman) || !(var4 = (EntityHuman)entityLiving).isSpectator() && !var4.isCreative();
    }

    @Override
    public void start() {
        this.golem.setTarget(this.potentialTarget);
        super.start();
    }
}

