/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.Strictness;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;

public class ChatDeserializer {
    private static final Gson GSON = new GsonBuilder().create();

    public static boolean isStringValue(JsonObject var0, String var1) {
        if (!ChatDeserializer.isValidPrimitive(var0, var1)) {
            return false;
        }
        return var0.getAsJsonPrimitive(var1).isString();
    }

    public static boolean isStringValue(JsonElement var0) {
        if (!var0.isJsonPrimitive()) {
            return false;
        }
        return var0.getAsJsonPrimitive().isString();
    }

    public static boolean isNumberValue(JsonObject var0, String var1) {
        if (!ChatDeserializer.isValidPrimitive(var0, var1)) {
            return false;
        }
        return var0.getAsJsonPrimitive(var1).isNumber();
    }

    public static boolean isNumberValue(JsonElement var0) {
        if (!var0.isJsonPrimitive()) {
            return false;
        }
        return var0.getAsJsonPrimitive().isNumber();
    }

    public static boolean isBooleanValue(JsonObject var0, String var1) {
        if (!ChatDeserializer.isValidPrimitive(var0, var1)) {
            return false;
        }
        return var0.getAsJsonPrimitive(var1).isBoolean();
    }

    public static boolean isBooleanValue(JsonElement var0) {
        if (!var0.isJsonPrimitive()) {
            return false;
        }
        return var0.getAsJsonPrimitive().isBoolean();
    }

    public static boolean isArrayNode(JsonObject var0, String var1) {
        if (!ChatDeserializer.isValidNode(var0, var1)) {
            return false;
        }
        return var0.get(var1).isJsonArray();
    }

    public static boolean isObjectNode(JsonObject var0, String var1) {
        if (!ChatDeserializer.isValidNode(var0, var1)) {
            return false;
        }
        return var0.get(var1).isJsonObject();
    }

    public static boolean isValidPrimitive(JsonObject var0, String var1) {
        if (!ChatDeserializer.isValidNode(var0, var1)) {
            return false;
        }
        return var0.get(var1).isJsonPrimitive();
    }

    public static boolean isValidNode(@Nullable JsonObject var0, String var1) {
        if (var0 == null) {
            return false;
        }
        return var0.get(var1) != null;
    }

    public static JsonElement getNonNull(JsonObject var0, String var1) {
        JsonElement var2 = var0.get(var1);
        if (var2 == null || var2.isJsonNull()) {
            throw new JsonSyntaxException("Missing field " + var1);
        }
        return var2;
    }

    public static String convertToString(JsonElement var0, String var1) {
        if (var0.isJsonPrimitive()) {
            return var0.getAsString();
        }
        throw new JsonSyntaxException("Expected " + var1 + " to be a string, was " + ChatDeserializer.getType(var0));
    }

    public static String getAsString(JsonObject var0, String var1) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToString(var0.get(var1), var1);
        }
        throw new JsonSyntaxException("Missing " + var1 + ", expected to find a string");
    }

    @Nullable
    @Contract(value="_,_,!null->!null;_,_,null->_")
    public static String getAsString(JsonObject var0, String var1, @Nullable String var2) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToString(var0.get(var1), var1);
        }
        return var2;
    }

    public static Holder<Item> convertToItem(JsonElement var0, String var1) {
        if (var0.isJsonPrimitive()) {
            String var2 = var0.getAsString();
            return BuiltInRegistries.ITEM.get(MinecraftKey.parse(var2)).orElseThrow(() -> new JsonSyntaxException("Expected " + var1 + " to be an item, was unknown string '" + var2 + "'"));
        }
        throw new JsonSyntaxException("Expected " + var1 + " to be an item, was " + ChatDeserializer.getType(var0));
    }

    public static Holder<Item> getAsItem(JsonObject var0, String var1) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToItem(var0.get(var1), var1);
        }
        throw new JsonSyntaxException("Missing " + var1 + ", expected to find an item");
    }

    @Nullable
    @Contract(value="_,_,!null->!null;_,_,null->_")
    public static Holder<Item> getAsItem(JsonObject var0, String var1, @Nullable Holder<Item> var2) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToItem(var0.get(var1), var1);
        }
        return var2;
    }

    public static boolean convertToBoolean(JsonElement var0, String var1) {
        if (var0.isJsonPrimitive()) {
            return var0.getAsBoolean();
        }
        throw new JsonSyntaxException("Expected " + var1 + " to be a Boolean, was " + ChatDeserializer.getType(var0));
    }

    public static boolean getAsBoolean(JsonObject var0, String var1) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToBoolean(var0.get(var1), var1);
        }
        throw new JsonSyntaxException("Missing " + var1 + ", expected to find a Boolean");
    }

    public static boolean getAsBoolean(JsonObject var0, String var1, boolean var2) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToBoolean(var0.get(var1), var1);
        }
        return var2;
    }

    public static double convertToDouble(JsonElement var0, String var1) {
        if (var0.isJsonPrimitive() && var0.getAsJsonPrimitive().isNumber()) {
            return var0.getAsDouble();
        }
        throw new JsonSyntaxException("Expected " + var1 + " to be a Double, was " + ChatDeserializer.getType(var0));
    }

    public static double getAsDouble(JsonObject var0, String var1) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToDouble(var0.get(var1), var1);
        }
        throw new JsonSyntaxException("Missing " + var1 + ", expected to find a Double");
    }

    public static double getAsDouble(JsonObject var0, String var1, double var2) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToDouble(var0.get(var1), var1);
        }
        return var2;
    }

    public static float convertToFloat(JsonElement var0, String var1) {
        if (var0.isJsonPrimitive() && var0.getAsJsonPrimitive().isNumber()) {
            return var0.getAsFloat();
        }
        throw new JsonSyntaxException("Expected " + var1 + " to be a Float, was " + ChatDeserializer.getType(var0));
    }

    public static float getAsFloat(JsonObject var0, String var1) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToFloat(var0.get(var1), var1);
        }
        throw new JsonSyntaxException("Missing " + var1 + ", expected to find a Float");
    }

    public static float getAsFloat(JsonObject var0, String var1, float var2) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToFloat(var0.get(var1), var1);
        }
        return var2;
    }

    public static long convertToLong(JsonElement var0, String var1) {
        if (var0.isJsonPrimitive() && var0.getAsJsonPrimitive().isNumber()) {
            return var0.getAsLong();
        }
        throw new JsonSyntaxException("Expected " + var1 + " to be a Long, was " + ChatDeserializer.getType(var0));
    }

    public static long getAsLong(JsonObject var0, String var1) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToLong(var0.get(var1), var1);
        }
        throw new JsonSyntaxException("Missing " + var1 + ", expected to find a Long");
    }

    public static long getAsLong(JsonObject var0, String var1, long var2) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToLong(var0.get(var1), var1);
        }
        return var2;
    }

    public static int convertToInt(JsonElement var0, String var1) {
        if (var0.isJsonPrimitive() && var0.getAsJsonPrimitive().isNumber()) {
            return var0.getAsInt();
        }
        throw new JsonSyntaxException("Expected " + var1 + " to be a Int, was " + ChatDeserializer.getType(var0));
    }

    public static int getAsInt(JsonObject var0, String var1) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToInt(var0.get(var1), var1);
        }
        throw new JsonSyntaxException("Missing " + var1 + ", expected to find a Int");
    }

    public static int getAsInt(JsonObject var0, String var1, int var2) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToInt(var0.get(var1), var1);
        }
        return var2;
    }

    public static byte convertToByte(JsonElement var0, String var1) {
        if (var0.isJsonPrimitive() && var0.getAsJsonPrimitive().isNumber()) {
            return var0.getAsByte();
        }
        throw new JsonSyntaxException("Expected " + var1 + " to be a Byte, was " + ChatDeserializer.getType(var0));
    }

    public static byte getAsByte(JsonObject var0, String var1) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToByte(var0.get(var1), var1);
        }
        throw new JsonSyntaxException("Missing " + var1 + ", expected to find a Byte");
    }

    public static byte getAsByte(JsonObject var0, String var1, byte var2) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToByte(var0.get(var1), var1);
        }
        return var2;
    }

    public static char convertToCharacter(JsonElement var0, String var1) {
        if (var0.isJsonPrimitive() && var0.getAsJsonPrimitive().isNumber()) {
            return var0.getAsCharacter();
        }
        throw new JsonSyntaxException("Expected " + var1 + " to be a Character, was " + ChatDeserializer.getType(var0));
    }

    public static char getAsCharacter(JsonObject var0, String var1) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToCharacter(var0.get(var1), var1);
        }
        throw new JsonSyntaxException("Missing " + var1 + ", expected to find a Character");
    }

    public static char getAsCharacter(JsonObject var0, String var1, char var2) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToCharacter(var0.get(var1), var1);
        }
        return var2;
    }

    public static BigDecimal convertToBigDecimal(JsonElement var0, String var1) {
        if (var0.isJsonPrimitive() && var0.getAsJsonPrimitive().isNumber()) {
            return var0.getAsBigDecimal();
        }
        throw new JsonSyntaxException("Expected " + var1 + " to be a BigDecimal, was " + ChatDeserializer.getType(var0));
    }

    public static BigDecimal getAsBigDecimal(JsonObject var0, String var1) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToBigDecimal(var0.get(var1), var1);
        }
        throw new JsonSyntaxException("Missing " + var1 + ", expected to find a BigDecimal");
    }

    public static BigDecimal getAsBigDecimal(JsonObject var0, String var1, BigDecimal var2) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToBigDecimal(var0.get(var1), var1);
        }
        return var2;
    }

    public static BigInteger convertToBigInteger(JsonElement var0, String var1) {
        if (var0.isJsonPrimitive() && var0.getAsJsonPrimitive().isNumber()) {
            return var0.getAsBigInteger();
        }
        throw new JsonSyntaxException("Expected " + var1 + " to be a BigInteger, was " + ChatDeserializer.getType(var0));
    }

    public static BigInteger getAsBigInteger(JsonObject var0, String var1) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToBigInteger(var0.get(var1), var1);
        }
        throw new JsonSyntaxException("Missing " + var1 + ", expected to find a BigInteger");
    }

    public static BigInteger getAsBigInteger(JsonObject var0, String var1, BigInteger var2) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToBigInteger(var0.get(var1), var1);
        }
        return var2;
    }

    public static short convertToShort(JsonElement var0, String var1) {
        if (var0.isJsonPrimitive() && var0.getAsJsonPrimitive().isNumber()) {
            return var0.getAsShort();
        }
        throw new JsonSyntaxException("Expected " + var1 + " to be a Short, was " + ChatDeserializer.getType(var0));
    }

    public static short getAsShort(JsonObject var0, String var1) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToShort(var0.get(var1), var1);
        }
        throw new JsonSyntaxException("Missing " + var1 + ", expected to find a Short");
    }

    public static short getAsShort(JsonObject var0, String var1, short var2) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToShort(var0.get(var1), var1);
        }
        return var2;
    }

    public static JsonObject convertToJsonObject(JsonElement var0, String var1) {
        if (var0.isJsonObject()) {
            return var0.getAsJsonObject();
        }
        throw new JsonSyntaxException("Expected " + var1 + " to be a JsonObject, was " + ChatDeserializer.getType(var0));
    }

    public static JsonObject getAsJsonObject(JsonObject var0, String var1) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToJsonObject(var0.get(var1), var1);
        }
        throw new JsonSyntaxException("Missing " + var1 + ", expected to find a JsonObject");
    }

    @Nullable
    @Contract(value="_,_,!null->!null;_,_,null->_")
    public static JsonObject getAsJsonObject(JsonObject var0, String var1, @Nullable JsonObject var2) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToJsonObject(var0.get(var1), var1);
        }
        return var2;
    }

    public static JsonArray convertToJsonArray(JsonElement var0, String var1) {
        if (var0.isJsonArray()) {
            return var0.getAsJsonArray();
        }
        throw new JsonSyntaxException("Expected " + var1 + " to be a JsonArray, was " + ChatDeserializer.getType(var0));
    }

    public static JsonArray getAsJsonArray(JsonObject var0, String var1) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToJsonArray(var0.get(var1), var1);
        }
        throw new JsonSyntaxException("Missing " + var1 + ", expected to find a JsonArray");
    }

    @Nullable
    @Contract(value="_,_,!null->!null;_,_,null->_")
    public static JsonArray getAsJsonArray(JsonObject var0, String var1, @Nullable JsonArray var2) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToJsonArray(var0.get(var1), var1);
        }
        return var2;
    }

    public static <T> T convertToObject(@Nullable JsonElement var0, String var1, JsonDeserializationContext var2, Class<? extends T> var3) {
        if (var0 != null) {
            return (T)var2.deserialize(var0, var3);
        }
        throw new JsonSyntaxException("Missing " + var1);
    }

    public static <T> T getAsObject(JsonObject var0, String var1, JsonDeserializationContext var2, Class<? extends T> var3) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToObject(var0.get(var1), var1, var2, var3);
        }
        throw new JsonSyntaxException("Missing " + var1);
    }

    @Nullable
    @Contract(value="_,_,!null,_,_->!null;_,_,null,_,_->_")
    public static <T> T getAsObject(JsonObject var0, String var1, @Nullable T var2, JsonDeserializationContext var3, Class<? extends T> var4) {
        if (var0.has(var1)) {
            return ChatDeserializer.convertToObject(var0.get(var1), var1, var3, var4);
        }
        return var2;
    }

    public static String getType(@Nullable JsonElement var0) {
        String var1 = StringUtils.abbreviateMiddle((String)String.valueOf(var0), (String)"...", (int)10);
        if (var0 == null) {
            return "null (missing)";
        }
        if (var0.isJsonNull()) {
            return "null (json)";
        }
        if (var0.isJsonArray()) {
            return "an array (" + var1 + ")";
        }
        if (var0.isJsonObject()) {
            return "an object (" + var1 + ")";
        }
        if (var0.isJsonPrimitive()) {
            JsonPrimitive var2 = var0.getAsJsonPrimitive();
            if (var2.isNumber()) {
                return "a number (" + var1 + ")";
            }
            if (var2.isBoolean()) {
                return "a boolean (" + var1 + ")";
            }
        }
        return var1;
    }

    public static <T> T fromJson(Gson var0, Reader var1, Class<T> var2) {
        try {
            JsonReader var3 = new JsonReader(var1);
            var3.setStrictness(Strictness.STRICT);
            Object var4 = var0.getAdapter(var2).read(var3);
            if (var4 == null) {
                throw new JsonParseException("JSON data was null or empty");
            }
            return (T)var4;
        }
        catch (IOException var3) {
            throw new JsonParseException((Throwable)var3);
        }
    }

    @Nullable
    public static <T> T fromNullableJson(Gson var0, Reader var1, TypeToken<T> var2) {
        try {
            JsonReader var3 = new JsonReader(var1);
            var3.setStrictness(Strictness.STRICT);
            return (T)var0.getAdapter(var2).read(var3);
        }
        catch (IOException var3) {
            throw new JsonParseException((Throwable)var3);
        }
    }

    public static <T> T fromJson(Gson var0, Reader var1, TypeToken<T> var2) {
        T var3 = ChatDeserializer.fromNullableJson(var0, var1, var2);
        if (var3 == null) {
            throw new JsonParseException("JSON data was null or empty");
        }
        return var3;
    }

    @Nullable
    public static <T> T fromNullableJson(Gson var0, String var1, TypeToken<T> var2) {
        return ChatDeserializer.fromNullableJson(var0, new StringReader(var1), var2);
    }

    public static <T> T fromJson(Gson var0, String var1, Class<T> var2) {
        return ChatDeserializer.fromJson(var0, (Reader)new StringReader(var1), var2);
    }

    public static JsonObject parse(String var0) {
        return ChatDeserializer.parse(new StringReader(var0));
    }

    public static JsonObject parse(Reader var0) {
        return ChatDeserializer.fromJson(GSON, var0, JsonObject.class);
    }

    public static JsonArray parseArray(String var0) {
        return ChatDeserializer.parseArray(new StringReader(var0));
    }

    public static JsonArray parseArray(Reader var0) {
        return ChatDeserializer.fromJson(GSON, var0, JsonArray.class);
    }

    public static String toStableString(JsonElement var0) {
        StringWriter var1 = new StringWriter();
        JsonWriter var2 = new JsonWriter((Writer)var1);
        try {
            ChatDeserializer.writeValue(var2, var0, Comparator.naturalOrder());
        }
        catch (IOException var3) {
            throw new AssertionError((Object)var3);
        }
        return var1.toString();
    }

    public static void writeValue(JsonWriter var0, @Nullable JsonElement var1, @Nullable Comparator<String> var2) throws IOException {
        if (var1 == null || var1.isJsonNull()) {
            var0.nullValue();
        } else if (var1.isJsonPrimitive()) {
            JsonPrimitive var3 = var1.getAsJsonPrimitive();
            if (var3.isNumber()) {
                var0.value(var3.getAsNumber());
            } else if (var3.isBoolean()) {
                var0.value(var3.getAsBoolean());
            } else {
                var0.value(var3.getAsString());
            }
        } else if (var1.isJsonArray()) {
            var0.beginArray();
            for (JsonElement var4 : var1.getAsJsonArray()) {
                ChatDeserializer.writeValue(var0, var4, var2);
            }
            var0.endArray();
        } else if (var1.isJsonObject()) {
            var0.beginObject();
            for (Map.Entry<String, JsonElement> var4 : ChatDeserializer.sortByKeyIfNeeded(var1.getAsJsonObject().entrySet(), var2)) {
                var0.name(var4.getKey());
                ChatDeserializer.writeValue(var0, var4.getValue(), var2);
            }
            var0.endObject();
        } else {
            throw new IllegalArgumentException("Couldn't write " + String.valueOf(var1.getClass()));
        }
    }

    private static Collection<Map.Entry<String, JsonElement>> sortByKeyIfNeeded(Collection<Map.Entry<String, JsonElement>> var0, @Nullable Comparator<String> var1) {
        if (var1 == null) {
            return var0;
        }
        ArrayList<Map.Entry<String, JsonElement>> var2 = new ArrayList<Map.Entry<String, JsonElement>>(var0);
        var2.sort(Map.Entry.comparingByKey(var1));
        return var2;
    }

    public static boolean encodesLongerThan(JsonElement var0, int var1) {
        try {
            Streams.write((JsonElement)var0, (JsonWriter)new JsonWriter(Streams.writerForAppendable((Appendable)new a(var1))));
        }
        catch (IllegalStateException var2) {
            return true;
        }
        catch (IOException var2) {
            throw new UncheckedIOException(var2);
        }
        return false;
    }

    static class a
    implements Appendable {
        private int totalCount;
        private final int limit;

        public a(int var0) {
            this.limit = var0;
        }

        private Appendable accountChars(int var0) {
            this.totalCount += var0;
            if (this.totalCount > this.limit) {
                throw new IllegalStateException("Character count over limit: " + this.totalCount + " > " + this.limit);
            }
            return this;
        }

        @Override
        public Appendable append(CharSequence var0) {
            return this.accountChars(var0.length());
        }

        @Override
        public Appendable append(CharSequence var0, int var1, int var2) {
            return this.accountChars(var2 - var1);
        }

        @Override
        public Appendable append(char var0) {
            return this.accountChars(1);
        }
    }
}

