/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.datafixers.util.Either;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.players.UserNameToIdResolver;
import net.minecraft.util.UtilColor;

public interface ProfileResolver {
    public Optional<GameProfile> fetchByName(String var1);

    public Optional<GameProfile> fetchById(UUID var1);

    default public Optional<GameProfile> fetchByNameOrId(Either<String, UUID> var0) {
        return (Optional)var0.map(this::fetchByName, this::fetchById);
    }

    public static class a
    implements ProfileResolver {
        private final LoadingCache<String, Optional<GameProfile>> profileCacheByName;
        final LoadingCache<UUID, Optional<GameProfile>> profileCacheById;

        public a(final MinecraftSessionService var0, final UserNameToIdResolver var1) {
            this.profileCacheById = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(256L).build((CacheLoader)new CacheLoader<UUID, Optional<GameProfile>>(this){

                public Optional<GameProfile> load(UUID var02) {
                    ProfileResult var1 = var0.fetchProfile(var02, true);
                    return Optional.ofNullable(var1).map(ProfileResult::profile);
                }

                public /* synthetic */ Object load(Object object) throws Exception {
                    return this.load((UUID)object);
                }
            });
            this.profileCacheByName = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(256L).build((CacheLoader)new CacheLoader<String, Optional<GameProfile>>(){

                public Optional<GameProfile> load(String var02) {
                    return var1.get(var02).flatMap(var0 -> (Optional)profileCacheById.getUnchecked((Object)var0.id()));
                }

                public /* synthetic */ Object load(Object object) throws Exception {
                    return this.load((String)object);
                }
            });
        }

        @Override
        public Optional<GameProfile> fetchByName(String var0) {
            if (UtilColor.isValidPlayerName(var0)) {
                return (Optional)this.profileCacheByName.getUnchecked((Object)var0);
            }
            return Optional.empty();
        }

        @Override
        public Optional<GameProfile> fetchById(UUID var0) {
            return (Optional)this.profileCacheById.getUnchecked((Object)var0);
        }
    }
}

