/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.server.level.ChunkTaskQueue;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.util.Unit;
import net.minecraft.util.thread.PairedQueue;
import net.minecraft.util.thread.PriorityConsecutiveExecutor;
import net.minecraft.util.thread.TaskScheduler;
import net.minecraft.world.level.ChunkCoordIntPair;
import org.slf4j.Logger;

public class ChunkTaskDispatcher
implements PlayerChunk.a,
AutoCloseable {
    public static final int DISPATCHER_PRIORITY_COUNT = 4;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ChunkTaskQueue queue;
    private final TaskScheduler<Runnable> executor;
    private final PriorityConsecutiveExecutor dispatcher;
    protected boolean sleeping;

    public ChunkTaskDispatcher(TaskScheduler<Runnable> var0, Executor var1) {
        this.queue = new ChunkTaskQueue(var0.name() + "_queue");
        this.executor = var0;
        this.dispatcher = new PriorityConsecutiveExecutor(4, var1, "dispatcher");
        this.sleeping = true;
    }

    public boolean hasWork() {
        return this.dispatcher.hasWork() || this.queue.hasWork();
    }

    @Override
    public void onLevelChange(ChunkCoordIntPair var0, IntSupplier var1, int var2, IntConsumer var3) {
        this.dispatcher.schedule(new PairedQueue.c(0, () -> {
            int var4 = var1.getAsInt();
            if (SharedConstants.DEBUG_VERBOSE_SERVER_EVENTS) {
                LOGGER.debug("RES {} {} -> {}", new Object[]{var0, var4, var2});
            }
            this.queue.resortChunkTasks(var4, var0, var2);
            var3.accept(var2);
        }));
    }

    public void release(long var0, Runnable var2, boolean var3) {
        this.dispatcher.schedule(new PairedQueue.c(1, () -> {
            this.queue.release(var0, var3);
            this.onRelease(var0);
            if (this.sleeping) {
                this.sleeping = false;
                this.pollTask();
            }
            var2.run();
        }));
    }

    public void submit(Runnable var0, long var1, IntSupplier var3) {
        this.dispatcher.schedule(new PairedQueue.c(2, () -> {
            int var4 = var3.getAsInt();
            if (SharedConstants.DEBUG_VERBOSE_SERVER_EVENTS) {
                LOGGER.debug("SUB {} {} {} {}", new Object[]{new ChunkCoordIntPair(var1), var4, this.executor, this.queue});
            }
            this.queue.submit(var0, var1, var4);
            if (this.sleeping) {
                this.sleeping = false;
                this.pollTask();
            }
        }));
    }

    protected void pollTask() {
        this.dispatcher.schedule(new PairedQueue.c(3, () -> {
            ChunkTaskQueue.a var0 = this.popTasks();
            if (var0 == null) {
                this.sleeping = true;
            } else {
                this.scheduleForExecution(var0);
            }
        }));
    }

    protected void scheduleForExecution(ChunkTaskQueue.a var02) {
        CompletableFuture.allOf((CompletableFuture[])var02.tasks().stream().map(var0 -> this.executor.scheduleWithResult(var1 -> {
            var0.run();
            var1.complete(Unit.INSTANCE);
        })).toArray(CompletableFuture[]::new)).thenAccept(var0 -> this.pollTask());
    }

    protected void onRelease(long var0) {
    }

    @Nullable
    protected ChunkTaskQueue.a popTasks() {
        return this.queue.pop();
    }

    @Override
    public void close() {
        this.executor.close();
    }
}

