/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.server.jsonrpc.api.ReferenceUtil;
import net.minecraft.server.jsonrpc.api.SchemaComponent;
import net.minecraft.server.jsonrpc.methods.GameRulesService;
import net.minecraft.util.INamable;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.level.EnumGamemode;

public record Schema(Optional<URI> reference, Optional<String> type, Optional<Schema> items, Optional<Map<String, Schema>> properties, Optional<List<String>> enumValues) {
    public static final Codec<Schema> CODEC = Codec.recursive((String)"Schema", var0 -> RecordCodecBuilder.create(var1 -> var1.group((App)ReferenceUtil.REFERENCE_CODEC.optionalFieldOf("$ref").forGetter(Schema::reference), (App)Codec.STRING.optionalFieldOf("type").forGetter(Schema::type), (App)var0.optionalFieldOf("items").forGetter(Schema::items), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)var0).optionalFieldOf("properties").forGetter(Schema::properties), (App)Codec.STRING.listOf().optionalFieldOf("enum").forGetter(Schema::enumValues)).apply((Applicative)var1, Schema::new)));
    private static final List<SchemaComponent> SCHEMA_REGISTRY = new ArrayList<SchemaComponent>();
    public static final Schema BOOL_SCHEMA = Schema.ofType("boolean");
    public static final Schema INT_SCHEMA = Schema.ofType("integer");
    public static final Schema NUMBER_SCHEMA = Schema.ofType("number");
    public static final Schema STRING_SCHEMA;
    public static final Schema UUID_SCHEMA;
    public static final SchemaComponent DIFFICULTY_SCHEMA;
    public static final SchemaComponent GAME_TYPE_SCHEMA;
    public static final SchemaComponent PLAYER_SCHEMA;
    public static final SchemaComponent VERSION_SCHEMA;
    public static final SchemaComponent SERVER_STATE_SCHEMA;
    public static final Schema RULE_TYPE_SCHEMA;
    public static final SchemaComponent TYPED_GAME_RULE_SCHEMA;
    public static final SchemaComponent UNTYPED_GAME_RULE_SCHEMA;
    public static final SchemaComponent MESSAGE_SCHEMA;
    public static final SchemaComponent SYSTEM_MESSAGE_SCHEMA;
    public static final SchemaComponent KICK_PLAYER_SCHEMA;
    public static final SchemaComponent OPERATOR_SCHEMA;
    public static final SchemaComponent INCOMING_IP_BAN_SCHEMA;
    public static final SchemaComponent IP_BAN_SCHEMA;
    public static final SchemaComponent PLAYER_BAN_SCHEMA;

    private static SchemaComponent registerSchema(String var0, Schema var1) {
        SchemaComponent var2 = new SchemaComponent(var0, ReferenceUtil.createLocalReference(var0), var1);
        SCHEMA_REGISTRY.add(var2);
        return var2;
    }

    public static List<SchemaComponent> getSchemaRegistry() {
        return SCHEMA_REGISTRY;
    }

    public static Schema ofRef(URI var0) {
        return new Schema(Optional.of(var0), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static Schema ofType(String var0) {
        return new Schema(Optional.empty(), Optional.of(var0), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static <E extends Enum<E>> Schema ofEnum(Supplier<E[]> var02) {
        List<String> var1 = Stream.of((Enum[])var02.get()).map(var0 -> ((INamable)var0).getSerializedName()).toList();
        return Schema.ofEnum(var1);
    }

    public static Schema ofEnum(List<String> var0) {
        return new Schema(Optional.empty(), Optional.of("string"), Optional.empty(), Optional.empty(), Optional.of(var0));
    }

    public static Schema arrayOf(Schema var0) {
        return new Schema(Optional.empty(), Optional.of("array"), Optional.of(var0), Optional.empty(), Optional.empty());
    }

    public static Schema record() {
        return new Schema(Optional.empty(), Optional.of("object"), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static Schema record(Map<String, Schema> var0) {
        return new Schema(Optional.empty(), Optional.of("object"), Optional.empty(), Optional.of(var0), Optional.empty());
    }

    public Schema withField(String var0, Schema var1) {
        HashMap<String, Schema> var2 = new HashMap<String, Schema>();
        this.properties.ifPresent(var2::putAll);
        var2.put(var0, var1);
        return Schema.record(var2);
    }

    public Schema asArray() {
        return Schema.arrayOf(this);
    }

    static {
        UUID_SCHEMA = STRING_SCHEMA = Schema.ofType("string");
        DIFFICULTY_SCHEMA = Schema.registerSchema("difficulty", Schema.ofEnum(EnumDifficulty::values));
        GAME_TYPE_SCHEMA = Schema.registerSchema("game_type", Schema.ofEnum(EnumGamemode::values));
        PLAYER_SCHEMA = Schema.registerSchema("player", Schema.record().withField("id", UUID_SCHEMA).withField("name", STRING_SCHEMA));
        VERSION_SCHEMA = Schema.registerSchema("version", Schema.record().withField("name", STRING_SCHEMA).withField("protocol", INT_SCHEMA));
        SERVER_STATE_SCHEMA = Schema.registerSchema("server_state", Schema.record().withField("started", BOOL_SCHEMA).withField("players", PLAYER_SCHEMA.asRef().asArray()).withField("version", VERSION_SCHEMA.asRef()));
        RULE_TYPE_SCHEMA = Schema.ofEnum(GameRulesService.a::values);
        TYPED_GAME_RULE_SCHEMA = Schema.registerSchema("typed_game_rule", Schema.record().withField("key", STRING_SCHEMA).withField("value", STRING_SCHEMA).withField("type", RULE_TYPE_SCHEMA));
        UNTYPED_GAME_RULE_SCHEMA = Schema.registerSchema("untyped_game_rule", Schema.record().withField("key", STRING_SCHEMA).withField("value", STRING_SCHEMA));
        MESSAGE_SCHEMA = Schema.registerSchema("message", Schema.record().withField("literal", STRING_SCHEMA).withField("translatable", STRING_SCHEMA).withField("translatableParams", STRING_SCHEMA.asArray()));
        SYSTEM_MESSAGE_SCHEMA = Schema.registerSchema("system_message", Schema.record().withField("message", MESSAGE_SCHEMA.asRef()).withField("overlay", BOOL_SCHEMA).withField("receivingPlayers", PLAYER_SCHEMA.asRef().asArray()));
        KICK_PLAYER_SCHEMA = Schema.registerSchema("kick_player", Schema.record().withField("message", MESSAGE_SCHEMA.asRef()).withField("player", PLAYER_SCHEMA.asRef()));
        OPERATOR_SCHEMA = Schema.registerSchema("operator", Schema.record().withField("player", PLAYER_SCHEMA.asRef()).withField("bypassesPlayerLimit", BOOL_SCHEMA).withField("permissionLevel", INT_SCHEMA));
        INCOMING_IP_BAN_SCHEMA = Schema.registerSchema("incoming_ip_ban", Schema.record().withField("player", PLAYER_SCHEMA.asRef()).withField("ip", STRING_SCHEMA).withField("reason", STRING_SCHEMA).withField("source", STRING_SCHEMA).withField("expires", STRING_SCHEMA));
        IP_BAN_SCHEMA = Schema.registerSchema("ip_ban", Schema.record().withField("ip", STRING_SCHEMA).withField("reason", STRING_SCHEMA).withField("source", STRING_SCHEMA).withField("expires", STRING_SCHEMA));
        PLAYER_BAN_SCHEMA = Schema.registerSchema("user_ban", Schema.record().withField("player", PLAYER_SCHEMA.asRef()).withField("reason", STRING_SCHEMA).withField("source", STRING_SCHEMA).withField("expires", STRING_SCHEMA));
    }
}

