/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.chase;

import com.google.common.base.Charsets;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.Socket;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Scanner;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.ChaseCommand;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class ChaseClient {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int RECONNECT_INTERVAL_SECONDS = 5;
    private final String serverHost;
    private final int serverPort;
    private final MinecraftServer server;
    private volatile boolean wantsToRun;
    @Nullable
    private Socket socket;
    @Nullable
    private Thread thread;

    public ChaseClient(String var0, int var1, MinecraftServer var2) {
        this.serverHost = var0;
        this.serverPort = var1;
        this.server = var2;
    }

    public void start() {
        if (this.thread != null && this.thread.isAlive()) {
            LOGGER.warn("Remote control client was asked to start, but it is already running. Will ignore.");
        }
        this.wantsToRun = true;
        this.thread = new Thread(this::run, "chase-client");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void stop() {
        this.wantsToRun = false;
        IOUtils.closeQuietly((Socket)this.socket);
        this.socket = null;
        this.thread = null;
    }

    public void run() {
        String var0 = this.serverHost + ":" + this.serverPort;
        while (this.wantsToRun) {
            try {
                LOGGER.info("Connecting to remote control server {}", (Object)var0);
                this.socket = new Socket(this.serverHost, this.serverPort);
                LOGGER.info("Connected to remote control server! Will continuously execute the command broadcasted by that server.");
                try (BufferedReader var1 = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), Charsets.US_ASCII));){
                    while (this.wantsToRun) {
                        String var2 = var1.readLine();
                        if (var2 == null) {
                            LOGGER.warn("Lost connection to remote control server {}. Will retry in {}s.", (Object)var0, (Object)5);
                            break;
                        }
                        this.handleMessage(var2);
                    }
                }
                catch (IOException var12) {
                    LOGGER.warn("Lost connection to remote control server {}. Will retry in {}s.", (Object)var0, (Object)5);
                }
            }
            catch (IOException var1) {
                LOGGER.warn("Failed to connect to remote control server {}. Will retry in {}s.", (Object)var0, (Object)5);
            }
            if (!this.wantsToRun) continue;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void handleMessage(String var0) {
        try (Scanner var1 = new Scanner(new StringReader(var0));){
            var1.useLocale(Locale.ROOT);
            String var2 = var1.next();
            if ("t".equals(var2)) {
                this.handleTeleport(var1);
            } else {
                LOGGER.warn("Unknown message type '{}'", (Object)var2);
            }
        }
        catch (NoSuchElementException var12) {
            LOGGER.warn("Could not parse message '{}', ignoring", (Object)var0);
        }
    }

    private void handleTeleport(Scanner var02) {
        this.parseTarget(var02).ifPresent(var0 -> this.executeCommand(String.format(Locale.ROOT, "execute in %s run tp @s %.3f %.3f %.3f %.3f %.3f", var0.level.location(), var0.pos.x, var0.pos.y, var0.pos.z, Float.valueOf(var0.rot.y), Float.valueOf(var0.rot.x))));
    }

    private Optional<a> parseTarget(Scanner var0) {
        ResourceKey var1 = (ResourceKey)ChaseCommand.DIMENSION_NAMES.get((Object)var0.next());
        if (var1 == null) {
            return Optional.empty();
        }
        float var2 = var0.nextFloat();
        float var3 = var0.nextFloat();
        float var4 = var0.nextFloat();
        float var5 = var0.nextFloat();
        float var6 = var0.nextFloat();
        return Optional.of(new a(var1, new Vec3D(var2, var3, var4), new Vec2F(var6, var5)));
    }

    private void executeCommand(String var0) {
        this.server.execute(() -> {
            List<EntityPlayer> var1 = this.server.getPlayerList().getPlayers();
            if (var1.isEmpty()) {
                return;
            }
            EntityPlayer var2 = var1.get(0);
            WorldServer var3 = this.server.overworld();
            CommandListenerWrapper var4 = new CommandListenerWrapper(var2.commandSource(), Vec3D.atLowerCornerOf(var3.getRespawnData().pos()), Vec2F.ZERO, var3, 4, "", CommonComponents.EMPTY, this.server, var2);
            CommandDispatcher var5 = this.server.getCommands();
            var5.performPrefixedCommand(var4, var0);
        });
    }

    static final class a
    extends Record {
        final ResourceKey<World> level;
        final Vec3D pos;
        final Vec2F rot;

        a(ResourceKey<World> var0, Vec3D var1, Vec2F var2) {
            this.level = var0;
            this.pos = var1;
            this.rot = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "level;pos;rot", "level", "pos", "rot"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "level;pos;rot", "level", "pos", "rot"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "level;pos;rot", "level", "pos", "rot"}, this, var0);
        }

        public ResourceKey<World> level() {
            return this.level;
        }

        public Vec3D pos() {
            return this.pos;
        }

        public Vec2F rot() {
            return this.rot;
        }
    }
}

