/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.Lifecycle;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagDataPack;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;

public interface IRegistry<T>
extends Keyable,
HolderLookup.b<T>,
Registry<T> {
    @Override
    public ResourceKey<? extends IRegistry<T>> key();

    default public Codec<T> byNameCodec() {
        return this.referenceHolderWithLifecycle().flatComapMap(Holder.c::value, var0 -> this.safeCastToReference(this.wrapAsHolder(var0)));
    }

    default public Codec<Holder<T>> holderByNameCodec() {
        return this.referenceHolderWithLifecycle().flatComapMap(var0 -> var0, this::safeCastToReference);
    }

    private Codec<Holder.c<T>> referenceHolderWithLifecycle() {
        Codec var02 = MinecraftKey.CODEC.comapFlatMap(var0 -> this.get((MinecraftKey)var0).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + String.valueOf(this.key()) + ": " + String.valueOf(var0))), var0 -> var0.key().location());
        return ExtraCodecs.overrideLifecycle(var02, var0 -> this.registrationInfo(var0.key()).map(RegistrationInfo::lifecycle).orElse(Lifecycle.experimental()));
    }

    private DataResult<Holder.c<T>> safeCastToReference(Holder<T> var0) {
        DataResult dataResult;
        if (var0 instanceof Holder.c) {
            Holder.c var1 = (Holder.c)var0;
            dataResult = DataResult.success((Object)var1);
        } else {
            dataResult = DataResult.error(() -> "Unregistered holder in " + String.valueOf(this.key()) + ": " + String.valueOf(var0));
        }
        return dataResult;
    }

    default public <U> Stream<U> keys(DynamicOps<U> var0) {
        return this.keySet().stream().map(var1 -> var0.createString(var1.toString()));
    }

    @Nullable
    public MinecraftKey getKey(T var1);

    public Optional<ResourceKey<T>> getResourceKey(T var1);

    @Override
    public int getId(@Nullable T var1);

    @Nullable
    public T getValue(@Nullable ResourceKey<T> var1);

    @Nullable
    public T getValue(@Nullable MinecraftKey var1);

    public Optional<RegistrationInfo> registrationInfo(ResourceKey<T> var1);

    default public Optional<T> getOptional(@Nullable MinecraftKey var0) {
        return Optional.ofNullable(this.getValue(var0));
    }

    default public Optional<T> getOptional(@Nullable ResourceKey<T> var0) {
        return Optional.ofNullable(this.getValue(var0));
    }

    public Optional<Holder.c<T>> getAny();

    default public T getValueOrThrow(ResourceKey<T> var0) {
        T var1 = this.getValue(var0);
        if (var1 == null) {
            throw new IllegalStateException("Missing key in " + String.valueOf(this.key()) + ": " + String.valueOf(var0));
        }
        return var1;
    }

    public Set<MinecraftKey> keySet();

    public Set<Map.Entry<ResourceKey<T>, T>> entrySet();

    public Set<ResourceKey<T>> registryKeySet();

    public Optional<Holder.c<T>> getRandom(RandomSource var1);

    default public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public boolean containsKey(MinecraftKey var1);

    public boolean containsKey(ResourceKey<T> var1);

    public static <T> T register(IRegistry<? super T> var0, String var1, T var2) {
        return IRegistry.register(var0, MinecraftKey.parse(var1), var2);
    }

    public static <V, T extends V> T register(IRegistry<V> var0, MinecraftKey var1, T var2) {
        return IRegistry.register(var0, ResourceKey.create(var0.key(), var1), var2);
    }

    public static <V, T extends V> T register(IRegistry<V> var0, ResourceKey<V> var1, T var2) {
        ((IRegistryWritable)var0).register(var1, var2, RegistrationInfo.BUILT_IN);
        return var2;
    }

    public static <R, T extends R> Holder.c<T> registerForHolder(IRegistry<R> var0, ResourceKey<R> var1, T var2) {
        return ((IRegistryWritable)var0).register(var1, var2, RegistrationInfo.BUILT_IN);
    }

    public static <R, T extends R> Holder.c<T> registerForHolder(IRegistry<R> var0, MinecraftKey var1, T var2) {
        return IRegistry.registerForHolder(var0, ResourceKey.create(var0.key(), var1), var2);
    }

    public IRegistry<T> freeze();

    public Holder.c<T> createIntrusiveHolder(T var1);

    public Optional<Holder.c<T>> get(int var1);

    public Optional<Holder.c<T>> get(MinecraftKey var1);

    public Holder<T> wrapAsHolder(T var1);

    default public Iterable<Holder<T>> getTagOrEmpty(TagKey<T> var0) {
        return (Iterable)DataFixUtils.orElse((Optional)this.get(var0), List.of());
    }

    public Stream<HolderSet.Named<T>> getTags();

    default public Registry<Holder<T>> asHolderIdMap() {
        return new Registry<Holder<T>>(){

            @Override
            public int getId(Holder<T> var0) {
                return IRegistry.this.getId(var0.value());
            }

            @Override
            @Nullable
            public Holder<T> byId(int var0) {
                return IRegistry.this.get(var0).orElse(null);
            }

            @Override
            public int size() {
                return IRegistry.this.size();
            }

            @Override
            public Iterator<Holder<T>> iterator() {
                return IRegistry.this.listElements().map(var0 -> var0).iterator();
            }

            @Override
            @Nullable
            public /* synthetic */ Object byId(int n2) {
                return this.byId(n2);
            }
        };
    }

    public a<T> prepareTagReload(TagDataPack.c<T> var1);

    public static interface a<T> {
        public ResourceKey<? extends IRegistry<? extends T>> key();

        public HolderLookup.b<T> lookup();

        public void apply();

        public int size();
    }
}

