/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CacheableFunction;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;

public record AdvancementRewards(int experience, List<ResourceKey<LootTable>> loot, List<ResourceKey<IRecipe<?>>> recipes, Optional<CacheableFunction> function) {
    public static final Codec<AdvancementRewards> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.INT.optionalFieldOf("experience", (Object)0).forGetter(AdvancementRewards::experience), (App)LootTable.KEY_CODEC.listOf().optionalFieldOf("loot", List.of()).forGetter(AdvancementRewards::loot), (App)IRecipe.KEY_CODEC.listOf().optionalFieldOf("recipes", List.of()).forGetter(AdvancementRewards::recipes), (App)CacheableFunction.CODEC.optionalFieldOf("function").forGetter(AdvancementRewards::function)).apply((Applicative)var0, AdvancementRewards::new));
    public static final AdvancementRewards EMPTY = new AdvancementRewards(0, List.of(), List.of(), Optional.empty());

    public void grant(EntityPlayer var0) {
        var0.giveExperiencePoints(this.experience);
        WorldServer var12 = var0.level();
        MinecraftServer var22 = var12.getServer();
        LootParams var3 = new LootParams.a(var12).withParameter(LootContextParameters.THIS_ENTITY, var0).withParameter(LootContextParameters.ORIGIN, var0.position()).create(LootContextParameterSets.ADVANCEMENT_REWARD);
        boolean var4 = false;
        for (ResourceKey<LootTable> var6 : this.loot) {
            for (ItemStack var8 : var22.reloadableRegistries().getLootTable(var6).getRandomItems(var3)) {
                if (var0.addItem(var8)) {
                    var12.playSound(null, var0.getX(), var0.getY(), var0.getZ(), SoundEffects.ITEM_PICKUP, SoundCategory.PLAYERS, 0.2f, ((var0.getRandom().nextFloat() - var0.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    var4 = true;
                    continue;
                }
                EntityItem var9 = var0.drop(var8, false);
                if (var9 == null) continue;
                var9.setNoPickUpDelay();
                var9.setTarget(var0.getUUID());
            }
        }
        if (var4) {
            var0.containerMenu.broadcastChanges();
        }
        if (!this.recipes.isEmpty()) {
            var0.awardRecipesByKey(this.recipes);
        }
        this.function.flatMap(var1 -> var1.get(var22.getFunctions())).ifPresent(var2 -> var22.getFunctions().execute((CommandFunction<CommandListenerWrapper>)var2, var0.createCommandSourceStack().withSuppressedOutput().withPermission(2)));
    }

    public static class a {
        private int experience;
        private final ImmutableList.Builder<ResourceKey<LootTable>> loot = ImmutableList.builder();
        private final ImmutableList.Builder<ResourceKey<IRecipe<?>>> recipes = ImmutableList.builder();
        private Optional<MinecraftKey> function = Optional.empty();

        public static a experience(int var0) {
            return new a().addExperience(var0);
        }

        public a addExperience(int var0) {
            this.experience += var0;
            return this;
        }

        public static a loot(ResourceKey<LootTable> var0) {
            return new a().addLootTable(var0);
        }

        public a addLootTable(ResourceKey<LootTable> var0) {
            this.loot.add(var0);
            return this;
        }

        public static a recipe(ResourceKey<IRecipe<?>> var0) {
            return new a().addRecipe(var0);
        }

        public a addRecipe(ResourceKey<IRecipe<?>> var0) {
            this.recipes.add(var0);
            return this;
        }

        public static a function(MinecraftKey var0) {
            return new a().runs(var0);
        }

        public a runs(MinecraftKey var0) {
            this.function = Optional.of(var0);
            return this;
        }

        public AdvancementRewards build() {
            return new AdvancementRewards(this.experience, (List<ResourceKey<LootTable>>)this.loot.build(), (List<ResourceKey<IRecipe<?>>>)this.recipes.build(), this.function.map(CacheableFunction::new));
        }
    }
}

