/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.base.Function;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.MoreExecutors;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.jtracy.TracyClient;
import com.mojang.jtracy.Zone;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceImmutableList;
import it.unimi.dsi.fastutil.objects.ReferenceList;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CharPredicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.TracingExecutor;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SingleKeyCache;
import net.minecraft.util.TimeSource;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.world.level.block.state.properties.IBlockState;
import org.slf4j.Logger;

public class SystemUtils {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int DEFAULT_MAX_THREADS = 255;
    private static final int DEFAULT_SAFE_FILE_OPERATION_RETRIES = 10;
    private static final String MAX_THREADS_SYSTEM_PROPERTY = "max.bg.threads";
    private static final TracingExecutor BACKGROUND_EXECUTOR = SystemUtils.makeExecutor("Main");
    private static final TracingExecutor IO_POOL = SystemUtils.makeIoExecutor("IO-Worker-", false);
    private static final TracingExecutor DOWNLOAD_POOL = SystemUtils.makeIoExecutor("Download-", true);
    private static final DateTimeFormatter FILENAME_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss", Locale.ROOT);
    public static final int LINEAR_LOOKUP_THRESHOLD = 8;
    private static final Set<String> ALLOWED_UNTRUSTED_LINK_PROTOCOLS = Set.of("http", "https");
    public static final long NANOS_PER_MILLI = 1000000L;
    public static TimeSource.a timeSource = System::nanoTime;
    public static final Ticker TICKER = new Ticker(){

        public long read() {
            return timeSource.getAsLong();
        }
    };
    public static final UUID NIL_UUID = new UUID(0L, 0L);
    public static final FileSystemProvider ZIP_FILE_SYSTEM_PROVIDER = FileSystemProvider.installedProviders().stream().filter(var0 -> var0.getScheme().equalsIgnoreCase("jar")).findFirst().orElseThrow(() -> new IllegalStateException("No jar file system provider found"));
    private static Consumer<String> thePauser = var0 -> {};

    public static <K, V> Collector<Map.Entry<? extends K, ? extends V>, ?, Map<K, V>> toMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T> Collector<T, ?, List<T>> toMutableList() {
        return Collectors.toCollection(Lists::newArrayList);
    }

    public static <T extends Comparable<T>> String getPropertyName(IBlockState<T> var0, Object var1) {
        return var0.getName((Comparable)var1);
    }

    public static String makeDescriptionId(String var0, @Nullable MinecraftKey var1) {
        if (var1 == null) {
            return var0 + ".unregistered_sadface";
        }
        return var0 + "." + var1.getNamespace() + "." + var1.getPath().replace('/', '.');
    }

    public static long getMillis() {
        return SystemUtils.getNanos() / 1000000L;
    }

    public static long getNanos() {
        return timeSource.getAsLong();
    }

    public static long getEpochMillis() {
        return Instant.now().toEpochMilli();
    }

    public static String getFilenameFormattedDateTime() {
        return FILENAME_DATE_TIME_FORMATTER.format(ZonedDateTime.now());
    }

    private static TracingExecutor makeExecutor(final String var0) {
        Object var22;
        int var1 = SystemUtils.maxAllowedExecutorThreads();
        if (var1 <= 0) {
            var22 = MoreExecutors.newDirectExecutorService();
        } else {
            AtomicInteger var3 = new AtomicInteger(1);
            var22 = new ForkJoinPool(var1, var2 -> {
                final String var3 = "Worker-" + var0 + "-" + var3.getAndIncrement();
                ForkJoinWorkerThread var4 = new ForkJoinWorkerThread(var2){

                    @Override
                    protected void onStart() {
                        TracyClient.setThreadName((String)var3, (int)var0.hashCode());
                        super.onStart();
                    }

                    @Override
                    protected void onTermination(Throwable var02) {
                        if (var02 != null) {
                            LOGGER.warn("{} died", (Object)this.getName(), (Object)var02);
                        } else {
                            LOGGER.debug("{} shutdown", (Object)this.getName());
                        }
                        super.onTermination(var02);
                    }
                };
                var4.setName(var3);
                return var4;
            }, SystemUtils::onThreadException, true);
        }
        return new TracingExecutor((ExecutorService)var22);
    }

    public static int maxAllowedExecutorThreads() {
        return MathHelper.clamp(Runtime.getRuntime().availableProcessors() - 1, 1, SystemUtils.getMaxThreads());
    }

    private static int getMaxThreads() {
        String var0 = System.getProperty(MAX_THREADS_SYSTEM_PROPERTY);
        if (var0 != null) {
            try {
                int var1 = Integer.parseInt(var0);
                if (var1 >= 1 && var1 <= 255) {
                    return var1;
                }
                LOGGER.error("Wrong {} property value '{}'. Should be an integer value between 1 and {}.", new Object[]{MAX_THREADS_SYSTEM_PROPERTY, var0, 255});
            }
            catch (NumberFormatException var1) {
                LOGGER.error("Could not parse {} property value '{}'. Should be an integer value between 1 and {}.", new Object[]{MAX_THREADS_SYSTEM_PROPERTY, var0, 255});
            }
        }
        return 255;
    }

    public static TracingExecutor backgroundExecutor() {
        return BACKGROUND_EXECUTOR;
    }

    public static TracingExecutor ioPool() {
        return IO_POOL;
    }

    public static TracingExecutor nonCriticalIoPool() {
        return DOWNLOAD_POOL;
    }

    public static void shutdownExecutors() {
        BACKGROUND_EXECUTOR.shutdownAndAwait(3L, TimeUnit.SECONDS);
        IO_POOL.shutdownAndAwait(3L, TimeUnit.SECONDS);
    }

    private static TracingExecutor makeIoExecutor(String var0, boolean var1) {
        AtomicInteger var2 = new AtomicInteger(1);
        return new TracingExecutor(Executors.newCachedThreadPool(var3 -> {
            Thread var4 = new Thread(var3);
            String var5 = var0 + var2.getAndIncrement();
            TracyClient.setThreadName((String)var5, (int)var0.hashCode());
            var4.setName(var5);
            var4.setDaemon(var1);
            var4.setUncaughtExceptionHandler(SystemUtils::onThreadException);
            return var4;
        }));
    }

    public static void throwAsRuntime(Throwable var0) {
        throw var0 instanceof RuntimeException ? (RuntimeException)var0 : new RuntimeException(var0);
    }

    private static void onThreadException(Thread var0, Throwable var1) {
        SystemUtils.pauseInIde(var1);
        if (var1 instanceof CompletionException) {
            var1 = var1.getCause();
        }
        if (var1 instanceof ReportedException) {
            ReportedException var2 = (ReportedException)var1;
            DispenserRegistry.realStdoutPrintln(var2.getReport().getFriendlyReport(ReportType.CRASH));
            System.exit(-1);
        }
        LOGGER.error(String.format(Locale.ROOT, "Caught exception in thread %s", var0), var1);
    }

    @Nullable
    public static Type<?> fetchChoiceType(DSL.TypeReference var0, String var1) {
        if (!SharedConstants.CHECK_DATA_FIXER_SCHEMA) {
            return null;
        }
        return SystemUtils.doFetchChoiceType(var0, var1);
    }

    @Nullable
    private static Type<?> doFetchChoiceType(DSL.TypeReference var0, String var1) {
        Type var2;
        block2: {
            var2 = null;
            try {
                var2 = DataConverterRegistry.getDataFixer().getSchema(DataFixUtils.makeKey((int)SharedConstants.getCurrentVersion().dataVersion().version())).getChoiceType(var0, var1);
            }
            catch (IllegalArgumentException var3) {
                LOGGER.error("No data fixer registered for {}", (Object)var1);
                if (!SharedConstants.IS_RUNNING_IN_IDE) break block2;
                throw var3;
            }
        }
        return var2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runNamed(Runnable var0, String var1) {
        block16: {
            if (SharedConstants.IS_RUNNING_IN_IDE) {
                Thread var2 = Thread.currentThread();
                String var3 = var2.getName();
                var2.setName(var1);
                try (Zone var4 = TracyClient.beginZone((String)var1, (boolean)SharedConstants.IS_RUNNING_IN_IDE);){
                    var0.run();
                    break block16;
                }
                finally {
                    var2.setName(var3);
                }
            }
            try (Zone var2 = TracyClient.beginZone((String)var1, (boolean)SharedConstants.IS_RUNNING_IN_IDE);){
                var0.run();
            }
        }
    }

    public static <T> String getRegisteredName(IRegistry<T> var0, T var1) {
        MinecraftKey var2 = var0.getKey(var1);
        if (var2 == null) {
            return "[unregistered]";
        }
        return var2.toString();
    }

    public static <T> Predicate<T> allOf() {
        return var0 -> true;
    }

    public static <T> Predicate<T> allOf(Predicate<? super T> var0) {
        return var0;
    }

    public static <T> Predicate<T> allOf(Predicate<? super T> var0, Predicate<? super T> var1) {
        return var2 -> var0.test(var2) && var1.test(var2);
    }

    public static <T> Predicate<T> allOf(Predicate<? super T> var0, Predicate<? super T> var1, Predicate<? super T> var2) {
        return var3 -> var0.test(var3) && var1.test(var3) && var2.test(var3);
    }

    public static <T> Predicate<T> allOf(Predicate<? super T> var0, Predicate<? super T> var1, Predicate<? super T> var2, Predicate<? super T> var3) {
        return var4 -> var0.test(var4) && var1.test(var4) && var2.test(var4) && var3.test(var4);
    }

    public static <T> Predicate<T> allOf(Predicate<? super T> var0, Predicate<? super T> var1, Predicate<? super T> var2, Predicate<? super T> var3, Predicate<? super T> var4) {
        return var5 -> var0.test(var5) && var1.test(var5) && var2.test(var5) && var3.test(var5) && var4.test(var5);
    }

    @SafeVarargs
    public static <T> Predicate<T> allOf(Predicate<? super T> ... var0) {
        return var1 -> {
            for (Predicate var5 : var0) {
                if (var5.test(var1)) continue;
                return false;
            }
            return true;
        };
    }

    public static <T> Predicate<T> allOf(List<? extends Predicate<? super T>> var0) {
        return switch (var0.size()) {
            case 0 -> SystemUtils.allOf();
            case 1 -> SystemUtils.allOf(var0.get(0));
            case 2 -> SystemUtils.allOf(var0.get(0), var0.get(1));
            case 3 -> SystemUtils.allOf(var0.get(0), var0.get(1), var0.get(2));
            case 4 -> SystemUtils.allOf(var0.get(0), var0.get(1), var0.get(2), var0.get(3));
            case 5 -> SystemUtils.allOf(var0.get(0), var0.get(1), var0.get(2), var0.get(3), var0.get(4));
            default -> {
                Predicate[] var1 = (Predicate[])var0.toArray(Predicate[]::new);
                yield SystemUtils.allOf(var1);
            }
        };
    }

    public static <T> Predicate<T> anyOf() {
        return var0 -> false;
    }

    public static <T> Predicate<T> anyOf(Predicate<? super T> var0) {
        return var0;
    }

    public static <T> Predicate<T> anyOf(Predicate<? super T> var0, Predicate<? super T> var1) {
        return var2 -> var0.test(var2) || var1.test(var2);
    }

    public static <T> Predicate<T> anyOf(Predicate<? super T> var0, Predicate<? super T> var1, Predicate<? super T> var2) {
        return var3 -> var0.test(var3) || var1.test(var3) || var2.test(var3);
    }

    public static <T> Predicate<T> anyOf(Predicate<? super T> var0, Predicate<? super T> var1, Predicate<? super T> var2, Predicate<? super T> var3) {
        return var4 -> var0.test(var4) || var1.test(var4) || var2.test(var4) || var3.test(var4);
    }

    public static <T> Predicate<T> anyOf(Predicate<? super T> var0, Predicate<? super T> var1, Predicate<? super T> var2, Predicate<? super T> var3, Predicate<? super T> var4) {
        return var5 -> var0.test(var5) || var1.test(var5) || var2.test(var5) || var3.test(var5) || var4.test(var5);
    }

    @SafeVarargs
    public static <T> Predicate<T> anyOf(Predicate<? super T> ... var0) {
        return var1 -> {
            for (Predicate var5 : var0) {
                if (!var5.test(var1)) continue;
                return true;
            }
            return false;
        };
    }

    public static <T> Predicate<T> anyOf(List<? extends Predicate<? super T>> var0) {
        return switch (var0.size()) {
            case 0 -> SystemUtils.anyOf();
            case 1 -> SystemUtils.anyOf(var0.get(0));
            case 2 -> SystemUtils.anyOf(var0.get(0), var0.get(1));
            case 3 -> SystemUtils.anyOf(var0.get(0), var0.get(1), var0.get(2));
            case 4 -> SystemUtils.anyOf(var0.get(0), var0.get(1), var0.get(2), var0.get(3));
            case 5 -> SystemUtils.anyOf(var0.get(0), var0.get(1), var0.get(2), var0.get(3), var0.get(4));
            default -> {
                Predicate[] var1 = (Predicate[])var0.toArray(Predicate[]::new);
                yield SystemUtils.anyOf(var1);
            }
        };
    }

    public static <T> boolean isSymmetrical(int var0, int var1, List<T> var2) {
        if (var0 == 1) {
            return true;
        }
        int var3 = var0 / 2;
        for (int var4 = 0; var4 < var1; ++var4) {
            for (int var5 = 0; var5 < var3; ++var5) {
                T var8;
                int var6 = var0 - 1 - var5;
                T var7 = var2.get(var5 + var4 * var0);
                if (var7.equals(var8 = var2.get(var6 + var4 * var0))) continue;
                return false;
            }
        }
        return true;
    }

    public static int growByHalf(int var0, int var1) {
        return (int)Math.max(Math.min((long)var0 + (long)(var0 >> 1), 0x7FFFFFF7L), (long)var1);
    }

    public static OS getPlatform() {
        String var0 = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (var0.contains("win")) {
            return OS.WINDOWS;
        }
        if (var0.contains("mac")) {
            return OS.OSX;
        }
        if (var0.contains("solaris")) {
            return OS.SOLARIS;
        }
        if (var0.contains("sunos")) {
            return OS.SOLARIS;
        }
        if (var0.contains("linux")) {
            return OS.LINUX;
        }
        if (var0.contains("unix")) {
            return OS.LINUX;
        }
        return OS.UNKNOWN;
    }

    public static boolean isAarch64() {
        String var0 = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
        return var0.equals("aarch64");
    }

    public static URI parseAndValidateUntrustedUri(String var0) throws URISyntaxException {
        URI var1 = new URI(var0);
        String var2 = var1.getScheme();
        if (var2 == null) {
            throw new URISyntaxException(var0, "Missing protocol in URI: " + var0);
        }
        String var3 = var2.toLowerCase(Locale.ROOT);
        if (!ALLOWED_UNTRUSTED_LINK_PROTOCOLS.contains(var3)) {
            throw new URISyntaxException(var0, "Unsupported protocol in URI: " + var0);
        }
        return var1;
    }

    public static <T> T lastOf(List<T> var0) {
        return var0.get(var0.size() - 1);
    }

    public static <T> T findNextInIterable(Iterable<T> var0, @Nullable T var1) {
        Iterator<T> var2 = var0.iterator();
        T var3 = var2.next();
        if (var1 != null) {
            T var4 = var3;
            while (true) {
                if (var4 == var1) {
                    if (!var2.hasNext()) break;
                    return var2.next();
                }
                if (!var2.hasNext()) continue;
                var4 = var2.next();
            }
        }
        return var3;
    }

    public static <T> T findPreviousInIterable(Iterable<T> var0, @Nullable T var1) {
        Iterator<T> var2 = var0.iterator();
        T var3 = null;
        while (var2.hasNext()) {
            T var4 = var2.next();
            if (var4 == var1) {
                if (var3 != null) break;
                var3 = (T)(var2.hasNext() ? Iterators.getLast(var2) : var1);
                break;
            }
            var3 = var4;
        }
        return var3;
    }

    public static <T> T make(Supplier<T> var0) {
        return var0.get();
    }

    public static <T> T make(T var0, Consumer<? super T> var1) {
        var1.accept(var0);
        return var0;
    }

    public static <K extends Enum<K>, V> Map<K, V> makeEnumMap(Class<K> var0, java.util.function.Function<K, V> var1) {
        EnumMap<Enum, V> var2 = new EnumMap<Enum, V>(var0);
        for (Enum var6 : (Enum[])var0.getEnumConstants()) {
            var2.put(var6, var1.apply(var6));
        }
        return var2;
    }

    public static <K, V1, V2> Map<K, V2> mapValues(Map<K, V1> var0, java.util.function.Function<? super V1, V2> var12) {
        return var0.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, var1 -> var12.apply((Object)var1.getValue())));
    }

    public static <K, V1, V2> Map<K, V2> mapValuesLazy(Map<K, V1> var0, Function<V1, V2> var1) {
        return Maps.transformValues(var0, var1);
    }

    public static <V> CompletableFuture<List<V>> sequence(List<? extends CompletableFuture<V>> var0) {
        if (var0.isEmpty()) {
            return CompletableFuture.completedFuture(List.of());
        }
        if (var0.size() == 1) {
            return var0.get(0).thenApply(List::of);
        }
        CompletableFuture<Void> var12 = CompletableFuture.allOf(var0.toArray(new CompletableFuture[0]));
        return var12.thenApply(var1 -> var0.stream().map(CompletableFuture::join).toList());
    }

    public static <V> CompletableFuture<List<V>> sequenceFailFast(List<? extends CompletableFuture<? extends V>> var0) {
        CompletableFuture var1 = new CompletableFuture();
        return SystemUtils.fallibleSequence(var0, var1::completeExceptionally).applyToEither((CompletionStage)var1, java.util.function.Function.identity());
    }

    public static <V> CompletableFuture<List<V>> sequenceFailFastAndCancel(List<? extends CompletableFuture<? extends V>> var0) {
        CompletableFuture var1 = new CompletableFuture();
        return SystemUtils.fallibleSequence(var0, var2 -> {
            if (var1.completeExceptionally((Throwable)var2)) {
                for (CompletableFuture var4 : var0) {
                    var4.cancel(true);
                }
            }
        }).applyToEither((CompletionStage)var1, java.util.function.Function.identity());
    }

    private static <V> CompletableFuture<List<V>> fallibleSequence(List<? extends CompletableFuture<? extends V>> var0, Consumer<Throwable> var12) {
        ArrayList var2 = Lists.newArrayListWithCapacity((int)var0.size());
        CompletableFuture[] var3 = new CompletableFuture[var0.size()];
        var0.forEach(var32 -> {
            int var42 = var2.size();
            var2.add(null);
            var1[var42] = var32.whenComplete((var3, var4) -> {
                if (var4 != null) {
                    var12.accept((Throwable)var4);
                } else {
                    var2.set(var42, var3);
                }
            });
        });
        return CompletableFuture.allOf(var3).thenApply(var1 -> var2);
    }

    public static <T> Optional<T> ifElse(Optional<T> var0, Consumer<T> var1, Runnable var2) {
        if (var0.isPresent()) {
            var1.accept(var0.get());
        } else {
            var2.run();
        }
        return var0;
    }

    public static <T> Supplier<T> name(final Supplier<T> var0, Supplier<String> var1) {
        if (SharedConstants.DEBUG_NAMED_RUNNABLES) {
            final String var2 = var1.get();
            return new Supplier<T>(){

                @Override
                public T get() {
                    return var0.get();
                }

                public String toString() {
                    return var2;
                }
            };
        }
        return var0;
    }

    public static Runnable name(final Runnable var0, Supplier<String> var1) {
        if (SharedConstants.DEBUG_NAMED_RUNNABLES) {
            final String var2 = var1.get();
            return new Runnable(){

                @Override
                public void run() {
                    var0.run();
                }

                public String toString() {
                    return var2;
                }
            };
        }
        return var0;
    }

    public static void logAndPauseIfInIde(String var0) {
        LOGGER.error(var0);
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            SystemUtils.doPause(var0);
        }
    }

    public static void logAndPauseIfInIde(String var0, Throwable var1) {
        LOGGER.error(var0, var1);
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            SystemUtils.doPause(var0);
        }
    }

    public static <T extends Throwable> T pauseInIde(T var0) {
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            LOGGER.error("Trying to throw a fatal exception, pausing in IDE", var0);
            SystemUtils.doPause(var0.getMessage());
        }
        return var0;
    }

    public static void setPause(Consumer<String> var0) {
        thePauser = var0;
    }

    private static void doPause(String var0) {
        boolean var2;
        Instant var1 = Instant.now();
        LOGGER.warn("Did you remember to set a breakpoint here?");
        boolean bl = var2 = Duration.between(var1, Instant.now()).toMillis() > 500L;
        if (!var2) {
            thePauser.accept(var0);
        }
    }

    public static String describeError(Throwable var0) {
        if (var0.getCause() != null) {
            return SystemUtils.describeError(var0.getCause());
        }
        if (var0.getMessage() != null) {
            return var0.getMessage();
        }
        return var0.toString();
    }

    public static <T> T getRandom(T[] var0, RandomSource var1) {
        return var0[var1.nextInt(var0.length)];
    }

    public static int getRandom(int[] var0, RandomSource var1) {
        return var0[var1.nextInt(var0.length)];
    }

    public static <T> T getRandom(List<T> var0, RandomSource var1) {
        return var0.get(var1.nextInt(var0.size()));
    }

    public static <T> Optional<T> getRandomSafe(List<T> var0, RandomSource var1) {
        if (var0.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(SystemUtils.getRandom(var0, var1));
    }

    private static BooleanSupplier createRenamer(final Path var0, final Path var1) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                try {
                    Files.move(var0, var1, new CopyOption[0]);
                    return true;
                }
                catch (IOException var02) {
                    LOGGER.error("Failed to rename", (Throwable)var02);
                    return false;
                }
            }

            public String toString() {
                return "rename " + String.valueOf(var0) + " to " + String.valueOf(var1);
            }
        };
    }

    private static BooleanSupplier createDeleter(final Path var0) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                try {
                    Files.deleteIfExists(var0);
                    return true;
                }
                catch (IOException var02) {
                    LOGGER.warn("Failed to delete", (Throwable)var02);
                    return false;
                }
            }

            public String toString() {
                return "delete old " + String.valueOf(var0);
            }
        };
    }

    private static BooleanSupplier createFileDeletedCheck(final Path var0) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return !Files.exists(var0, new LinkOption[0]);
            }

            public String toString() {
                return "verify that " + String.valueOf(var0) + " is deleted";
            }
        };
    }

    private static BooleanSupplier createFileCreatedCheck(final Path var0) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return Files.isRegularFile(var0, new LinkOption[0]);
            }

            public String toString() {
                return "verify that " + String.valueOf(var0) + " is present";
            }
        };
    }

    private static boolean executeInSequence(BooleanSupplier ... var0) {
        for (BooleanSupplier var4 : var0) {
            if (var4.getAsBoolean()) continue;
            LOGGER.warn("Failed to execute {}", (Object)var4);
            return false;
        }
        return true;
    }

    private static boolean runWithRetries(int var0, String var1, BooleanSupplier ... var2) {
        for (int var3 = 0; var3 < var0; ++var3) {
            if (SystemUtils.executeInSequence(var2)) {
                return true;
            }
            LOGGER.error("Failed to {}, retrying {}/{}", new Object[]{var1, var3, var0});
        }
        LOGGER.error("Failed to {}, aborting, progress might be lost", (Object)var1);
        return false;
    }

    public static void safeReplaceFile(Path var0, Path var1, Path var2) {
        SystemUtils.safeReplaceOrMoveFile(var0, var1, var2, false);
    }

    public static boolean safeReplaceOrMoveFile(Path var0, Path var1, Path var2, boolean var3) {
        if (Files.exists(var0, new LinkOption[0]) && !SystemUtils.runWithRetries(10, "create backup " + String.valueOf(var2), SystemUtils.createDeleter(var2), SystemUtils.createRenamer(var0, var2), SystemUtils.createFileCreatedCheck(var2))) {
            return false;
        }
        if (!SystemUtils.runWithRetries(10, "remove old " + String.valueOf(var0), SystemUtils.createDeleter(var0), SystemUtils.createFileDeletedCheck(var0))) {
            return false;
        }
        if (!SystemUtils.runWithRetries(10, "replace " + String.valueOf(var0) + " with " + String.valueOf(var1), SystemUtils.createRenamer(var1, var0), SystemUtils.createFileCreatedCheck(var0)) && !var3) {
            SystemUtils.runWithRetries(10, "restore " + String.valueOf(var0) + " from " + String.valueOf(var2), SystemUtils.createRenamer(var2, var0), SystemUtils.createFileCreatedCheck(var0));
            return false;
        }
        return true;
    }

    public static int offsetByCodepoints(String var0, int var1, int var2) {
        int var3 = var0.length();
        if (var2 >= 0) {
            for (int var4 = 0; var1 < var3 && var4 < var2; ++var4) {
                if (!Character.isHighSurrogate(var0.charAt(var1++)) || var1 >= var3 || !Character.isLowSurrogate(var0.charAt(var1))) continue;
                ++var1;
            }
        } else {
            for (int var4 = var2; var1 > 0 && var4 < 0; ++var4) {
                if (!Character.isLowSurrogate(var0.charAt(--var1)) || var1 <= 0 || !Character.isHighSurrogate(var0.charAt(var1 - 1))) continue;
                --var1;
            }
        }
        return var1;
    }

    public static Consumer<String> prefix(String var0, Consumer<String> var1) {
        return var2 -> var1.accept(var0 + var2);
    }

    public static DataResult<int[]> fixedSize(IntStream var0, int var1) {
        int[] var2 = var0.limit(var1 + 1).toArray();
        if (var2.length != var1) {
            Supplier<String> var3 = () -> "Input is not a list of " + var1 + " ints";
            if (var2.length >= var1) {
                return DataResult.error(var3, (Object)Arrays.copyOf(var2, var1));
            }
            return DataResult.error(var3);
        }
        return DataResult.success((Object)var2);
    }

    public static DataResult<long[]> fixedSize(LongStream var0, int var1) {
        long[] var2 = var0.limit(var1 + 1).toArray();
        if (var2.length != var1) {
            Supplier<String> var3 = () -> "Input is not a list of " + var1 + " longs";
            if (var2.length >= var1) {
                return DataResult.error(var3, (Object)Arrays.copyOf(var2, var1));
            }
            return DataResult.error(var3);
        }
        return DataResult.success((Object)var2);
    }

    public static <T> DataResult<List<T>> fixedSize(List<T> var0, int var1) {
        if (var0.size() != var1) {
            Supplier<String> var2 = () -> "Input is not a list of " + var1 + " elements";
            if (var0.size() >= var1) {
                return DataResult.error(var2, var0.subList(0, var1));
            }
            return DataResult.error(var2);
        }
        return DataResult.success(var0);
    }

    public static void startTimerHackThread() {
        Thread var0 = new Thread("Timer hack thread"){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(Integer.MAX_VALUE);
                    }
                }
                catch (InterruptedException var0) {
                    LOGGER.warn("Timer hack thread interrupted, that really should not happen");
                    return;
                }
            }
        };
        var0.setDaemon(true);
        var0.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
        var0.start();
    }

    public static void copyBetweenDirs(Path var0, Path var1, Path var2) throws IOException {
        Path var3 = var0.relativize(var2);
        Path var4 = var1.resolve(var3);
        Files.copy(var2, var4, new CopyOption[0]);
    }

    public static String sanitizeName(String var0, CharPredicate var12) {
        return var0.toLowerCase(Locale.ROOT).chars().mapToObj(var1 -> var12.test((char)var1) ? Character.toString((char)var1) : "_").collect(Collectors.joining());
    }

    public static <K, V> SingleKeyCache<K, V> singleKeyCache(java.util.function.Function<K, V> var0) {
        return new SingleKeyCache<K, V>(var0);
    }

    public static <T, R> java.util.function.Function<T, R> memoize(final java.util.function.Function<T, R> var0) {
        return new java.util.function.Function<T, R>(){
            private final Map<T, R> cache = new ConcurrentHashMap();

            @Override
            public R apply(T var02) {
                return this.cache.computeIfAbsent(var02, var0);
            }

            public String toString() {
                return "memoize/1[function=" + String.valueOf(var0) + ", size=" + this.cache.size() + "]";
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> memoize(final BiFunction<T, U, R> var0) {
        return new BiFunction<T, U, R>(){
            private final Map<Pair<T, U>, R> cache = new ConcurrentHashMap();

            @Override
            public R apply(T var02, U var12) {
                return this.cache.computeIfAbsent(Pair.of(var02, var12), var1 -> var0.apply(var1.getFirst(), var1.getSecond()));
            }

            public String toString() {
                return "memoize/2[function=" + String.valueOf(var0) + ", size=" + this.cache.size() + "]";
            }
        };
    }

    public static <T> List<T> toShuffledList(Stream<T> var0, RandomSource var1) {
        ObjectArrayList var2 = (ObjectArrayList)var0.collect(ObjectArrayList.toList());
        SystemUtils.shuffle(var2, var1);
        return var2;
    }

    public static IntArrayList toShuffledList(IntStream var0, RandomSource var1) {
        int var3;
        IntArrayList var2 = IntArrayList.wrap((int[])var0.toArray());
        for (int var4 = var3 = var2.size(); var4 > 1; --var4) {
            int var5 = var1.nextInt(var4);
            var2.set(var4 - 1, var2.set(var5, var2.getInt(var4 - 1)));
        }
        return var2;
    }

    public static <T> List<T> shuffledCopy(T[] var0, RandomSource var1) {
        ObjectArrayList var2 = new ObjectArrayList((Object[])var0);
        SystemUtils.shuffle(var2, var1);
        return var2;
    }

    public static <T> List<T> shuffledCopy(ObjectArrayList<T> var0, RandomSource var1) {
        ObjectArrayList var2 = new ObjectArrayList(var0);
        SystemUtils.shuffle(var2, var1);
        return var2;
    }

    public static <T> void shuffle(List<T> var0, RandomSource var1) {
        int var2;
        for (int var3 = var2 = var0.size(); var3 > 1; --var3) {
            int var4 = var1.nextInt(var3);
            var0.set(var3 - 1, var0.set(var4, var0.get(var3 - 1)));
        }
    }

    public static <T> CompletableFuture<T> blockUntilDone(java.util.function.Function<Executor, CompletableFuture<T>> var0) {
        return SystemUtils.blockUntilDone(var0, CompletableFuture::isDone);
    }

    public static <T> T blockUntilDone(java.util.function.Function<Executor, T> var0, Predicate<T> var1) {
        int var4;
        LinkedBlockingQueue var2 = new LinkedBlockingQueue();
        T var3 = var0.apply(var2::add);
        while (!var1.test(var3)) {
            try {
                Runnable var42 = (Runnable)var2.poll(100L, TimeUnit.MILLISECONDS);
                if (var42 == null) continue;
                var42.run();
            }
            catch (InterruptedException var43) {
                LOGGER.warn("Interrupted wait");
                break;
            }
        }
        if ((var4 = var2.size()) > 0) {
            LOGGER.warn("Tasks left in queue: {}", (Object)var4);
        }
        return var3;
    }

    public static <T> ToIntFunction<T> createIndexLookup(List<T> var0) {
        int var1 = var0.size();
        if (var1 < 8) {
            return var0::indexOf;
        }
        Object2IntOpenHashMap var2 = new Object2IntOpenHashMap(var1);
        var2.defaultReturnValue(-1);
        for (int var3 = 0; var3 < var1; ++var3) {
            var2.put(var0.get(var3), var3);
        }
        return var2;
    }

    public static <T> ToIntFunction<T> createIndexIdentityLookup(List<T> var0) {
        int var1 = var0.size();
        if (var1 < 8) {
            ReferenceImmutableList var2 = new ReferenceImmutableList(var0);
            return arg_0 -> ((ReferenceList)var2).indexOf(arg_0);
        }
        Reference2IntOpenHashMap var2 = new Reference2IntOpenHashMap(var1);
        var2.defaultReturnValue(-1);
        for (int var3 = 0; var3 < var1; ++var3) {
            var2.put(var0.get(var3), var3);
        }
        return var2;
    }

    public static <A, B> Typed<B> writeAndReadTypedOrThrow(Typed<A> var0, Type<B> var1, UnaryOperator<Dynamic<?>> var2) {
        Dynamic var3 = (Dynamic)var0.write().getOrThrow();
        return SystemUtils.readTypedOrThrow(var1, (Dynamic)var2.apply(var3), true);
    }

    public static <T> Typed<T> readTypedOrThrow(Type<T> var0, Dynamic<?> var1) {
        return SystemUtils.readTypedOrThrow(var0, var1, false);
    }

    public static <T> Typed<T> readTypedOrThrow(Type<T> var0, Dynamic<?> var1, boolean var2) {
        DataResult var3 = var0.readTyped(var1).map(Pair::getFirst);
        try {
            if (var2) {
                return (Typed)var3.getPartialOrThrow(IllegalStateException::new);
            }
            return (Typed)var3.getOrThrow(IllegalStateException::new);
        }
        catch (IllegalStateException var4) {
            CrashReport var5 = CrashReport.forThrowable(var4, "Reading type");
            CrashReportSystemDetails var6 = var5.addCategory("Info");
            var6.setDetail("Data", var1);
            var6.setDetail("Type", var0);
            throw new ReportedException(var5);
        }
    }

    public static <T> List<T> copyAndAdd(List<T> var0, T var1) {
        return ImmutableList.builderWithExpectedSize((int)(var0.size() + 1)).addAll(var0).add(var1).build();
    }

    public static <T> List<T> copyAndAdd(T var0, List<T> var1) {
        return ImmutableList.builderWithExpectedSize((int)(var1.size() + 1)).add(var0).addAll(var1).build();
    }

    public static <K, V> Map<K, V> copyAndPut(Map<K, V> var0, K var1, V var2) {
        return ImmutableMap.builderWithExpectedSize((int)(var0.size() + 1)).putAll(var0).put(var1, var2).buildKeepingLast();
    }

    public static sealed class OS
    extends Enum<OS> {
        public static final /* enum */ OS LINUX = new OS("linux");
        public static final /* enum */ OS SOLARIS = new OS("solaris");
        public static final /* enum */ OS WINDOWS = new OS("windows"){

            @Override
            protected String[] getOpenUriArguments(URI var0) {
                return new String[]{"rundll32", "url.dll,FileProtocolHandler", var0.toString()};
            }
        };
        public static final /* enum */ OS OSX = new OS("mac"){

            @Override
            protected String[] getOpenUriArguments(URI var0) {
                return new String[]{"open", var0.toString()};
            }
        };
        public static final /* enum */ OS UNKNOWN = new OS("unknown");
        private final String telemetryName;
        private static final /* synthetic */ OS[] g;

        public static OS[] values() {
            return (OS[])g.clone();
        }

        public static OS valueOf(String var0) {
            return Enum.valueOf(OS.class, var0);
        }

        OS(String var2) {
            this.telemetryName = var2;
        }

        public void openUri(URI var0) {
            try {
                Process var1 = AccessController.doPrivileged(() -> Runtime.getRuntime().exec(this.getOpenUriArguments(var0)));
                var1.getInputStream().close();
                var1.getErrorStream().close();
                var1.getOutputStream().close();
            }
            catch (IOException | PrivilegedActionException var1) {
                LOGGER.error("Couldn't open location '{}'", (Object)var0, (Object)var1);
            }
        }

        public void openFile(File var0) {
            this.openUri(var0.toURI());
        }

        public void openPath(Path var0) {
            this.openUri(var0.toUri());
        }

        protected String[] getOpenUriArguments(URI var0) {
            String var1 = var0.toString();
            if ("file".equals(var0.getScheme())) {
                var1 = var1.replace("file:", "file://");
            }
            return new String[]{"xdg-open", var1};
        }

        public void openUri(String var0) {
            try {
                this.openUri(new URI(var0));
            }
            catch (IllegalArgumentException | URISyntaxException var1) {
                LOGGER.error("Couldn't open uri '{}'", (Object)var0, (Object)var1);
            }
        }

        public String telemetryName() {
            return this.telemetryName;
        }

        private static /* synthetic */ OS[] b() {
            return new OS[]{LINUX, SOLARIS, WINDOWS, OSX, UNKNOWN};
        }

        static {
            g = OS.b();
        }
    }
}

