/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.mojang.logging.LogUtils;
import java.util.Collection;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.NumberFormatTypes;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.slf4j.Logger;

public class PersistentScoreboard
extends PersistentBase {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String FILE_ID = "scoreboard";
    private final Scoreboard scoreboard;

    public PersistentScoreboard(Scoreboard var0) {
        this.scoreboard = var0;
    }

    public PersistentScoreboard load(NBTTagCompound var0, HolderLookup.a var1) {
        this.loadObjectives(var0.getList("Objectives", 10), var1);
        this.scoreboard.loadPlayerScores(var0.getList("PlayerScores", 10), var1);
        if (var0.contains("DisplaySlots", 10)) {
            this.loadDisplaySlots(var0.getCompound("DisplaySlots"));
        }
        if (var0.contains("Teams", 9)) {
            this.loadTeams(var0.getList("Teams", 10), var1);
        }
        return this;
    }

    private void loadTeams(NBTTagList var0, HolderLookup.a var1) {
        for (int var2 = 0; var2 < var0.size(); ++var2) {
            Object var7;
            NBTTagCompound var3 = var0.getCompound(var2);
            String var4 = var3.getString("Name");
            ScoreboardTeam var5 = this.scoreboard.addPlayerTeam(var4);
            IChatMutableComponent var6 = IChatBaseComponent.ChatSerializer.fromJson(var3.getString("DisplayName"), var1);
            if (var6 != null) {
                var5.setDisplayName(var6);
            }
            if (var3.contains("TeamColor", 8)) {
                var5.setColor(EnumChatFormat.getByName(var3.getString("TeamColor")));
            }
            if (var3.contains("AllowFriendlyFire", 99)) {
                var5.setAllowFriendlyFire(var3.getBoolean("AllowFriendlyFire"));
            }
            if (var3.contains("SeeFriendlyInvisibles", 99)) {
                var5.setSeeFriendlyInvisibles(var3.getBoolean("SeeFriendlyInvisibles"));
            }
            if (var3.contains("MemberNamePrefix", 8) && (var7 = IChatBaseComponent.ChatSerializer.fromJson(var3.getString("MemberNamePrefix"), var1)) != null) {
                var5.setPlayerPrefix((IChatBaseComponent)var7);
            }
            if (var3.contains("MemberNameSuffix", 8) && (var7 = IChatBaseComponent.ChatSerializer.fromJson(var3.getString("MemberNameSuffix"), var1)) != null) {
                var5.setPlayerSuffix((IChatBaseComponent)var7);
            }
            if (var3.contains("NameTagVisibility", 8) && (var7 = ScoreboardTeamBase.EnumNameTagVisibility.byName(var3.getString("NameTagVisibility"))) != null) {
                var5.setNameTagVisibility((ScoreboardTeamBase.EnumNameTagVisibility)((Object)var7));
            }
            if (var3.contains("DeathMessageVisibility", 8) && (var7 = ScoreboardTeamBase.EnumNameTagVisibility.byName(var3.getString("DeathMessageVisibility"))) != null) {
                var5.setDeathMessageVisibility((ScoreboardTeamBase.EnumNameTagVisibility)((Object)var7));
            }
            if (var3.contains("CollisionRule", 8) && (var7 = ScoreboardTeamBase.EnumTeamPush.byName(var3.getString("CollisionRule"))) != null) {
                var5.setCollisionRule((ScoreboardTeamBase.EnumTeamPush)((Object)var7));
            }
            this.loadTeamPlayers(var5, var3.getList("Players", 8));
        }
    }

    private void loadTeamPlayers(ScoreboardTeam var0, NBTTagList var1) {
        for (int var2 = 0; var2 < var1.size(); ++var2) {
            this.scoreboard.addPlayerToTeam(var1.getString(var2), var0);
        }
    }

    private void loadDisplaySlots(NBTTagCompound var0) {
        for (String var2 : var0.getAllKeys()) {
            DisplaySlot var3 = DisplaySlot.CODEC.byName(var2);
            if (var3 == null) continue;
            String var4 = var0.getString(var2);
            ScoreboardObjective var5 = this.scoreboard.getObjective(var4);
            this.scoreboard.setDisplayObjective(var3, var5);
        }
    }

    private void loadObjectives(NBTTagList var0, HolderLookup.a var1) {
        for (int var2 = 0; var2 < var0.size(); ++var2) {
            NBTTagCompound var3 = var0.getCompound(var2);
            String var4 = var3.getString("CriteriaName");
            IScoreboardCriteria var5 = IScoreboardCriteria.byName(var4).orElseGet(() -> {
                LOGGER.warn("Unknown scoreboard criteria {}, replacing with {}", (Object)var4, (Object)IScoreboardCriteria.DUMMY.getName());
                return IScoreboardCriteria.DUMMY;
            });
            String var6 = var3.getString("Name");
            IChatMutableComponent var7 = IChatBaseComponent.ChatSerializer.fromJson(var3.getString("DisplayName"), var1);
            IScoreboardCriteria.EnumScoreboardHealthDisplay var8 = IScoreboardCriteria.EnumScoreboardHealthDisplay.byId(var3.getString("RenderType"));
            boolean var9 = var3.getBoolean("display_auto_update");
            NumberFormat var10 = NumberFormatTypes.CODEC.parse(var1.createSerializationContext(DynamicOpsNBT.INSTANCE), (Object)var3.get("format")).result().orElse(null);
            this.scoreboard.addObjective(var6, var5, var7, var8, var9, var10);
        }
    }

    @Override
    public NBTTagCompound save(NBTTagCompound var0, HolderLookup.a var1) {
        var0.put("Objectives", this.saveObjectives(var1));
        var0.put("PlayerScores", this.scoreboard.savePlayerScores(var1));
        var0.put("Teams", this.saveTeams(var1));
        this.saveDisplaySlots(var0);
        return var0;
    }

    private NBTTagList saveTeams(HolderLookup.a var0) {
        NBTTagList var1 = new NBTTagList();
        Collection<ScoreboardTeam> var2 = this.scoreboard.getPlayerTeams();
        for (ScoreboardTeam var4 : var2) {
            NBTTagCompound var5 = new NBTTagCompound();
            var5.putString("Name", var4.getName());
            var5.putString("DisplayName", IChatBaseComponent.ChatSerializer.toJson(var4.getDisplayName(), var0));
            if (var4.getColor().getId() >= 0) {
                var5.putString("TeamColor", var4.getColor().getName());
            }
            var5.putBoolean("AllowFriendlyFire", var4.isAllowFriendlyFire());
            var5.putBoolean("SeeFriendlyInvisibles", var4.canSeeFriendlyInvisibles());
            var5.putString("MemberNamePrefix", IChatBaseComponent.ChatSerializer.toJson(var4.getPlayerPrefix(), var0));
            var5.putString("MemberNameSuffix", IChatBaseComponent.ChatSerializer.toJson(var4.getPlayerSuffix(), var0));
            var5.putString("NameTagVisibility", var4.getNameTagVisibility().name);
            var5.putString("DeathMessageVisibility", var4.getDeathMessageVisibility().name);
            var5.putString("CollisionRule", var4.getCollisionRule().name);
            NBTTagList var6 = new NBTTagList();
            for (String var8 : var4.getPlayers()) {
                var6.add(NBTTagString.valueOf(var8));
            }
            var5.put("Players", var6);
            var1.add(var5);
        }
        return var1;
    }

    private void saveDisplaySlots(NBTTagCompound var0) {
        NBTTagCompound var1 = new NBTTagCompound();
        for (DisplaySlot var5 : DisplaySlot.values()) {
            ScoreboardObjective var6 = this.scoreboard.getDisplayObjective(var5);
            if (var6 == null) continue;
            var1.putString(var5.getSerializedName(), var6.getName());
        }
        if (!var1.isEmpty()) {
            var0.put("DisplaySlots", var1);
        }
    }

    private NBTTagList saveObjectives(HolderLookup.a var0) {
        NBTTagList var12 = new NBTTagList();
        Collection<ScoreboardObjective> var2 = this.scoreboard.getObjectives();
        for (ScoreboardObjective var4 : var2) {
            NBTTagCompound var5 = new NBTTagCompound();
            var5.putString("Name", var4.getName());
            var5.putString("CriteriaName", var4.getCriteria().getName());
            var5.putString("DisplayName", IChatBaseComponent.ChatSerializer.toJson(var4.getDisplayName(), var0));
            var5.putString("RenderType", var4.getRenderType().getId());
            var5.putBoolean("display_auto_update", var4.displayAutoUpdate());
            NumberFormat var6 = var4.numberFormat();
            if (var6 != null) {
                NumberFormatTypes.CODEC.encodeStart(var0.createSerializationContext(DynamicOpsNBT.INSTANCE), (Object)var6).ifSuccess(var1 -> var5.put("format", (NBTBase)var1));
            }
            var12.add(var5);
        }
        return var12;
    }
}

