/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class LootItemFunctionEnchant
extends LootItemFunctionConditional {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<LootItemFunctionEnchant> CODEC = RecordCodecBuilder.mapCodec(var02 -> LootItemFunctionEnchant.commonFields(var02).and(var02.group((App)RegistryCodecs.homogeneousList(Registries.ENCHANTMENT).optionalFieldOf("options").forGetter(var0 -> var0.options), (App)Codec.BOOL.optionalFieldOf("only_compatible", (Object)true).forGetter(var0 -> var0.onlyCompatible))).apply((Applicative)var02, LootItemFunctionEnchant::new));
    private final Optional<HolderSet<Enchantment>> options;
    private final boolean onlyCompatible;

    LootItemFunctionEnchant(List<LootItemCondition> var0, Optional<HolderSet<Enchantment>> var1, boolean var2) {
        super(var0);
        this.options = var1;
        this.onlyCompatible = var2;
    }

    public LootItemFunctionType<LootItemFunctionEnchant> getType() {
        return LootItemFunctions.ENCHANT_RANDOMLY;
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        RandomSource var22 = var1.getRandom();
        boolean var3 = var0.is(Items.BOOK);
        boolean var4 = !var3 && this.onlyCompatible;
        Stream<Holder> var5 = this.options.map(HolderSet::stream).orElseGet(() -> var1.getLevel().registryAccess().registryOrThrow(Registries.ENCHANTMENT).holders().map(Function.identity())).filter(var2 -> !var4 || ((Enchantment)var2.value()).canEnchant(var0));
        List<Holder> var6 = var5.toList();
        Optional<Holder> var7 = SystemUtils.getRandomSafe(var6, var22);
        if (var7.isEmpty()) {
            LOGGER.warn("Couldn't find a compatible enchantment for {}", (Object)var0);
            return var0;
        }
        return LootItemFunctionEnchant.enchantItem(var0, var7.get(), var22);
    }

    private static ItemStack enchantItem(ItemStack var0, Holder<Enchantment> var1, RandomSource var2) {
        int var3 = MathHelper.nextInt(var2, var1.value().getMinLevel(), var1.value().getMaxLevel());
        if (var0.is(Items.BOOK)) {
            var0 = new ItemStack(Items.ENCHANTED_BOOK);
        }
        var0.enchant(var1, var3);
        return var0;
    }

    public static a randomEnchantment() {
        return new a();
    }

    public static a randomApplicableEnchantment(HolderLookup.a var0) {
        return LootItemFunctionEnchant.randomEnchantment().withOneOf(var0.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(EnchantmentTags.ON_RANDOM_LOOT));
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private Optional<HolderSet<Enchantment>> options = Optional.empty();
        private boolean onlyCompatible = true;

        @Override
        protected a getThis() {
            return this;
        }

        public a withEnchantment(Holder<Enchantment> var0) {
            this.options = Optional.of(HolderSet.direct(var0));
            return this;
        }

        public a withOneOf(HolderSet<Enchantment> var0) {
            this.options = Optional.of(var0);
            return this;
        }

        public a allowingIncompatibleEnchantments() {
            this.onlyCompatible = false;
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootItemFunctionEnchant(this.getConditions(), this.options, this.onlyCompatible);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }
}

