/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionApplyBonus
extends LootItemFunctionConditional {
    private static final Map<MinecraftKey, c> FORMULAS = Stream.of(a.TYPE, d.TYPE, e.TYPE).collect(Collectors.toMap(c::id, Function.identity()));
    private static final Codec<c> FORMULA_TYPE_CODEC = MinecraftKey.CODEC.comapFlatMap(var0 -> {
        c var1 = FORMULAS.get(var0);
        if (var1 != null) {
            return DataResult.success((Object)var1);
        }
        return DataResult.error(() -> "No formula type with id: '" + String.valueOf(var0) + "'");
    }, c::id);
    private static final MapCodec<b> FORMULA_CODEC = ExtraCodecs.dispatchOptionalValue("formula", "parameters", FORMULA_TYPE_CODEC, b::getType, c::codec);
    public static final MapCodec<LootItemFunctionApplyBonus> CODEC = RecordCodecBuilder.mapCodec(var02 -> LootItemFunctionApplyBonus.commonFields(var02).and(var02.group((App)Enchantment.CODEC.fieldOf("enchantment").forGetter(var0 -> var0.enchantment), (App)FORMULA_CODEC.forGetter(var0 -> var0.formula))).apply((Applicative)var02, LootItemFunctionApplyBonus::new));
    private final Holder<Enchantment> enchantment;
    private final b formula;

    private LootItemFunctionApplyBonus(List<LootItemCondition> var0, Holder<Enchantment> var1, b var2) {
        super(var0);
        this.enchantment = var1;
        this.formula = var2;
    }

    public LootItemFunctionType<LootItemFunctionApplyBonus> getType() {
        return LootItemFunctions.APPLY_BONUS;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return ImmutableSet.of(LootContextParameters.TOOL);
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        ItemStack var2 = var1.getParamOrNull(LootContextParameters.TOOL);
        if (var2 != null) {
            int var3 = EnchantmentManager.getItemEnchantmentLevel(this.enchantment, var2);
            int var4 = this.formula.calculateNewCount(var1.getRandom(), var0.getCount(), var3);
            var0.setCount(var4);
        }
        return var0;
    }

    public static LootItemFunctionConditional.a<?> addBonusBinomialDistributionCount(Holder<Enchantment> var0, float var1, int var2) {
        return LootItemFunctionApplyBonus.simpleBuilder(var3 -> new LootItemFunctionApplyBonus((List<LootItemCondition>)var3, var0, new a(var2, var1)));
    }

    public static LootItemFunctionConditional.a<?> addOreBonusCount(Holder<Enchantment> var0) {
        return LootItemFunctionApplyBonus.simpleBuilder(var1 -> new LootItemFunctionApplyBonus((List<LootItemCondition>)var1, var0, new d()));
    }

    public static LootItemFunctionConditional.a<?> addUniformBonusCount(Holder<Enchantment> var0) {
        return LootItemFunctionApplyBonus.simpleBuilder(var1 -> new LootItemFunctionApplyBonus((List<LootItemCondition>)var1, var0, new e(1)));
    }

    public static LootItemFunctionConditional.a<?> addUniformBonusCount(Holder<Enchantment> var0, int var1) {
        return LootItemFunctionApplyBonus.simpleBuilder(var2 -> new LootItemFunctionApplyBonus((List<LootItemCondition>)var2, var0, new e(var1)));
    }

    static interface b {
        public int calculateNewCount(RandomSource var1, int var2, int var3);

        public c getType();
    }

    record e(int bonusMultiplier) implements b
    {
        public static final Codec<e> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.INT.fieldOf("bonusMultiplier").forGetter(e::bonusMultiplier)).apply((Applicative)var0, e::new));
        public static final c TYPE = new c(MinecraftKey.withDefaultNamespace("uniform_bonus_count"), CODEC);

        @Override
        public int calculateNewCount(RandomSource var0, int var1, int var2) {
            return var1 + var0.nextInt(this.bonusMultiplier * var2 + 1);
        }

        @Override
        public c getType() {
            return TYPE;
        }
    }

    record d() implements b
    {
        public static final Codec<d> CODEC = Codec.unit(d::new);
        public static final c TYPE = new c(MinecraftKey.withDefaultNamespace("ore_drops"), CODEC);

        @Override
        public int calculateNewCount(RandomSource var0, int var1, int var2) {
            if (var2 > 0) {
                int var3 = var0.nextInt(var2 + 2) - 1;
                if (var3 < 0) {
                    var3 = 0;
                }
                return var1 * (var3 + 1);
            }
            return var1;
        }

        @Override
        public c getType() {
            return TYPE;
        }
    }

    record a(int extraRounds, float probability) implements b
    {
        private static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.INT.fieldOf("extra").forGetter(a::extraRounds), (App)Codec.FLOAT.fieldOf("probability").forGetter(a::probability)).apply((Applicative)var0, a::new));
        public static final c TYPE = new c(MinecraftKey.withDefaultNamespace("binomial_with_bonus_count"), CODEC);

        @Override
        public int calculateNewCount(RandomSource var0, int var1, int var2) {
            for (int var3 = 0; var3 < var2 + this.extraRounds; ++var3) {
                if (!(var0.nextFloat() < this.probability)) continue;
                ++var1;
            }
            return var1;
        }

        @Override
        public c getType() {
            return TYPE;
        }
    }

    record c(MinecraftKey id, Codec<? extends b> codec) {
    }
}

