/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3D;

public record DimensionTransition(WorldServer newLevel, Vec3D pos, Vec3D speed, float yRot, float xRot, boolean missingRespawnBlock, a postDimensionTransition) {
    public static final a DO_NOTHING = var0 -> {};
    public static final a PLAY_PORTAL_SOUND = DimensionTransition::playPortalSound;
    public static final a PLACE_PORTAL_TICKET = DimensionTransition::placePortalTicket;

    public DimensionTransition(WorldServer var0, Vec3D var1, Vec3D var2, float var3, float var4, a var5) {
        this(var0, var1, var2, var3, var4, false, var5);
    }

    public DimensionTransition(WorldServer var0, Entity var1, a var2) {
        this(var0, DimensionTransition.findAdjustedSharedSpawnPos(var0, var1), Vec3D.ZERO, 0.0f, 0.0f, false, var2);
    }

    private static void playPortalSound(Entity var0) {
        if (var0 instanceof EntityPlayer) {
            EntityPlayer var1 = (EntityPlayer)var0;
            var1.connection.send(new PacketPlayOutWorldEvent(1032, BlockPosition.ZERO, 0, false));
        }
    }

    private static void placePortalTicket(Entity var0) {
        var0.placePortalTicket(BlockPosition.containing(var0.position()));
    }

    public static DimensionTransition missingRespawnBlock(WorldServer var0, Entity var1, a var2) {
        return new DimensionTransition(var0, DimensionTransition.findAdjustedSharedSpawnPos(var0, var1), Vec3D.ZERO, 0.0f, 0.0f, true, var2);
    }

    private static Vec3D findAdjustedSharedSpawnPos(WorldServer var0, Entity var1) {
        return var1.adjustSpawnLocation(var0, var0.getSharedSpawnPos()).getBottomCenter();
    }

    @FunctionalInterface
    public static interface a {
        public void onTransition(Entity var1);

        default public a then(a var0) {
            return var1 -> {
                this.onTransition(var1);
                var0.onTransition(var1);
            };
        }
    }
}

