/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolEmpty;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolFeature;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolLegacySingle;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolList;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolSingle;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePools;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public abstract class WorldGenFeatureDefinedStructurePoolStructure {
    public static final Codec<WorldGenFeatureDefinedStructurePoolStructure> CODEC = BuiltInRegistries.STRUCTURE_POOL_ELEMENT.byNameCodec().dispatch("element_type", WorldGenFeatureDefinedStructurePoolStructure::getType, WorldGenFeatureDefinedStructurePools::codec);
    private static final Holder<ProcessorList> EMPTY = Holder.direct(new ProcessorList(List.of()));
    @Nullable
    private volatile WorldGenFeatureDefinedStructurePoolTemplate.Matching projection;

    protected static <E extends WorldGenFeatureDefinedStructurePoolStructure> RecordCodecBuilder<E, WorldGenFeatureDefinedStructurePoolTemplate.Matching> projectionCodec() {
        return WorldGenFeatureDefinedStructurePoolTemplate.Matching.CODEC.fieldOf("projection").forGetter(WorldGenFeatureDefinedStructurePoolStructure::getProjection);
    }

    protected WorldGenFeatureDefinedStructurePoolStructure(WorldGenFeatureDefinedStructurePoolTemplate.Matching var0) {
        this.projection = var0;
    }

    public abstract BaseBlockPosition getSize(StructureTemplateManager var1, EnumBlockRotation var2);

    public abstract List<DefinedStructure.BlockInfo> getShuffledJigsawBlocks(StructureTemplateManager var1, BlockPosition var2, EnumBlockRotation var3, RandomSource var4);

    public abstract StructureBoundingBox getBoundingBox(StructureTemplateManager var1, BlockPosition var2, EnumBlockRotation var3);

    public abstract boolean place(StructureTemplateManager var1, GeneratorAccessSeed var2, StructureManager var3, ChunkGenerator var4, BlockPosition var5, BlockPosition var6, EnumBlockRotation var7, StructureBoundingBox var8, RandomSource var9, LiquidSettings var10, boolean var11);

    public abstract WorldGenFeatureDefinedStructurePools<?> getType();

    public void handleDataMarker(GeneratorAccess var0, DefinedStructure.BlockInfo var1, BlockPosition var2, EnumBlockRotation var3, RandomSource var4, StructureBoundingBox var5) {
    }

    public WorldGenFeatureDefinedStructurePoolStructure setProjection(WorldGenFeatureDefinedStructurePoolTemplate.Matching var0) {
        this.projection = var0;
        return this;
    }

    public WorldGenFeatureDefinedStructurePoolTemplate.Matching getProjection() {
        WorldGenFeatureDefinedStructurePoolTemplate.Matching var0 = this.projection;
        if (var0 == null) {
            throw new IllegalStateException();
        }
        return var0;
    }

    public int getGroundLevelDelta() {
        return 1;
    }

    public static Function<WorldGenFeatureDefinedStructurePoolTemplate.Matching, WorldGenFeatureDefinedStructurePoolEmpty> empty() {
        return var0 -> WorldGenFeatureDefinedStructurePoolEmpty.INSTANCE;
    }

    public static Function<WorldGenFeatureDefinedStructurePoolTemplate.Matching, WorldGenFeatureDefinedStructurePoolLegacySingle> legacy(String var0) {
        return var1 -> new WorldGenFeatureDefinedStructurePoolLegacySingle((Either<MinecraftKey, DefinedStructure>)Either.left((Object)MinecraftKey.parse(var0)), EMPTY, (WorldGenFeatureDefinedStructurePoolTemplate.Matching)var1, Optional.empty());
    }

    public static Function<WorldGenFeatureDefinedStructurePoolTemplate.Matching, WorldGenFeatureDefinedStructurePoolLegacySingle> legacy(String var0, Holder<ProcessorList> var1) {
        return var2 -> new WorldGenFeatureDefinedStructurePoolLegacySingle((Either<MinecraftKey, DefinedStructure>)Either.left((Object)MinecraftKey.parse(var0)), var1, (WorldGenFeatureDefinedStructurePoolTemplate.Matching)var2, Optional.empty());
    }

    public static Function<WorldGenFeatureDefinedStructurePoolTemplate.Matching, WorldGenFeatureDefinedStructurePoolSingle> single(String var0) {
        return var1 -> new WorldGenFeatureDefinedStructurePoolSingle((Either<MinecraftKey, DefinedStructure>)Either.left((Object)MinecraftKey.parse(var0)), EMPTY, (WorldGenFeatureDefinedStructurePoolTemplate.Matching)var1, Optional.empty());
    }

    public static Function<WorldGenFeatureDefinedStructurePoolTemplate.Matching, WorldGenFeatureDefinedStructurePoolSingle> single(String var0, Holder<ProcessorList> var1) {
        return var2 -> new WorldGenFeatureDefinedStructurePoolSingle((Either<MinecraftKey, DefinedStructure>)Either.left((Object)MinecraftKey.parse(var0)), var1, (WorldGenFeatureDefinedStructurePoolTemplate.Matching)var2, Optional.empty());
    }

    public static Function<WorldGenFeatureDefinedStructurePoolTemplate.Matching, WorldGenFeatureDefinedStructurePoolSingle> single(String var0, LiquidSettings var1) {
        return var2 -> new WorldGenFeatureDefinedStructurePoolSingle((Either<MinecraftKey, DefinedStructure>)Either.left((Object)MinecraftKey.parse(var0)), EMPTY, (WorldGenFeatureDefinedStructurePoolTemplate.Matching)var2, Optional.of(var1));
    }

    public static Function<WorldGenFeatureDefinedStructurePoolTemplate.Matching, WorldGenFeatureDefinedStructurePoolSingle> single(String var0, Holder<ProcessorList> var1, LiquidSettings var2) {
        return var3 -> new WorldGenFeatureDefinedStructurePoolSingle((Either<MinecraftKey, DefinedStructure>)Either.left((Object)MinecraftKey.parse(var0)), var1, (WorldGenFeatureDefinedStructurePoolTemplate.Matching)var3, Optional.of(var2));
    }

    public static Function<WorldGenFeatureDefinedStructurePoolTemplate.Matching, WorldGenFeatureDefinedStructurePoolFeature> feature(Holder<PlacedFeature> var0) {
        return var1 -> new WorldGenFeatureDefinedStructurePoolFeature(var0, (WorldGenFeatureDefinedStructurePoolTemplate.Matching)var1);
    }

    public static Function<WorldGenFeatureDefinedStructurePoolTemplate.Matching, WorldGenFeatureDefinedStructurePoolList> list(List<Function<WorldGenFeatureDefinedStructurePoolTemplate.Matching, ? extends WorldGenFeatureDefinedStructurePoolStructure>> var0) {
        return var12 -> new WorldGenFeatureDefinedStructurePoolList(var0.stream().map(var1 -> (WorldGenFeatureDefinedStructurePoolStructure)var1.apply(var12)).collect(Collectors.toList()), (WorldGenFeatureDefinedStructurePoolTemplate.Matching)var12);
    }
}

