/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.foliageplacers;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.levelgen.feature.WorldGenTrees;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacers;
import net.minecraft.world.level.material.FluidTypes;

public abstract class WorldGenFoilagePlacer {
    public static final Codec<WorldGenFoilagePlacer> CODEC = BuiltInRegistries.FOLIAGE_PLACER_TYPE.byNameCodec().dispatch(WorldGenFoilagePlacer::type, WorldGenFoilagePlacers::codec);
    protected final IntProvider radius;
    protected final IntProvider offset;

    protected static <P extends WorldGenFoilagePlacer> Products.P2<RecordCodecBuilder.Mu<P>, IntProvider, IntProvider> foliagePlacerParts(RecordCodecBuilder.Instance<P> var02) {
        return var02.group((App)IntProvider.codec(0, 16).fieldOf("radius").forGetter(var0 -> var0.radius), (App)IntProvider.codec(0, 16).fieldOf("offset").forGetter(var0 -> var0.offset));
    }

    public WorldGenFoilagePlacer(IntProvider var0, IntProvider var1) {
        this.radius = var0;
        this.offset = var1;
    }

    protected abstract WorldGenFoilagePlacers<?> type();

    public void createFoliage(VirtualLevelReadable var0, b var1, RandomSource var2, WorldGenFeatureTreeConfiguration var3, int var4, a var5, int var6, int var7) {
        this.createFoliage(var0, var1, var2, var3, var4, var5, var6, var7, this.offset(var2));
    }

    protected abstract void createFoliage(VirtualLevelReadable var1, b var2, RandomSource var3, WorldGenFeatureTreeConfiguration var4, int var5, a var6, int var7, int var8, int var9);

    public abstract int foliageHeight(RandomSource var1, int var2, WorldGenFeatureTreeConfiguration var3);

    public int foliageRadius(RandomSource var0, int var1) {
        return this.radius.sample(var0);
    }

    private int offset(RandomSource var0) {
        return this.offset.sample(var0);
    }

    protected abstract boolean shouldSkipLocation(RandomSource var1, int var2, int var3, int var4, int var5, boolean var6);

    protected boolean shouldSkipLocationSigned(RandomSource var0, int var1, int var2, int var3, int var4, boolean var5) {
        int var7;
        int var6;
        if (var5) {
            var6 = Math.min(Math.abs(var1), Math.abs(var1 - 1));
            var7 = Math.min(Math.abs(var3), Math.abs(var3 - 1));
        } else {
            var6 = Math.abs(var1);
            var7 = Math.abs(var3);
        }
        return this.shouldSkipLocation(var0, var6, var2, var7, var4, var5);
    }

    protected void placeLeavesRow(VirtualLevelReadable var0, b var1, RandomSource var2, WorldGenFeatureTreeConfiguration var3, BlockPosition var4, int var5, int var6, boolean var7) {
        int var8 = var7 ? 1 : 0;
        BlockPosition.MutableBlockPosition var9 = new BlockPosition.MutableBlockPosition();
        for (int var10 = -var5; var10 <= var5 + var8; ++var10) {
            for (int var11 = -var5; var11 <= var5 + var8; ++var11) {
                if (this.shouldSkipLocationSigned(var2, var10, var6, var11, var5, var7)) continue;
                var9.setWithOffset(var4, var10, var6, var11);
                WorldGenFoilagePlacer.tryPlaceLeaf(var0, var1, var2, var3, var9);
            }
        }
    }

    protected final void placeLeavesRowWithHangingLeavesBelow(VirtualLevelReadable var0, b var1, RandomSource var2, WorldGenFeatureTreeConfiguration var3, BlockPosition var4, int var5, int var6, boolean var7, float var8, float var9) {
        this.placeLeavesRow(var0, var1, var2, var3, var4, var5, var6, var7);
        int var10 = var7 ? 1 : 0;
        BlockPosition var11 = var4.below();
        BlockPosition.MutableBlockPosition var12 = new BlockPosition.MutableBlockPosition();
        for (EnumDirection var14 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            EnumDirection var15 = var14.getClockWise();
            int var16 = var15.getAxisDirection() == EnumDirection.EnumAxisDirection.POSITIVE ? var5 + var10 : var5;
            var12.setWithOffset(var4, 0, var6 - 1, 0).move(var15, var16).move(var14, -var5);
            for (int var17 = -var5; var17 < var5 + var10; ++var17) {
                boolean var18 = var1.isSet(var12.move(EnumDirection.UP));
                var12.move(EnumDirection.DOWN);
                if (var18 && WorldGenFoilagePlacer.tryPlaceExtension(var0, var1, var2, var3, var8, var11, var12)) {
                    var12.move(EnumDirection.DOWN);
                    WorldGenFoilagePlacer.tryPlaceExtension(var0, var1, var2, var3, var9, var11, var12);
                    var12.move(EnumDirection.UP);
                }
                var12.move(var14);
            }
        }
    }

    private static boolean tryPlaceExtension(VirtualLevelReadable var0, b var1, RandomSource var2, WorldGenFeatureTreeConfiguration var3, float var4, BlockPosition var5, BlockPosition.MutableBlockPosition var6) {
        if (var6.distManhattan(var5) >= 7) {
            return false;
        }
        if (var2.nextFloat() > var4) {
            return false;
        }
        return WorldGenFoilagePlacer.tryPlaceLeaf(var0, var1, var2, var3, var6);
    }

    protected static boolean tryPlaceLeaf(VirtualLevelReadable var02, b var1, RandomSource var2, WorldGenFeatureTreeConfiguration var3, BlockPosition var4) {
        if (!WorldGenTrees.validTreePos(var02, var4)) {
            return false;
        }
        IBlockData var5 = var3.foliageProvider.getState(var2, var4);
        if (var5.hasProperty(BlockProperties.WATERLOGGED)) {
            var5 = (IBlockData)var5.setValue(BlockProperties.WATERLOGGED, var02.isFluidAtPosition(var4, var0 -> var0.isSourceOfType(FluidTypes.WATER)));
        }
        var1.set(var4, var5);
        return true;
    }

    public static interface b {
        public void set(BlockPosition var1, IBlockData var2);

        public boolean isSet(BlockPosition var1);
    }

    public static final class a {
        private final BlockPosition pos;
        private final int radiusOffset;
        private final boolean doubleTrunk;

        public a(BlockPosition var0, int var1, boolean var2) {
            this.pos = var0;
            this.radiusOffset = var1;
            this.doubleTrunk = var2;
        }

        public BlockPosition pos() {
            return this.pos;
        }

        public int radiusOffset() {
            return this.radiusOffset;
        }

        public boolean doubleTrunk() {
            return this.doubleTrunk;
        }
    }
}

