/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public final class TrialSpawner {
    public static final String NORMAL_CONFIG_TAG_NAME = "normal_config";
    public static final String OMINOUS_CONFIG_TAG_NAME = "ominous_config";
    public static final int DETECT_PLAYER_SPAWN_BUFFER = 40;
    private static final int DEFAULT_TARGET_COOLDOWN_LENGTH = 36000;
    private static final int DEFAULT_PLAYER_SCAN_RANGE = 14;
    private static final int MAX_MOB_TRACKING_DISTANCE = 47;
    private static final int MAX_MOB_TRACKING_DISTANCE_SQR = MathHelper.square(47);
    private static final float SPAWNING_AMBIENT_SOUND_CHANCE = 0.02f;
    public TrialSpawnerConfig normalConfig;
    public TrialSpawnerConfig ominousConfig;
    private final TrialSpawnerData data;
    public int requiredPlayerRange;
    public int targetCooldownLength;
    public final b stateAccessor;
    private PlayerDetector playerDetector;
    private final PlayerDetector.a entitySelector;
    private boolean overridePeacefulAndMobSpawnRule;
    public boolean isOminous;

    public Codec<TrialSpawner> codec() {
        return RecordCodecBuilder.create(var02 -> var02.group((App)TrialSpawnerConfig.CODEC.optionalFieldOf(NORMAL_CONFIG_TAG_NAME, (Object)TrialSpawnerConfig.DEFAULT).forGetter(TrialSpawner::getNormalConfig), (App)TrialSpawnerConfig.CODEC.optionalFieldOf(OMINOUS_CONFIG_TAG_NAME, (Object)TrialSpawnerConfig.DEFAULT).forGetter(TrialSpawner::getOminousConfigForSerialization), (App)TrialSpawnerData.MAP_CODEC.forGetter(TrialSpawner::getData), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("target_cooldown_length", (Object)36000).forGetter(TrialSpawner::getTargetCooldownLength), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("required_player_range", (Object)14).forGetter(TrialSpawner::getRequiredPlayerRange)).apply((Applicative)var02, (var0, var1, var2, var3, var4) -> new TrialSpawner((TrialSpawnerConfig)var0, (TrialSpawnerConfig)var1, (TrialSpawnerData)var2, (int)var3, (int)var4, this.stateAccessor, this.playerDetector, this.entitySelector)));
    }

    public TrialSpawner(b var0, PlayerDetector var1, PlayerDetector.a var2) {
        this(TrialSpawnerConfig.DEFAULT, TrialSpawnerConfig.DEFAULT, new TrialSpawnerData(), 36000, 14, var0, var1, var2);
    }

    public TrialSpawner(TrialSpawnerConfig var0, TrialSpawnerConfig var1, TrialSpawnerData var2, int var3, int var4, b var5, PlayerDetector var6, PlayerDetector.a var7) {
        this.normalConfig = var0;
        this.ominousConfig = var1;
        this.data = var2;
        this.targetCooldownLength = var3;
        this.requiredPlayerRange = var4;
        this.stateAccessor = var5;
        this.playerDetector = var6;
        this.entitySelector = var7;
    }

    public TrialSpawnerConfig getConfig() {
        return this.isOminous ? this.ominousConfig : this.normalConfig;
    }

    @VisibleForTesting
    public TrialSpawnerConfig getNormalConfig() {
        return this.normalConfig;
    }

    @VisibleForTesting
    public TrialSpawnerConfig getOminousConfig() {
        return this.ominousConfig;
    }

    private TrialSpawnerConfig getOminousConfigForSerialization() {
        return !this.ominousConfig.equals(this.normalConfig) ? this.ominousConfig : TrialSpawnerConfig.DEFAULT;
    }

    public void applyOminous(WorldServer var0, BlockPosition var1) {
        var0.setBlock(var1, (IBlockData)var0.getBlockState(var1).setValue(TrialSpawnerBlock.OMINOUS, true), 3);
        var0.levelEvent(3020, var1, 1);
        this.isOminous = true;
        this.data.resetAfterBecomingOminous(this, var0);
    }

    public void removeOminous(WorldServer var0, BlockPosition var1) {
        var0.setBlock(var1, (IBlockData)var0.getBlockState(var1).setValue(TrialSpawnerBlock.OMINOUS, false), 3);
        this.isOminous = false;
    }

    public boolean isOminous() {
        return this.isOminous;
    }

    public TrialSpawnerData getData() {
        return this.data;
    }

    public int getTargetCooldownLength() {
        return this.targetCooldownLength;
    }

    public int getRequiredPlayerRange() {
        return this.requiredPlayerRange;
    }

    public TrialSpawnerState getState() {
        return this.stateAccessor.getState();
    }

    public void setState(World var0, TrialSpawnerState var1) {
        this.stateAccessor.setState(var0, var1);
    }

    public void markUpdated() {
        this.stateAccessor.markUpdated();
    }

    public PlayerDetector getPlayerDetector() {
        return this.playerDetector;
    }

    public PlayerDetector.a getEntitySelector() {
        return this.entitySelector;
    }

    public boolean canSpawnInLevel(World var0) {
        if (this.overridePeacefulAndMobSpawnRule) {
            return true;
        }
        if (var0.getDifficulty() == EnumDifficulty.PEACEFUL) {
            return false;
        }
        return var0.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING);
    }

    public Optional<UUID> spawnMob(WorldServer var0, BlockPosition var1) {
        Object var17;
        Object var16;
        double var12;
        RandomSource var2 = var0.getRandom();
        MobSpawnerData var3 = this.data.getOrCreateNextSpawnData(this, var0.getRandom());
        NBTTagCompound var4 = var3.entityToSpawn();
        NBTTagList var5 = var4.getList("Pos", 6);
        Optional<EntityTypes<?>> var6 = EntityTypes.by(var4);
        if (var6.isEmpty()) {
            return Optional.empty();
        }
        int var72 = var5.size();
        double var8 = var72 >= 1 ? var5.getDouble(0) : (double)var1.getX() + (var2.nextDouble() - var2.nextDouble()) * (double)this.getConfig().spawnRange() + 0.5;
        double var10 = var72 >= 2 ? var5.getDouble(1) : (double)(var1.getY() + var2.nextInt(3) - 1);
        double d2 = var12 = var72 >= 3 ? var5.getDouble(2) : (double)var1.getZ() + (var2.nextDouble() - var2.nextDouble()) * (double)this.getConfig().spawnRange() + 0.5;
        if (!var0.noCollision(var6.get().getSpawnAABB(var8, var10, var12))) {
            return Optional.empty();
        }
        Vec3D var14 = new Vec3D(var8, var10, var12);
        if (!TrialSpawner.inLineOfSight(var0, var1.getCenter(), var14)) {
            return Optional.empty();
        }
        BlockPosition var15 = BlockPosition.containing(var14);
        if (!EntityPositionTypes.checkSpawnRules(var6.get(), var0, EnumMobSpawn.TRIAL_SPAWNER, var15, var0.getRandom())) {
            return Optional.empty();
        }
        if (var3.getCustomSpawnRules().isPresent() && !((MobSpawnerData.a)(var16 = var3.getCustomSpawnRules().get())).isValidPosition(var15, var0)) {
            return Optional.empty();
        }
        var16 = EntityTypes.loadEntityRecursive(var4, var0, var7 -> {
            var7.moveTo(var8, var10, var12, var2.nextFloat() * 360.0f, 0.0f);
            return var7;
        });
        if (var16 == null) {
            return Optional.empty();
        }
        if (var16 instanceof EntityInsentient) {
            boolean var18;
            var17 = (EntityInsentient)var16;
            if (!((EntityInsentient)var17).checkSpawnObstruction(var0)) {
                return Optional.empty();
            }
            boolean bl = var18 = var3.getEntityToSpawn().size() == 1 && var3.getEntityToSpawn().contains("id", 8);
            if (var18) {
                ((EntityInsentient)var17).finalizeSpawn(var0, var0.getCurrentDifficultyAt(((Entity)var17).blockPosition()), EnumMobSpawn.TRIAL_SPAWNER, null);
            }
            ((EntityInsentient)var17).setPersistenceRequired();
            var3.getEquipment().ifPresent(((EntityInsentient)var17)::equip);
        }
        if (!var0.tryAddFreshEntityWithPassengers((Entity)var16)) {
            return Optional.empty();
        }
        var17 = this.isOminous ? a.OMINOUS : a.NORMAL;
        var0.levelEvent(3011, var1, ((a)((Object)var17)).encode());
        var0.levelEvent(3012, var15, ((a)((Object)var17)).encode());
        var0.gameEvent((Entity)var16, GameEvent.ENTITY_PLACE, var15);
        return Optional.of(((Entity)var16).getUUID());
    }

    public void ejectReward(WorldServer var0, BlockPosition var1, ResourceKey<LootTable> var2) {
        LootParams var4;
        LootTable var3 = var0.getServer().reloadableRegistries().getLootTable(var2);
        ObjectArrayList<ItemStack> var5 = var3.getRandomItems(var4 = new LootParams.a(var0).create(LootContextParameterSets.EMPTY));
        if (!var5.isEmpty()) {
            for (ItemStack var7 : var5) {
                DispenseBehaviorItem.spawnItem(var0, var7, 2, EnumDirection.UP, Vec3D.atBottomCenterOf(var1).relative(EnumDirection.UP, 1.2));
            }
            var0.levelEvent(3014, var1, 0);
        }
    }

    public void tickClient(World var0, BlockPosition var1, boolean var2) {
        RandomSource var4;
        TrialSpawnerState var3 = this.getState();
        var3.emitParticles(var0, var1, var2);
        if (var3.hasSpinningMob()) {
            double var42 = Math.max(0L, this.data.nextMobSpawnsAt - var0.getGameTime());
            this.data.oSpin = this.data.spin;
            this.data.spin = (this.data.spin + var3.spinningMobSpeed() / (var42 + 200.0)) % 360.0;
        }
        if (var3.isCapableOfSpawning() && (var4 = var0.getRandom()).nextFloat() <= 0.02f) {
            SoundEffect var5 = var2 ? SoundEffects.TRIAL_SPAWNER_AMBIENT_OMINOUS : SoundEffects.TRIAL_SPAWNER_AMBIENT;
            var0.playLocalSound(var1, var5, SoundCategory.BLOCKS, var4.nextFloat() * 0.25f + 0.75f, var4.nextFloat() + 0.5f, false);
        }
    }

    public void tickServer(WorldServer var0, BlockPosition var1, boolean var22) {
        TrialSpawnerState var4;
        this.isOminous = var22;
        TrialSpawnerState var3 = this.getState();
        if (this.data.currentMobs.removeIf(var2 -> TrialSpawner.shouldMobBeUntracked(var0, var1, var2))) {
            this.data.nextMobSpawnsAt = var0.getGameTime() + (long)this.getConfig().ticksBetweenSpawn();
        }
        if ((var4 = var3.tickAndGetNext(var1, this, var0)) != var3) {
            this.setState(var0, var4);
        }
    }

    private static boolean shouldMobBeUntracked(WorldServer var0, BlockPosition var1, UUID var2) {
        Entity var3 = var0.getEntity(var2);
        return var3 == null || !var3.isAlive() || !var3.level().dimension().equals(var0.dimension()) || var3.blockPosition().distSqr(var1) > (double)MAX_MOB_TRACKING_DISTANCE_SQR;
    }

    private static boolean inLineOfSight(World var0, Vec3D var1, Vec3D var2) {
        MovingObjectPositionBlock var3 = var0.clip(new RayTrace(var2, var1, RayTrace.BlockCollisionOption.VISUAL, RayTrace.FluidCollisionOption.NONE, VoxelShapeCollision.empty()));
        return var3.getBlockPos().equals(BlockPosition.containing(var1)) || var3.getType() == MovingObjectPosition.EnumMovingObjectType.MISS;
    }

    public static void addSpawnParticles(World var0, BlockPosition var1, RandomSource var2, ParticleType var3) {
        for (int var4 = 0; var4 < 20; ++var4) {
            double var5 = (double)var1.getX() + 0.5 + (var2.nextDouble() - 0.5) * 2.0;
            double var7 = (double)var1.getY() + 0.5 + (var2.nextDouble() - 0.5) * 2.0;
            double var9 = (double)var1.getZ() + 0.5 + (var2.nextDouble() - 0.5) * 2.0;
            var0.addParticle(Particles.SMOKE, var5, var7, var9, 0.0, 0.0, 0.0);
            var0.addParticle(var3, var5, var7, var9, 0.0, 0.0, 0.0);
        }
    }

    public static void addBecomeOminousParticles(World var0, BlockPosition var1, RandomSource var2) {
        for (int var3 = 0; var3 < 20; ++var3) {
            double var4 = (double)var1.getX() + 0.5 + (var2.nextDouble() - 0.5) * 2.0;
            double var6 = (double)var1.getY() + 0.5 + (var2.nextDouble() - 0.5) * 2.0;
            double var8 = (double)var1.getZ() + 0.5 + (var2.nextDouble() - 0.5) * 2.0;
            double var10 = var2.nextGaussian() * 0.02;
            double var12 = var2.nextGaussian() * 0.02;
            double var14 = var2.nextGaussian() * 0.02;
            var0.addParticle(Particles.TRIAL_OMEN, var4, var6, var8, var10, var12, var14);
            var0.addParticle(Particles.SOUL_FIRE_FLAME, var4, var6, var8, var10, var12, var14);
        }
    }

    public static void addDetectPlayerParticles(World var0, BlockPosition var1, RandomSource var2, int var3, ParticleParam var4) {
        for (int var5 = 0; var5 < 30 + Math.min(var3, 10) * 5; ++var5) {
            double var6 = (double)(2.0f * var2.nextFloat() - 1.0f) * 0.65;
            double var8 = (double)(2.0f * var2.nextFloat() - 1.0f) * 0.65;
            double var10 = (double)var1.getX() + 0.5 + var6;
            double var12 = (double)var1.getY() + 0.1 + (double)var2.nextFloat() * 0.8;
            double var14 = (double)var1.getZ() + 0.5 + var8;
            var0.addParticle(var4, var10, var12, var14, 0.0, 0.0, 0.0);
        }
    }

    public static void addEjectItemParticles(World var0, BlockPosition var1, RandomSource var2) {
        for (int var3 = 0; var3 < 20; ++var3) {
            double var4 = (double)var1.getX() + 0.4 + var2.nextDouble() * 0.2;
            double var6 = (double)var1.getY() + 0.4 + var2.nextDouble() * 0.2;
            double var8 = (double)var1.getZ() + 0.4 + var2.nextDouble() * 0.2;
            double var10 = var2.nextGaussian() * 0.02;
            double var12 = var2.nextGaussian() * 0.02;
            double var14 = var2.nextGaussian() * 0.02;
            var0.addParticle(Particles.SMALL_FLAME, var4, var6, var8, var10, var12, var14 * 0.25);
            var0.addParticle(Particles.SMOKE, var4, var6, var8, var10, var12, var14);
        }
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void setPlayerDetector(PlayerDetector var0) {
        this.playerDetector = var0;
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void overridePeacefulAndMobSpawnRule() {
        this.overridePeacefulAndMobSpawnRule = true;
    }

    public static interface b {
        public void setState(World var1, TrialSpawnerState var2);

        public TrialSpawnerState getState();

        public void markUpdated();
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a NORMAL = new a(Particles.FLAME);
        public static final /* enum */ a OMINOUS = new a(Particles.SOUL_FIRE_FLAME);
        public final ParticleType particleType;
        private static final /* synthetic */ a[] d;

        public static a[] values() {
            return (a[])d.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(ParticleType var2) {
            this.particleType = var2;
        }

        public static a decode(int var0) {
            a[] var1 = a.values();
            if (var0 > var1.length || var0 < 0) {
                return NORMAL;
            }
            return var1[var0];
        }

        public int encode() {
            return this.ordinal();
        }

        private static /* synthetic */ a[] b() {
            return new a[]{NORMAL, OMINOUS};
        }

        static {
            d = a.b();
        }
    }
}

