/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.ChestLock;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;

public abstract class TileEntityContainer
extends TileEntity
implements IInventory,
ITileInventory,
INamableTileEntity {
    public ChestLock lockKey = ChestLock.NO_LOCK;
    @Nullable
    public IChatBaseComponent name;

    protected TileEntityContainer(TileEntityTypes<?> var0, BlockPosition var1, IBlockData var2) {
        super(var0, var1, var2);
    }

    @Override
    protected void loadAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        super.loadAdditional(var0, var1);
        this.lockKey = ChestLock.fromTag(var0);
        if (var0.contains("CustomName", 8)) {
            this.name = TileEntityContainer.parseCustomNameSafe(var0.getString("CustomName"), var1);
        }
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        super.saveAdditional(var0, var1);
        this.lockKey.addToTag(var0);
        if (this.name != null) {
            var0.putString("CustomName", IChatBaseComponent.ChatSerializer.toJson(this.name, var1));
        }
    }

    @Override
    public IChatBaseComponent getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.getDefaultName();
    }

    @Override
    public IChatBaseComponent getDisplayName() {
        return this.getName();
    }

    @Override
    @Nullable
    public IChatBaseComponent getCustomName() {
        return this.name;
    }

    protected abstract IChatBaseComponent getDefaultName();

    public boolean canOpen(EntityHuman var0) {
        return TileEntityContainer.canUnlock(var0, this.lockKey, this.getDisplayName());
    }

    public static boolean canUnlock(EntityHuman var0, ChestLock var1, IChatBaseComponent var2) {
        if (var0.isSpectator() || var1.unlocksWith(var0.getMainHandItem())) {
            return true;
        }
        var0.displayClientMessage(IChatBaseComponent.translatable("container.isLocked", var2), true);
        var0.playNotifySound(SoundEffects.CHEST_LOCKED, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return false;
    }

    protected abstract NonNullList<ItemStack> getItems();

    protected abstract void setItems(NonNullList<ItemStack> var1);

    @Override
    public boolean isEmpty() {
        for (ItemStack var1 : this.getItems()) {
            if (var1.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getItem(int var0) {
        return this.getItems().get(var0);
    }

    @Override
    public ItemStack removeItem(int var0, int var1) {
        ItemStack var2 = ContainerUtil.removeItem(this.getItems(), var0, var1);
        if (!var2.isEmpty()) {
            this.setChanged();
        }
        return var2;
    }

    @Override
    public ItemStack removeItemNoUpdate(int var0) {
        return ContainerUtil.takeItem(this.getItems(), var0);
    }

    @Override
    public void setItem(int var0, ItemStack var1) {
        this.getItems().set(var0, var1);
        var1.limitSize(this.getMaxStackSize(var1));
        this.setChanged();
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return IInventory.stillValidBlockEntity(this, var0);
    }

    @Override
    public void clearContent() {
        this.getItems().clear();
    }

    @Override
    @Nullable
    public Container createMenu(int var0, PlayerInventory var1, EntityHuman var2) {
        if (this.canOpen(var2)) {
            return this.createMenu(var0, var1);
        }
        return null;
    }

    protected abstract Container createMenu(int var1, PlayerInventory var2);

    @Override
    protected void applyImplicitComponents(TileEntity.b var0) {
        super.applyImplicitComponents(var0);
        this.name = var0.get(DataComponents.CUSTOM_NAME);
        this.lockKey = var0.getOrDefault(DataComponents.LOCK, ChestLock.NO_LOCK);
        var0.getOrDefault(DataComponents.CONTAINER, ItemContainerContents.EMPTY).copyInto(this.getItems());
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.a var0) {
        super.collectImplicitComponents(var0);
        var0.set(DataComponents.CUSTOM_NAME, this.name);
        if (!this.lockKey.equals(ChestLock.NO_LOCK)) {
            var0.set(DataComponents.LOCK, this.lockKey);
        }
        var0.set(DataComponents.CONTAINER, ItemContainerContents.fromItems(this.getItems()));
    }

    @Override
    public void removeComponentsFromTag(NBTTagCompound var0) {
        var0.remove("CustomName");
        var0.remove("Lock");
        var0.remove("Items");
    }
}

