/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class SculkShriekerBlockEntity
extends TileEntity
implements GameEventListener.b<VibrationSystem.b>,
VibrationSystem {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int WARNING_SOUND_RADIUS = 10;
    private static final int WARDEN_SPAWN_ATTEMPTS = 20;
    private static final int WARDEN_SPAWN_RANGE_XZ = 5;
    private static final int WARDEN_SPAWN_RANGE_Y = 6;
    private static final int DARKNESS_RADIUS = 40;
    private static final int SHRIEKING_TICKS = 90;
    private static final Int2ObjectMap<SoundEffect> SOUND_BY_LEVEL = (Int2ObjectMap)SystemUtils.make(new Int2ObjectOpenHashMap(), var0 -> {
        var0.put(1, (Object)SoundEffects.WARDEN_NEARBY_CLOSE);
        var0.put(2, (Object)SoundEffects.WARDEN_NEARBY_CLOSER);
        var0.put(3, (Object)SoundEffects.WARDEN_NEARBY_CLOSEST);
        var0.put(4, (Object)SoundEffects.WARDEN_LISTENING_ANGRY);
    });
    public int warningLevel;
    private final VibrationSystem.d vibrationUser = new a();
    private VibrationSystem.a vibrationData = new VibrationSystem.a();
    private final VibrationSystem.b vibrationListener = new VibrationSystem.b(this);

    public SculkShriekerBlockEntity(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.SCULK_SHRIEKER, var0, var1);
    }

    @Override
    public VibrationSystem.a getVibrationData() {
        return this.vibrationData;
    }

    @Override
    public VibrationSystem.d getVibrationUser() {
        return this.vibrationUser;
    }

    @Override
    protected void loadAdditional(NBTTagCompound var02, HolderLookup.a var1) {
        super.loadAdditional(var02, var1);
        if (var02.contains("warning_level", 99)) {
            this.warningLevel = var02.getInt("warning_level");
        }
        RegistryOps<NBTBase> var2 = var1.createSerializationContext(DynamicOpsNBT.INSTANCE);
        if (var02.contains("listener", 10)) {
            VibrationSystem.a.CODEC.parse(var2, (Object)var02.getCompound("listener")).resultOrPartial(var0 -> LOGGER.error("Failed to parse vibration listener for Sculk Shrieker: '{}'", var0)).ifPresent(var0 -> {
                this.vibrationData = var0;
            });
        }
    }

    @Override
    protected void saveAdditional(NBTTagCompound var02, HolderLookup.a var12) {
        super.saveAdditional(var02, var12);
        var02.putInt("warning_level", this.warningLevel);
        RegistryOps<NBTBase> var2 = var12.createSerializationContext(DynamicOpsNBT.INSTANCE);
        VibrationSystem.a.CODEC.encodeStart(var2, (Object)this.vibrationData).resultOrPartial(var0 -> LOGGER.error("Failed to encode vibration listener for Sculk Shrieker: '{}'", var0)).ifPresent(var1 -> var02.put("listener", (NBTBase)var1));
    }

    @Nullable
    public static EntityPlayer tryGetPlayer(@Nullable Entity var0) {
        EntityPlayer var2;
        Entity var1;
        Entity entity;
        EntityLiving entityLiving;
        if (var0 instanceof EntityPlayer) {
            EntityPlayer var12 = (EntityPlayer)var0;
            return var12;
        }
        if (var0 != null && (entityLiving = var0.getControllingPassenger()) instanceof EntityPlayer) {
            EntityPlayer var13 = (EntityPlayer)entityLiving;
            return var13;
        }
        if (var0 instanceof IProjectile && (entity = ((IProjectile)(var1 = (IProjectile)var0)).getOwner()) instanceof EntityPlayer) {
            var2 = (EntityPlayer)entity;
            return var2;
        }
        if (var0 instanceof EntityItem && (entity = ((EntityItem)(var1 = (EntityItem)var0)).getOwner()) instanceof EntityPlayer) {
            var2 = (EntityPlayer)entity;
            return var2;
        }
        return null;
    }

    public void tryShriek(WorldServer var0, @Nullable EntityPlayer var1) {
        if (var1 == null) {
            return;
        }
        IBlockData var2 = this.getBlockState();
        if (var2.getValue(SculkShriekerBlock.SHRIEKING).booleanValue()) {
            return;
        }
        this.warningLevel = 0;
        if (this.canRespond(var0) && !this.tryToWarn(var0, var1)) {
            return;
        }
        this.shriek(var0, var1);
    }

    private boolean tryToWarn(WorldServer var02, EntityPlayer var1) {
        OptionalInt var2 = WardenSpawnTracker.tryWarn(var02, this.getBlockPos(), var1);
        var2.ifPresent(var0 -> {
            this.warningLevel = var0;
        });
        return var2.isPresent();
    }

    private void shriek(WorldServer var0, @Nullable Entity var1) {
        BlockPosition var2 = this.getBlockPos();
        IBlockData var3 = this.getBlockState();
        var0.setBlock(var2, (IBlockData)var3.setValue(SculkShriekerBlock.SHRIEKING, true), 2);
        var0.scheduleTick(var2, var3.getBlock(), 90);
        var0.levelEvent(3007, var2, 0);
        var0.gameEvent(GameEvent.SHRIEK, var2, GameEvent.a.of(var1));
    }

    private boolean canRespond(WorldServer var0) {
        return this.getBlockState().getValue(SculkShriekerBlock.CAN_SUMMON) != false && var0.getDifficulty() != EnumDifficulty.PEACEFUL && var0.getGameRules().getBoolean(GameRules.RULE_DO_WARDEN_SPAWNING);
    }

    public void tryRespond(WorldServer var0) {
        if (this.canRespond(var0) && this.warningLevel > 0) {
            if (!this.trySummonWarden(var0)) {
                this.playWardenReplySound(var0);
            }
            Warden.applyDarknessAround(var0, Vec3D.atCenterOf(this.getBlockPos()), null, 40);
        }
    }

    private void playWardenReplySound(World var0) {
        SoundEffect var1 = (SoundEffect)SOUND_BY_LEVEL.get(this.warningLevel);
        if (var1 != null) {
            BlockPosition var2 = this.getBlockPos();
            int var3 = var2.getX() + MathHelper.randomBetweenInclusive(var0.random, -10, 10);
            int var4 = var2.getY() + MathHelper.randomBetweenInclusive(var0.random, -10, 10);
            int var5 = var2.getZ() + MathHelper.randomBetweenInclusive(var0.random, -10, 10);
            var0.playSound(null, (double)var3, (double)var4, (double)var5, var1, SoundCategory.HOSTILE, 5.0f, 1.0f);
        }
    }

    private boolean trySummonWarden(WorldServer var0) {
        if (this.warningLevel < 4) {
            return false;
        }
        return SpawnUtil.trySpawnMob(EntityTypes.WARDEN, EnumMobSpawn.TRIGGERED, var0, this.getBlockPos(), 20, 5, 6, SpawnUtil.a.ON_TOP_OF_COLLIDER).isPresent();
    }

    @Override
    public VibrationSystem.b getListener() {
        return this.vibrationListener;
    }

    @Override
    public /* synthetic */ GameEventListener getListener() {
        return this.getListener();
    }

    class a
    implements VibrationSystem.d {
        private static final int LISTENER_RADIUS = 8;
        private final PositionSource positionSource;

        public a() {
            this.positionSource = new BlockPositionSource(SculkShriekerBlockEntity.this.worldPosition);
        }

        @Override
        public int getListenerRadius() {
            return 8;
        }

        @Override
        public PositionSource getPositionSource() {
            return this.positionSource;
        }

        @Override
        public TagKey<GameEvent> getListenableEvents() {
            return GameEventTags.SHRIEKER_CAN_LISTEN;
        }

        @Override
        public boolean canReceiveVibration(WorldServer var0, BlockPosition var1, Holder<GameEvent> var2, GameEvent.a var3) {
            return SculkShriekerBlockEntity.this.getBlockState().getValue(SculkShriekerBlock.SHRIEKING) == false && SculkShriekerBlockEntity.tryGetPlayer(var3.sourceEntity()) != null;
        }

        @Override
        public void onReceiveVibration(WorldServer var0, BlockPosition var1, Holder<GameEvent> var2, @Nullable Entity var3, @Nullable Entity var4, float var5) {
            SculkShriekerBlockEntity.this.tryShriek(var0, SculkShriekerBlockEntity.tryGetPlayer(var4 != null ? var4 : var3));
        }

        @Override
        public void onDataChanged() {
            SculkShriekerBlockEntity.this.setChanged();
        }

        @Override
        public boolean requiresAdjacentChunksToBeTicking() {
            return true;
        }
    }
}

