/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.MinecartTrackLogic;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public abstract class BlockMinecartTrackAbstract
extends Block
implements IBlockWaterlogged {
    protected static final VoxelShape FLAT_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 2.0, 16.0);
    protected static final VoxelShape HALF_BLOCK_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    private final boolean isStraight;

    public static boolean isRail(World var0, BlockPosition var1) {
        return BlockMinecartTrackAbstract.isRail(var0.getBlockState(var1));
    }

    public static boolean isRail(IBlockData var0) {
        return var0.is(TagsBlock.RAILS) && var0.getBlock() instanceof BlockMinecartTrackAbstract;
    }

    protected BlockMinecartTrackAbstract(boolean var0, BlockBase.Info var1) {
        super(var1);
        this.isStraight = var0;
    }

    protected abstract MapCodec<? extends BlockMinecartTrackAbstract> codec();

    public boolean isStraight() {
        return this.isStraight;
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        BlockPropertyTrackPosition var4;
        BlockPropertyTrackPosition blockPropertyTrackPosition = var4 = var0.is(this) ? var0.getValue(this.getShapeProperty()) : null;
        if (var4 != null && var4.isAscending()) {
            return HALF_BLOCK_AABB;
        }
        return FLAT_AABB;
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return BlockMinecartTrackAbstract.canSupportRigidBlock(var1, var2.below());
    }

    @Override
    protected void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var3.is(var0.getBlock())) {
            return;
        }
        this.updateState(var0, var1, var2, var4);
    }

    protected IBlockData updateState(IBlockData var0, World var1, BlockPosition var2, boolean var3) {
        var0 = this.updateDir(var1, var2, var0, true);
        if (this.isStraight) {
            var1.neighborChanged(var0, var2, this, var2, var3);
        }
        return var0;
    }

    @Override
    protected void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, BlockPosition var4, boolean var5) {
        if (var1.isClientSide || !var1.getBlockState(var2).is(this)) {
            return;
        }
        BlockPropertyTrackPosition var6 = var0.getValue(this.getShapeProperty());
        if (BlockMinecartTrackAbstract.shouldBeRemoved(var2, var1, var6)) {
            BlockMinecartTrackAbstract.dropResources(var0, var1, var2);
            var1.removeBlock(var2, var5);
        } else {
            this.updateState(var0, var1, var2, var3);
        }
    }

    private static boolean shouldBeRemoved(BlockPosition var0, World var1, BlockPropertyTrackPosition var2) {
        if (!BlockMinecartTrackAbstract.canSupportRigidBlock(var1, var0.below())) {
            return true;
        }
        switch (var2) {
            case ASCENDING_EAST: {
                return !BlockMinecartTrackAbstract.canSupportRigidBlock(var1, var0.east());
            }
            case ASCENDING_WEST: {
                return !BlockMinecartTrackAbstract.canSupportRigidBlock(var1, var0.west());
            }
            case ASCENDING_NORTH: {
                return !BlockMinecartTrackAbstract.canSupportRigidBlock(var1, var0.north());
            }
            case ASCENDING_SOUTH: {
                return !BlockMinecartTrackAbstract.canSupportRigidBlock(var1, var0.south());
            }
        }
        return false;
    }

    protected void updateState(IBlockData var0, World var1, BlockPosition var2, Block var3) {
    }

    protected IBlockData updateDir(World var0, BlockPosition var1, IBlockData var2, boolean var3) {
        if (var0.isClientSide) {
            return var2;
        }
        BlockPropertyTrackPosition var4 = var2.getValue(this.getShapeProperty());
        return new MinecartTrackLogic(var0, var1, var2).place(var0.hasNeighborSignal(var1), var3, var4).getState();
    }

    @Override
    protected void onRemove(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var4) {
            return;
        }
        super.onRemove(var0, var1, var2, var3, var4);
        if (var0.getValue(this.getShapeProperty()).isAscending()) {
            var1.updateNeighborsAt(var2.above(), this);
        }
        if (this.isStraight) {
            var1.updateNeighborsAt(var2, this);
            var1.updateNeighborsAt(var2.below(), this);
        }
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        Fluid var1 = var0.getLevel().getFluidState(var0.getClickedPos());
        boolean var2 = var1.getType() == FluidTypes.WATER;
        IBlockData var3 = super.defaultBlockState();
        EnumDirection var4 = var0.getHorizontalDirection();
        boolean var5 = var4 == EnumDirection.EAST || var4 == EnumDirection.WEST;
        return (IBlockData)((IBlockData)var3.setValue(this.getShapeProperty(), var5 ? BlockPropertyTrackPosition.EAST_WEST : BlockPropertyTrackPosition.NORTH_SOUTH)).setValue(WATERLOGGED, var2);
    }

    public abstract IBlockState<BlockPropertyTrackPosition> getShapeProperty();

    @Override
    protected IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var3.scheduleTick(var4, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var3));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }
}

