/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyWood;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;

public class BlockFloorSign
extends BlockSign {
    public static final MapCodec<BlockFloorSign> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)BlockPropertyWood.CODEC.fieldOf("wood_type").forGetter(BlockSign::type), BlockFloorSign.propertiesCodec()).apply((Applicative)var0, BlockFloorSign::new));
    public static final BlockStateInteger ROTATION = BlockProperties.ROTATION_16;

    public MapCodec<BlockFloorSign> codec() {
        return CODEC;
    }

    public BlockFloorSign(BlockPropertyWood var0, BlockBase.Info var1) {
        super(var0, var1.sound(var0.soundType()));
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(ROTATION, 0)).setValue(WATERLOGGED, false));
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return var1.getBlockState(var2.below()).isSolid();
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        Fluid var1 = var0.getLevel().getFluidState(var0.getClickedPos());
        return (IBlockData)((IBlockData)this.defaultBlockState().setValue(ROTATION, RotationSegment.convertToSegment(var0.getRotation() + 180.0f))).setValue(WATERLOGGED, var1.getType() == FluidTypes.WATER);
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var1 == EnumDirection.DOWN && !this.canSurvive(var0, var3, var4)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public float getYRotationDegrees(IBlockData var0) {
        return RotationSegment.convertToDegrees(var0.getValue(ROTATION));
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(ROTATION, var1.rotate(var0.getValue(ROTATION), 16));
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return (IBlockData)var0.setValue(ROTATION, var1.mirror(var0.getValue(ROTATION), 16));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(ROTATION, WATERLOGGED);
    }
}

