/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.EndPlatformFeature;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockEnderPortal
extends BlockTileEntity
implements Portal {
    public static final MapCodec<BlockEnderPortal> CODEC = BlockEnderPortal.simpleCodec(BlockEnderPortal::new);
    protected static final VoxelShape SHAPE = Block.box(0.0, 6.0, 0.0, 16.0, 12.0, 16.0);

    public MapCodec<BlockEnderPortal> codec() {
        return CODEC;
    }

    protected BlockEnderPortal(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityEnderPortal(var0, var1);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3) {
        if (!var3.canUsePortal(false)) return;
        if (!VoxelShapes.joinIsNotEmpty(VoxelShapes.create(var3.getBoundingBox().move(-var2.getX(), -var2.getY(), -var2.getZ())), var0.getShape(var1, var2), OperatorBoolean.AND)) return;
        if (!var1.isClientSide && var1.dimension() == World.END && var3 instanceof EntityPlayer) {
            EntityPlayer var4 = (EntityPlayer)var3;
            if (!var4.seenCredits) {
                var4.showEndCredits();
                return;
            }
        }
        var3.setAsInsidePortal(this, var2);
    }

    @Override
    public DimensionTransition getPortalDestination(WorldServer var0, Entity var1, BlockPosition var2) {
        ResourceKey<World> var3 = var0.dimension() == World.END ? World.OVERWORLD : World.END;
        WorldServer var4 = var0.getServer().getLevel(var3);
        if (var4 == null) {
            return null;
        }
        boolean var5 = var3 == World.END;
        BlockPosition var6 = var5 ? WorldServer.END_SPAWN_POINT : var4.getSharedSpawnPos();
        Vec3D var7 = var6.getBottomCenter();
        float var8 = var1.getYRot();
        if (var5) {
            EndPlatformFeature.createEndPlatform(var4, BlockPosition.containing(var7).below(), true);
            var8 = EnumDirection.WEST.toYRot();
            if (var1 instanceof EntityPlayer) {
                var7 = var7.subtract(0.0, 1.0, 0.0);
            }
        } else {
            if (var1 instanceof EntityPlayer) {
                EntityPlayer var9 = (EntityPlayer)var1;
                return var9.findRespawnPositionAndUseSpawnBlock(false, DimensionTransition.DO_NOTHING);
            }
            var7 = var1.adjustSpawnLocation(var4, var6).getBottomCenter();
        }
        return new DimensionTransition(var4, var7, var1.getDeltaMovement(), var8, var1.getXRot(), DimensionTransition.PLAY_PORTAL_SOUND.then(DimensionTransition.PLACE_PORTAL_TICKET));
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        double var4 = (double)var2.getX() + var3.nextDouble();
        double var6 = (double)var2.getY() + 0.8;
        double var8 = (double)var2.getZ() + var3.nextDouble();
        var1.addParticle(Particles.SMOKE, var4, var6, var8, 0.0, 0.0, 0.0);
    }

    @Override
    public ItemStack getCloneItemStack(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return ItemStack.EMPTY;
    }

    @Override
    protected boolean canBeReplaced(IBlockData var0, FluidType var1) {
        return false;
    }
}

