/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.entity.vehicle.EntityMinecartTNT;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockFire;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockBeehive
extends BlockTileEntity {
    public static final MapCodec<BlockBeehive> CODEC = BlockBeehive.simpleCodec(BlockBeehive::new);
    public static final BlockStateDirection FACING = BlockFacingHorizontal.FACING;
    public static final BlockStateInteger HONEY_LEVEL = BlockProperties.LEVEL_HONEY;
    public static final int MAX_HONEY_LEVELS = 5;
    private static final int SHEARED_HONEYCOMB_COUNT = 3;

    public MapCodec<BlockBeehive> codec() {
        return CODEC;
    }

    public BlockBeehive(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(HONEY_LEVEL, 0)).setValue(FACING, EnumDirection.NORTH));
    }

    @Override
    protected boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2) {
        return var0.getValue(HONEY_LEVEL);
    }

    @Override
    public void playerDestroy(World var0, EntityHuman var1, BlockPosition var2, IBlockData var3, @Nullable TileEntity var4, ItemStack var5) {
        super.playerDestroy(var0, var1, var2, var3, var4, var5);
        if (!var0.isClientSide && var4 instanceof TileEntityBeehive) {
            TileEntityBeehive var6 = (TileEntityBeehive)var4;
            if (!EnchantmentManager.hasTag(var5, EnchantmentTags.PREVENTS_BEE_SPAWNS_WHEN_MINING)) {
                var6.emptyAllLivingFromHive(var1, var3, TileEntityBeehive.ReleaseStatus.EMERGENCY);
                var0.updateNeighbourForOutputSignal(var2, this);
                this.angerNearbyBees(var0, var2);
            }
            CriterionTriggers.BEE_NEST_DESTROYED.trigger((EntityPlayer)var1, var3, var5, var6.getOccupantCount());
        }
    }

    private void angerNearbyBees(World var0, BlockPosition var1) {
        AxisAlignedBB var2 = new AxisAlignedBB(var1).inflate(8.0, 6.0, 8.0);
        List<EntityBee> var3 = var0.getEntitiesOfClass(EntityBee.class, var2);
        if (!var3.isEmpty()) {
            List<EntityHuman> var4 = var0.getEntitiesOfClass(EntityHuman.class, var2);
            if (var4.isEmpty()) {
                return;
            }
            for (EntityBee var6 : var3) {
                if (var6.getTarget() != null) continue;
                EntityHuman var7 = SystemUtils.getRandom(var4, var0.random);
                var6.setTarget(var7);
            }
        }
    }

    public static void dropHoneycomb(World var0, BlockPosition var1) {
        BlockBeehive.popResource(var0, var1, new ItemStack(Items.HONEYCOMB, 3));
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityHuman var4, EnumHand var5, MovingObjectPositionBlock var6) {
        int var7 = var1.getValue(HONEY_LEVEL);
        boolean var8 = false;
        if (var7 >= 5) {
            Item var9 = var0.getItem();
            if (var0.is(Items.SHEARS)) {
                var2.playSound(var4, var4.getX(), var4.getY(), var4.getZ(), SoundEffects.BEEHIVE_SHEAR, SoundCategory.BLOCKS, 1.0f, 1.0f);
                BlockBeehive.dropHoneycomb(var2, var3);
                var0.hurtAndBreak(1, var4, EntityLiving.getSlotForHand(var5));
                var8 = true;
                var2.gameEvent((Entity)var4, GameEvent.SHEAR, var3);
            } else if (var0.is(Items.GLASS_BOTTLE)) {
                var0.shrink(1);
                var2.playSound(var4, var4.getX(), var4.getY(), var4.getZ(), SoundEffects.BOTTLE_FILL, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (var0.isEmpty()) {
                    var4.setItemInHand(var5, new ItemStack(Items.HONEY_BOTTLE));
                } else if (!var4.getInventory().add(new ItemStack(Items.HONEY_BOTTLE))) {
                    var4.drop(new ItemStack(Items.HONEY_BOTTLE), false);
                }
                var8 = true;
                var2.gameEvent((Entity)var4, GameEvent.FLUID_PICKUP, var3);
            }
            if (!var2.isClientSide() && var8) {
                var4.awardStat(StatisticList.ITEM_USED.get(var9));
            }
        }
        if (var8) {
            if (!BlockCampfire.isSmokeyPos(var2, var3)) {
                if (this.hiveContainsBees(var2, var3)) {
                    this.angerNearbyBees(var2, var3);
                }
                this.releaseBeesAndResetHoneyLevel(var2, var1, var3, var4, TileEntityBeehive.ReleaseStatus.EMERGENCY);
            } else {
                this.resetHoneyLevel(var2, var1, var3);
            }
            return ItemInteractionResult.sidedSuccess(var2.isClientSide);
        }
        return super.useItemOn(var0, var1, var2, var3, var4, var5, var6);
    }

    private boolean hiveContainsBees(World var0, BlockPosition var1) {
        TileEntity var2 = var0.getBlockEntity(var1);
        if (var2 instanceof TileEntityBeehive) {
            TileEntityBeehive var3 = (TileEntityBeehive)var2;
            return !var3.isEmpty();
        }
        return false;
    }

    public void releaseBeesAndResetHoneyLevel(World var0, IBlockData var1, BlockPosition var2, @Nullable EntityHuman var3, TileEntityBeehive.ReleaseStatus var4) {
        this.resetHoneyLevel(var0, var1, var2);
        TileEntity var5 = var0.getBlockEntity(var2);
        if (var5 instanceof TileEntityBeehive) {
            TileEntityBeehive var6 = (TileEntityBeehive)var5;
            var6.emptyAllLivingFromHive(var3, var1, var4);
        }
    }

    public void resetHoneyLevel(World var0, IBlockData var1, BlockPosition var2) {
        var0.setBlock(var2, (IBlockData)var1.setValue(HONEY_LEVEL, 0), 3);
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        if (var0.getValue(HONEY_LEVEL) >= 5) {
            for (int var4 = 0; var4 < var3.nextInt(1) + 1; ++var4) {
                this.trySpawnDripParticles(var1, var2, var0);
            }
        }
    }

    private void trySpawnDripParticles(World var0, BlockPosition var1, IBlockData var2) {
        if (!var2.getFluidState().isEmpty() || var0.random.nextFloat() < 0.3f) {
            return;
        }
        VoxelShape var3 = var2.getCollisionShape(var0, var1);
        double var4 = var3.max(EnumDirection.EnumAxis.Y);
        if (var4 >= 1.0 && !var2.is(TagsBlock.IMPERMEABLE)) {
            double var6 = var3.min(EnumDirection.EnumAxis.Y);
            if (var6 > 0.0) {
                this.spawnParticle(var0, var1, var3, (double)var1.getY() + var6 - 0.05);
            } else {
                BlockPosition var8 = var1.below();
                IBlockData var9 = var0.getBlockState(var8);
                VoxelShape var10 = var9.getCollisionShape(var0, var8);
                double var11 = var10.max(EnumDirection.EnumAxis.Y);
                if ((var11 < 1.0 || !var9.isCollisionShapeFullBlock(var0, var8)) && var9.getFluidState().isEmpty()) {
                    this.spawnParticle(var0, var1, var3, (double)var1.getY() - 0.05);
                }
            }
        }
    }

    private void spawnParticle(World var0, BlockPosition var1, VoxelShape var2, double var3) {
        this.spawnFluidParticle(var0, (double)var1.getX() + var2.min(EnumDirection.EnumAxis.X), (double)var1.getX() + var2.max(EnumDirection.EnumAxis.X), (double)var1.getZ() + var2.min(EnumDirection.EnumAxis.Z), (double)var1.getZ() + var2.max(EnumDirection.EnumAxis.Z), var3);
    }

    private void spawnFluidParticle(World var0, double var1, double var3, double var5, double var7, double var9) {
        var0.addParticle(Particles.DRIPPING_HONEY, MathHelper.lerp(var0.random.nextDouble(), var1, var3), var9, MathHelper.lerp(var0.random.nextDouble(), var5, var7), 0.0, 0.0, 0.0);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return (IBlockData)this.defaultBlockState().setValue(FACING, var0.getHorizontalDirection().getOpposite());
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(HONEY_LEVEL, FACING);
    }

    @Override
    protected EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.MODEL;
    }

    @Override
    @Nullable
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityBeehive(var0, var1);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        return var0.isClientSide ? null : BlockBeehive.createTickerHelper(var2, TileEntityTypes.BEEHIVE, TileEntityBeehive::serverTick);
    }

    @Override
    public IBlockData playerWillDestroy(World var0, BlockPosition var1, IBlockData var2, EntityHuman var3) {
        TileEntity var4;
        if (!var0.isClientSide && var3.isCreative() && var0.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && (var4 = var0.getBlockEntity(var1)) instanceof TileEntityBeehive) {
            boolean var7;
            TileEntityBeehive var5 = (TileEntityBeehive)var4;
            int var6 = var2.getValue(HONEY_LEVEL);
            boolean bl = var7 = !var5.isEmpty();
            if (var7 || var6 > 0) {
                ItemStack var8 = new ItemStack(this);
                var8.applyComponents(var5.collectComponents());
                var8.set(DataComponents.BLOCK_STATE, BlockItemStateProperties.EMPTY.with(HONEY_LEVEL, var6));
                EntityItem var9 = new EntityItem(var0, var1.getX(), var1.getY(), var1.getZ(), var8);
                var9.setDefaultPickUpDelay();
                var0.addFreshEntity(var9);
            }
        }
        return super.playerWillDestroy(var0, var1, var2, var3);
    }

    @Override
    protected List<ItemStack> getDrops(IBlockData var0, LootParams.a var1) {
        TileEntity var3;
        Entity var2 = var1.getOptionalParameter(LootContextParameters.THIS_ENTITY);
        if ((var2 instanceof EntityTNTPrimed || var2 instanceof EntityCreeper || var2 instanceof EntityWitherSkull || var2 instanceof EntityWither || var2 instanceof EntityMinecartTNT) && (var3 = var1.getOptionalParameter(LootContextParameters.BLOCK_ENTITY)) instanceof TileEntityBeehive) {
            TileEntityBeehive var4 = (TileEntityBeehive)var3;
            var4.emptyAllLivingFromHive(null, var0, TileEntityBeehive.ReleaseStatus.EMERGENCY);
        }
        return super.getDrops(var0, var1);
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        TileEntity var6;
        if (var3.getBlockState(var5).getBlock() instanceof BlockFire && (var6 = var3.getBlockEntity(var4)) instanceof TileEntityBeehive) {
            TileEntityBeehive var7 = (TileEntityBeehive)var6;
            var7.emptyAllLivingFromHive(null, var0, TileEntityBeehive.ReleaseStatus.EMERGENCY);
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }
}

