/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;

public record SetBlockProperties(BlockItemStateProperties properties, BaseBlockPosition offset, Optional<Holder<GameEvent>> triggerGameEvent) implements EnchantmentEntityEffect
{
    public static final MapCodec<SetBlockProperties> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)BlockItemStateProperties.CODEC.fieldOf("properties").forGetter(SetBlockProperties::properties), (App)BaseBlockPosition.CODEC.optionalFieldOf("offset", (Object)BaseBlockPosition.ZERO).forGetter(SetBlockProperties::offset), (App)GameEvent.CODEC.optionalFieldOf("trigger_game_event").forGetter(SetBlockProperties::triggerGameEvent)).apply((Applicative)var0, SetBlockProperties::new));

    public SetBlockProperties(BlockItemStateProperties var0) {
        this(var0, BaseBlockPosition.ZERO, Optional.of(GameEvent.BLOCK_CHANGE));
    }

    @Override
    public void apply(WorldServer var0, int var1, EnchantedItemInUse var2, Entity var32, Vec3D var4) {
        IBlockData var7;
        BlockPosition var5 = BlockPosition.containing(var4).offset(this.offset);
        IBlockData var6 = var32.level().getBlockState(var5);
        if (!var6.equals(var7 = this.properties.apply(var6)) && var32.level().setBlock(var5, var7, 3)) {
            this.triggerGameEvent.ifPresent(var3 -> var0.gameEvent(var32, (Holder<GameEvent>)var3, var5));
        }
    }

    public MapCodec<SetBlockProperties> codec() {
        return CODEC;
    }
}

