/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class RecipeSerializerCooking<T extends RecipeCooking>
implements RecipeSerializer<T> {
    private final RecipeCooking.a<T> factory;
    private final MapCodec<T> codec;
    private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec;

    public RecipeSerializerCooking(RecipeCooking.a<T> var0, int var1) {
        this.factory = var0;
        this.codec = RecordCodecBuilder.mapCodec(var2 -> var2.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(var0 -> var0.group), (App)CookingBookCategory.CODEC.fieldOf("category").orElse((Object)CookingBookCategory.MISC).forGetter(var0 -> var0.category), (App)RecipeItemStack.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(var0 -> var0.ingredient), (App)ItemStack.STRICT_SINGLE_ITEM_CODEC.fieldOf("result").forGetter(var0 -> var0.result), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.0f)).forGetter(var0 -> Float.valueOf(var0.experience)), (App)Codec.INT.fieldOf("cookingtime").orElse((Object)var1).forGetter(var0 -> var0.cookingTime)).apply((Applicative)var2, var0::create));
        this.streamCodec = StreamCodec.of(this::toNetwork, this::fromNetwork);
    }

    @Override
    public MapCodec<T> codec() {
        return this.codec;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
        return this.streamCodec;
    }

    private T fromNetwork(RegistryFriendlyByteBuf var0) {
        String var1 = var0.readUtf();
        CookingBookCategory var2 = var0.readEnum(CookingBookCategory.class);
        RecipeItemStack var3 = (RecipeItemStack)RecipeItemStack.CONTENTS_STREAM_CODEC.decode(var0);
        ItemStack var4 = (ItemStack)ItemStack.STREAM_CODEC.decode(var0);
        float var5 = var0.readFloat();
        int var6 = var0.readVarInt();
        return this.factory.create(var1, var2, var3, var4, var5, var6);
    }

    private void toNetwork(RegistryFriendlyByteBuf var0, T var1) {
        var0.writeUtf(((RecipeCooking)var1).group);
        var0.writeEnum(((RecipeCooking)var1).category());
        RecipeItemStack.CONTENTS_STREAM_CODEC.encode(var0, ((RecipeCooking)var1).ingredient);
        ItemStack.STREAM_CODEC.encode(var0, ((RecipeCooking)var1).result);
        var0.writeFloat(((RecipeCooking)var1).experience);
        var0.writeVarInt(((RecipeCooking)var1).cookingTime);
    }

    public RecipeCooking create(String var0, CookingBookCategory var1, RecipeItemStack var2, ItemStack var3, float var4, int var5) {
        return this.factory.create(var0, var1, var2, var3, var4, var5);
    }
}

