/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.World;

public class OminousBottleItem
extends Item {
    private static final int DRINK_DURATION = 32;
    public static final int EFFECT_DURATION = 120000;
    public static final int MIN_AMPLIFIER = 0;
    public static final int MAX_AMPLIFIER = 4;

    public OminousBottleItem(Item.Info var0) {
        super(var0);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack var0, World var1, EntityLiving var2) {
        Object var3;
        if (var2 instanceof EntityPlayer) {
            var3 = (EntityPlayer)var2;
            CriterionTriggers.CONSUME_ITEM.trigger((EntityPlayer)var3, var0);
            ((EntityHuman)var3).awardStat(StatisticList.ITEM_USED.get(this));
        }
        if (!var1.isClientSide) {
            var1.playSound(null, var2.blockPosition(), SoundEffects.OMINOUS_BOTTLE_DISPOSE, var2.getSoundSource(), 1.0f, 1.0f);
            var3 = var0.getOrDefault(DataComponents.OMINOUS_BOTTLE_AMPLIFIER, 0);
            var2.addEffect(new MobEffect(MobEffects.BAD_OMEN, 120000, (Integer)var3, false, false, true));
        }
        var0.consume(1, var2);
        return var0;
    }

    @Override
    public int getUseDuration(ItemStack var0, EntityLiving var1) {
        return 32;
    }

    @Override
    public EnumAnimation getUseAnimation(ItemStack var0) {
        return EnumAnimation.DRINK;
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        return ItemLiquidUtil.startUsingInstantly(var0, var1, var2);
    }

    @Override
    public void appendHoverText(ItemStack var0, Item.b var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        super.appendHoverText(var0, var1, var2, var3);
        Integer var4 = var0.getOrDefault(DataComponents.OMINOUS_BOTTLE_AMPLIFIER, 0);
        List<MobEffect> var5 = List.of(new MobEffect(MobEffects.BAD_OMEN, 120000, var4, false, false, true));
        PotionContents.addPotionTooltip(var5, var2::add, 1.0f, var1.tickRate());
    }
}

