/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;

public class InstrumentItem
extends Item {
    private final TagKey<Instrument> instruments;

    public InstrumentItem(Item.Info var0, TagKey<Instrument> var1) {
        super(var0);
        this.instruments = var1;
    }

    @Override
    public void appendHoverText(ItemStack var0, Item.b var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        super.appendHoverText(var0, var1, var2, var3);
        Optional var4 = this.getInstrument(var0).flatMap(Holder::unwrapKey);
        if (var4.isPresent()) {
            IChatMutableComponent var5 = IChatBaseComponent.translatable(SystemUtils.makeDescriptionId("instrument", ((ResourceKey)var4.get()).location()));
            var2.add(var5.withStyle(EnumChatFormat.GRAY));
        }
    }

    public static ItemStack create(Item var0, Holder<Instrument> var1) {
        ItemStack var2 = new ItemStack(var0);
        var2.set(DataComponents.INSTRUMENT, var1);
        return var2;
    }

    public static void setRandom(ItemStack var0, TagKey<Instrument> var12, RandomSource var2) {
        Optional<Holder<Instrument>> var3 = BuiltInRegistries.INSTRUMENT.getRandomElementOf(var12, var2);
        var3.ifPresent(var1 -> var0.set(DataComponents.INSTRUMENT, var1));
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        Optional<Holder<Instrument>> var4 = this.getInstrument(var3);
        if (var4.isPresent()) {
            Instrument var5 = var4.get().value();
            var1.startUsingItem(var2);
            InstrumentItem.play(var0, var1, var5);
            var1.getCooldowns().addCooldown(this, var5.useDuration());
            var1.awardStat(StatisticList.ITEM_USED.get(this));
            return InteractionResultWrapper.consume(var3);
        }
        return InteractionResultWrapper.fail(var3);
    }

    @Override
    public int getUseDuration(ItemStack var02, EntityLiving var1) {
        Optional<Holder<Instrument>> var2 = this.getInstrument(var02);
        return var2.map(var0 -> ((Instrument)var0.value()).useDuration()).orElse(0);
    }

    private Optional<Holder<Instrument>> getInstrument(ItemStack var0) {
        Holder<Instrument> var1 = var0.get(DataComponents.INSTRUMENT);
        if (var1 != null) {
            return Optional.of(var1);
        }
        Iterator<Holder<Instrument>> var2 = BuiltInRegistries.INSTRUMENT.getTagOrEmpty(this.instruments).iterator();
        if (var2.hasNext()) {
            return Optional.of(var2.next());
        }
        return Optional.empty();
    }

    @Override
    public EnumAnimation getUseAnimation(ItemStack var0) {
        return EnumAnimation.TOOT_HORN;
    }

    private static void play(World var0, EntityHuman var1, Instrument var2) {
        SoundEffect var3 = var2.soundEvent().value();
        float var4 = var2.range() / 16.0f;
        var0.playSound(var1, var1, var3, SoundCategory.RECORDS, var4, 1.0f);
        var0.gameEvent(GameEvent.INSTRUMENT_PLAY, var1.position(), GameEvent.a.of(var1));
    }
}

