/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerPlayer;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.WeightedRandomEnchant;
import net.minecraft.world.level.block.BlockEnchantmentTable;
import net.minecraft.world.level.block.Blocks;

public class ContainerEnchantTable
extends Container {
    static final MinecraftKey EMPTY_SLOT_LAPIS_LAZULI = MinecraftKey.withDefaultNamespace("item/empty_slot_lapis_lazuli");
    private final IInventory enchantSlots = new InventorySubcontainer(2){

        @Override
        public void setChanged() {
            super.setChanged();
            ContainerEnchantTable.this.slotsChanged(this);
        }
    };
    private final ContainerAccess access;
    private final RandomSource random = RandomSource.create();
    private final ContainerProperty enchantmentSeed = ContainerProperty.standalone();
    public final int[] costs = new int[3];
    public final int[] enchantClue = new int[]{-1, -1, -1};
    public final int[] levelClue = new int[]{-1, -1, -1};

    public ContainerEnchantTable(int var0, PlayerInventory var1) {
        this(var0, var1, ContainerAccess.NULL);
    }

    public ContainerEnchantTable(int var0, PlayerInventory var1, ContainerAccess var2) {
        super(Containers.ENCHANTMENT, var0);
        int var3;
        this.access = var2;
        this.addSlot(new Slot(this, this.enchantSlots, 0, 15, 47){

            @Override
            public int getMaxStackSize() {
                return 1;
            }
        });
        this.addSlot(new Slot(this, this.enchantSlots, 1, 35, 47){

            @Override
            public boolean mayPlace(ItemStack var0) {
                return var0.is(Items.LAPIS_LAZULI);
            }

            @Override
            public Pair<MinecraftKey, MinecraftKey> getNoItemIcon() {
                return Pair.of((Object)ContainerPlayer.BLOCK_ATLAS, (Object)EMPTY_SLOT_LAPIS_LAZULI);
            }
        });
        for (var3 = 0; var3 < 3; ++var3) {
            for (int var4 = 0; var4 < 9; ++var4) {
                this.addSlot(new Slot(var1, var4 + var3 * 9 + 9, 8 + var4 * 18, 84 + var3 * 18));
            }
        }
        for (var3 = 0; var3 < 9; ++var3) {
            this.addSlot(new Slot(var1, var3, 8 + var3 * 18, 142));
        }
        this.addDataSlot(ContainerProperty.shared(this.costs, 0));
        this.addDataSlot(ContainerProperty.shared(this.costs, 1));
        this.addDataSlot(ContainerProperty.shared(this.costs, 2));
        this.addDataSlot(this.enchantmentSeed).set(var1.player.getEnchantmentSeed());
        this.addDataSlot(ContainerProperty.shared(this.enchantClue, 0));
        this.addDataSlot(ContainerProperty.shared(this.enchantClue, 1));
        this.addDataSlot(ContainerProperty.shared(this.enchantClue, 2));
        this.addDataSlot(ContainerProperty.shared(this.levelClue, 0));
        this.addDataSlot(ContainerProperty.shared(this.levelClue, 1));
        this.addDataSlot(ContainerProperty.shared(this.levelClue, 2));
    }

    @Override
    public void slotsChanged(IInventory var0) {
        if (var0 == this.enchantSlots) {
            ItemStack var12 = var0.getItem(0);
            if (var12.isEmpty() || !var12.isEnchantable()) {
                for (int var22 = 0; var22 < 3; ++var22) {
                    this.costs[var22] = 0;
                    this.enchantClue[var22] = -1;
                    this.levelClue[var22] = -1;
                }
            } else {
                this.access.execute((var1, var2) -> {
                    int var5;
                    Registry<Holder<Enchantment>> var3 = var1.registryAccess().registryOrThrow(Registries.ENCHANTMENT).asHolderIdMap();
                    int var4 = 0;
                    for (BlockPosition blockPosition : BlockEnchantmentTable.BOOKSHELF_OFFSETS) {
                        if (!BlockEnchantmentTable.isValidBookShelf(var1, var2, blockPosition)) continue;
                        ++var4;
                    }
                    this.random.setSeed(this.enchantmentSeed.get());
                    for (var5 = 0; var5 < 3; ++var5) {
                        this.costs[var5] = EnchantmentManager.getEnchantmentCost(this.random, var5, var4, var12);
                        this.enchantClue[var5] = -1;
                        this.levelClue[var5] = -1;
                        if (this.costs[var5] >= var5 + 1) continue;
                        this.costs[var5] = 0;
                    }
                    for (var5 = 0; var5 < 3; ++var5) {
                        List<WeightedRandomEnchant> list;
                        if (this.costs[var5] <= 0 || (list = this.getEnchantmentList(var1.registryAccess(), var12, var5, this.costs[var5])) == null || list.isEmpty()) continue;
                        WeightedRandomEnchant var7 = list.get(this.random.nextInt(list.size()));
                        this.enchantClue[var5] = var3.getId(var7.enchantment);
                        this.levelClue[var5] = var7.level;
                    }
                    this.broadcastChanges();
                });
            }
        }
    }

    @Override
    public boolean clickMenuButton(EntityHuman var0, int var1) {
        if (var1 < 0 || var1 >= this.costs.length) {
            SystemUtils.logAndPauseIfInIde(String.valueOf(var0.getName()) + " pressed invalid button id: " + var1);
            return false;
        }
        ItemStack var2 = this.enchantSlots.getItem(0);
        ItemStack var3 = this.enchantSlots.getItem(1);
        int var4 = var1 + 1;
        if ((var3.isEmpty() || var3.getCount() < var4) && !var0.hasInfiniteMaterials()) {
            return false;
        }
        if (this.costs[var1] > 0 && !var2.isEmpty() && (var0.experienceLevel >= var4 && var0.experienceLevel >= this.costs[var1] || var0.getAbilities().instabuild)) {
            this.access.execute((var5, var6) -> {
                ItemStack var7 = var2;
                List<WeightedRandomEnchant> var8 = this.getEnchantmentList(var5.registryAccess(), var7, var1, this.costs[var1]);
                if (!var8.isEmpty()) {
                    var0.onEnchantmentPerformed(var7, var4);
                    if (var7.is(Items.BOOK)) {
                        var7 = var2.transmuteCopy(Items.ENCHANTED_BOOK);
                        this.enchantSlots.setItem(0, var7);
                    }
                    for (WeightedRandomEnchant var10 : var8) {
                        var7.enchant(var10.enchantment, var10.level);
                    }
                    var3.consume(var4, var0);
                    if (var3.isEmpty()) {
                        this.enchantSlots.setItem(1, ItemStack.EMPTY);
                    }
                    var0.awardStat(StatisticList.ENCHANT_ITEM);
                    if (var0 instanceof EntityPlayer) {
                        CriterionTriggers.ENCHANTED_ITEM.trigger((EntityPlayer)var0, var7, var4);
                    }
                    this.enchantSlots.setChanged();
                    this.enchantmentSeed.set(var0.getEnchantmentSeed());
                    this.slotsChanged(this.enchantSlots);
                    var5.playSound(null, (BlockPosition)var6, SoundEffects.ENCHANTMENT_TABLE_USE, SoundCategory.BLOCKS, 1.0f, var5.random.nextFloat() * 0.1f + 0.9f);
                }
            });
            return true;
        }
        return false;
    }

    private List<WeightedRandomEnchant> getEnchantmentList(IRegistryCustom var0, ItemStack var1, int var2, int var3) {
        this.random.setSeed(this.enchantmentSeed.get() + var2);
        Optional<HolderSet.Named<Enchantment>> var4 = var0.registryOrThrow(Registries.ENCHANTMENT).getTag(EnchantmentTags.IN_ENCHANTING_TABLE);
        if (var4.isEmpty()) {
            return List.of();
        }
        List<WeightedRandomEnchant> var5 = EnchantmentManager.selectEnchantment(this.random, var1, var3, var4.get().stream());
        if (var1.is(Items.BOOK) && var5.size() > 1) {
            var5.remove(this.random.nextInt(var5.size()));
        }
        return var5;
    }

    public int getGoldCount() {
        ItemStack var0 = this.enchantSlots.getItem(1);
        if (var0.isEmpty()) {
            return 0;
        }
        return var0.getCount();
    }

    public int getEnchantmentSeed() {
        return this.enchantmentSeed.get();
    }

    @Override
    public void removed(EntityHuman var0) {
        super.removed(var0);
        this.access.execute((var1, var2) -> this.clearContainer(var0, this.enchantSlots));
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return ContainerEnchantTable.stillValid(this.access, var0, Blocks.ENCHANTING_TABLE);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman var0, int var1) {
        ItemStack var2 = ItemStack.EMPTY;
        Slot var3 = (Slot)this.slots.get(var1);
        if (var3 != null && var3.hasItem()) {
            ItemStack var4 = var3.getItem();
            var2 = var4.copy();
            if (var1 == 0) {
                if (!this.moveItemStackTo(var4, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (var1 == 1) {
                if (!this.moveItemStackTo(var4, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (var4.is(Items.LAPIS_LAZULI)) {
                if (!this.moveItemStackTo(var4, 1, 2, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (!((Slot)this.slots.get(0)).hasItem() && ((Slot)this.slots.get(0)).mayPlace(var4)) {
                ItemStack var5 = var4.copyWithCount(1);
                var4.shrink(1);
                ((Slot)this.slots.get(0)).setByPlayer(var5);
            } else {
                return ItemStack.EMPTY;
            }
            if (var4.isEmpty()) {
                var3.setByPlayer(ItemStack.EMPTY);
            } else {
                var3.setChanged();
            }
            if (var4.getCount() == var2.getCount()) {
                return ItemStack.EMPTY;
            }
            var3.onTake(var0, var4);
        }
        return var2;
    }
}

