/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.particles.Particles;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;

public abstract class EntityProjectile
extends IProjectile {
    protected EntityProjectile(EntityTypes<? extends EntityProjectile> var0, World var1) {
        super((EntityTypes<? extends IProjectile>)var0, var1);
    }

    protected EntityProjectile(EntityTypes<? extends EntityProjectile> var0, double var1, double var3, double var5, World var7) {
        this(var0, var7);
        this.setPos(var1, var3, var5);
    }

    protected EntityProjectile(EntityTypes<? extends EntityProjectile> var0, EntityLiving var1, World var2) {
        this(var0, var1.getX(), var1.getEyeY() - (double)0.1f, var1.getZ(), var2);
        this.setOwner(var1);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        double var2 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(var2)) {
            var2 = 4.0;
        }
        return var0 < (var2 *= 64.0) * var2;
    }

    @Override
    public boolean canUsePortal(boolean var0) {
        return true;
    }

    @Override
    public void tick() {
        float var8;
        super.tick();
        MovingObjectPosition var0 = ProjectileHelper.getHitResultOnMoveVector(this, this::canHitEntity);
        if (var0.getType() != MovingObjectPosition.EnumMovingObjectType.MISS) {
            this.hitTargetOrDeflectSelf(var0);
        }
        this.checkInsideBlocks();
        Vec3D var1 = this.getDeltaMovement();
        double var2 = this.getX() + var1.x;
        double var4 = this.getY() + var1.y;
        double var6 = this.getZ() + var1.z;
        this.updateRotation();
        if (this.isInWater()) {
            for (int var9 = 0; var9 < 4; ++var9) {
                float var10 = 0.25f;
                this.level().addParticle(Particles.BUBBLE, var2 - var1.x * 0.25, var4 - var1.y * 0.25, var6 - var1.z * 0.25, var1.x, var1.y, var1.z);
            }
            var8 = 0.8f;
        } else {
            var8 = 0.99f;
        }
        this.setDeltaMovement(var1.scale(var8));
        this.applyGravity();
        this.setPos(var2, var4, var6);
    }

    @Override
    protected double getDefaultGravity() {
        return 0.03;
    }
}

