/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.projectile.EntityProjectileThrowable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public class EntityEnderPearl
extends EntityProjectileThrowable {
    public EntityEnderPearl(EntityTypes<? extends EntityEnderPearl> var0, World var1) {
        super((EntityTypes<? extends EntityProjectileThrowable>)var0, var1);
    }

    public EntityEnderPearl(World var0, EntityLiving var1) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.ENDER_PEARL, var1, var0);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.ENDER_PEARL;
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        super.onHitEntity(var0);
        var0.getEntity().hurt(this.damageSources().thrown(this, this.getOwner()), 0.0f);
    }

    @Override
    protected void onHit(MovingObjectPosition var0) {
        WorldServer var1;
        block12: {
            block11: {
                super.onHit(var0);
                for (int var12 = 0; var12 < 32; ++var12) {
                    this.level().addParticle(Particles.PORTAL, this.getX(), this.getY() + this.random.nextDouble() * 2.0, this.getZ(), this.random.nextGaussian(), 0.0, this.random.nextGaussian());
                }
                World world = this.level();
                if (!(world instanceof WorldServer)) break block11;
                var1 = (WorldServer)world;
                if (!this.isRemoved()) break block12;
            }
            return;
        }
        Entity var2 = this.getOwner();
        if (var2 == null || !EntityEnderPearl.isAllowedToTeleportOwner(var2, var1)) {
            this.discard();
            return;
        }
        if (var2.isPassenger()) {
            var2.unRide();
        }
        if (var2 instanceof EntityPlayer) {
            EntityPlayer var3 = (EntityPlayer)var2;
            if (var3.connection.isAcceptingMessages()) {
                EntityEndermite var4;
                if (this.random.nextFloat() < 0.05f && var1.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && (var4 = EntityTypes.ENDERMITE.create(var1)) != null) {
                    var4.moveTo(var2.getX(), var2.getY(), var2.getZ(), var2.getYRot(), var2.getXRot());
                    var1.addFreshEntity(var4);
                }
                var2.changeDimension(new DimensionTransition(var1, this.position(), var2.getDeltaMovement(), var2.getYRot(), var2.getXRot(), DimensionTransition.DO_NOTHING));
                var2.resetFallDistance();
                var3.resetCurrentImpulseContext();
                var2.hurt(this.damageSources().fall(), 5.0f);
                this.playSound(var1, this.position());
            }
        } else {
            var2.changeDimension(new DimensionTransition(var1, this.position(), var2.getDeltaMovement(), var2.getYRot(), var2.getXRot(), DimensionTransition.DO_NOTHING));
            var2.resetFallDistance();
            this.playSound(var1, this.position());
        }
        this.discard();
    }

    private static boolean isAllowedToTeleportOwner(Entity var0, World var1) {
        if (var0.level().dimension() == var1.dimension()) {
            if (var0 instanceof EntityLiving) {
                EntityLiving var2 = (EntityLiving)var0;
                return var2.isAlive() && !var2.isSleeping();
            }
            return var0.isAlive();
        }
        return var0.canUsePortal(true);
    }

    @Override
    public void tick() {
        Entity var0 = this.getOwner();
        if (var0 instanceof EntityPlayer && !var0.isAlive() && this.level().getGameRules().getBoolean(GameRules.RULE_ENDER_PEARLS_VANISH_ON_DEATH)) {
            this.discard();
        } else {
            super.tick();
        }
    }

    private void playSound(World var0, Vec3D var1) {
        var0.playSound(null, var1.x, var1.y, var1.z, SoundEffects.PLAYER_TELEPORT, SoundCategory.PLAYERS);
    }

    @Override
    public boolean canChangeDimensions(World var0, World var1) {
        Entity entity;
        if (var0.dimension() == World.END && (entity = this.getOwner()) instanceof EntityPlayer) {
            EntityPlayer var2 = (EntityPlayer)entity;
            return super.canChangeDimensions(var0, var1) && var2.seenCredits;
        }
        return super.canChangeDimensions(var0, var1);
    }

    @Override
    protected void onInsideBlock(IBlockData var0) {
        Entity entity;
        super.onInsideBlock(var0);
        if (var0.is(Blocks.END_GATEWAY) && (entity = this.getOwner()) instanceof EntityPlayer) {
            EntityPlayer var1 = (EntityPlayer)entity;
            var1.onInsideBlock(var0);
        }
    }
}

