/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemEnchantedBook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.WeightedRandomEnchant;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.item.enchantment.providers.TradeRebalanceEnchantmentProviders;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import org.apache.commons.lang3.tuple.Pair;

public class VillagerTrades {
    private static final int DEFAULT_SUPPLY = 12;
    private static final int COMMON_ITEMS_SUPPLY = 16;
    private static final int UNCOMMON_ITEMS_SUPPLY = 3;
    private static final int XP_LEVEL_1_SELL = 1;
    private static final int XP_LEVEL_1_BUY = 2;
    private static final int XP_LEVEL_2_SELL = 5;
    private static final int XP_LEVEL_2_BUY = 10;
    private static final int XP_LEVEL_3_SELL = 10;
    private static final int XP_LEVEL_3_BUY = 20;
    private static final int XP_LEVEL_4_SELL = 15;
    private static final int XP_LEVEL_4_BUY = 30;
    private static final int XP_LEVEL_5_TRADE = 30;
    private static final float LOW_TIER_PRICE_MULTIPLIER = 0.05f;
    private static final float HIGH_TIER_PRICE_MULTIPLIER = 0.2f;
    public static final Map<VillagerProfession, Int2ObjectMap<IMerchantRecipeOption[]>> TRADES = SystemUtils.make(Maps.newHashMap(), var0 -> {
        var0.put(VillagerProfession.FARMER, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.WHEAT, 20, 16, 2), new b(Items.POTATO, 26, 16, 2), new b(Items.CARROT, 22, 16, 2), new b(Items.BEETROOT, 15, 16, 2), new i(Items.BREAD, 1, 6, 16, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Blocks.PUMPKIN, 6, 12, 10), new i(Items.PUMPKIN_PIE, 1, 4, 5), new i(Items.APPLE, 1, 4, 16, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new i(Items.COOKIE, 3, 18, 10), new b(Blocks.MELON, 4, 12, 20)}, (Object)4, (Object)new IMerchantRecipeOption[]{new i(Blocks.CAKE, 1, 1, 12, 15), new j(MobEffects.NIGHT_VISION, 100, 15), new j(MobEffects.JUMP, 160, 15), new j(MobEffects.WEAKNESS, 140, 15), new j(MobEffects.BLINDNESS, 120, 15), new j(MobEffects.POISON, 280, 15), new j(MobEffects.SATURATION, 7, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new i(Items.GOLDEN_CARROT, 3, 3, 30), new i(Items.GLISTERING_MELON_SLICE, 4, 3, 30)})));
        var0.put(VillagerProfession.FISHERMAN, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.STRING, 20, 16, 2), new b(Items.COAL, 10, 16, 2), new h((IMaterial)Items.COD, 6, 1, Items.COOKED_COD, 6, 16, 1, 0.05f), new i(Items.COD_BUCKET, 3, 1, 16, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.COD, 15, 16, 10), new h((IMaterial)Items.SALMON, 6, 1, Items.COOKED_SALMON, 6, 16, 5, 0.05f), new i(Items.CAMPFIRE, 2, 1, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.SALMON, 13, 16, 20), new e(Items.FISHING_ROD, 3, 3, 10, 0.2f)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.TROPICAL_FISH, 6, 12, 30)}, (Object)5, (Object)new IMerchantRecipeOption[]{new b(Items.PUFFERFISH, 4, 12, 30), new c(1, 12, 30, (Map<VillagerType, Item>)ImmutableMap.builder().put((Object)VillagerType.PLAINS, (Object)Items.OAK_BOAT).put((Object)VillagerType.TAIGA, (Object)Items.SPRUCE_BOAT).put((Object)VillagerType.SNOW, (Object)Items.SPRUCE_BOAT).put((Object)VillagerType.DESERT, (Object)Items.JUNGLE_BOAT).put((Object)VillagerType.JUNGLE, (Object)Items.JUNGLE_BOAT).put((Object)VillagerType.SAVANNA, (Object)Items.ACACIA_BOAT).put((Object)VillagerType.SWAMP, (Object)Items.DARK_OAK_BOAT).build())})));
        var0.put(VillagerProfession.SHEPHERD, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Blocks.WHITE_WOOL, 18, 16, 2), new b(Blocks.BROWN_WOOL, 18, 16, 2), new b(Blocks.BLACK_WOOL, 18, 16, 2), new b(Blocks.GRAY_WOOL, 18, 16, 2), new i(Items.SHEARS, 2, 1, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.WHITE_DYE, 12, 16, 10), new b(Items.GRAY_DYE, 12, 16, 10), new b(Items.BLACK_DYE, 12, 16, 10), new b(Items.LIGHT_BLUE_DYE, 12, 16, 10), new b(Items.LIME_DYE, 12, 16, 10), new i(Blocks.WHITE_WOOL, 1, 1, 16, 5), new i(Blocks.ORANGE_WOOL, 1, 1, 16, 5), new i(Blocks.MAGENTA_WOOL, 1, 1, 16, 5), new i(Blocks.LIGHT_BLUE_WOOL, 1, 1, 16, 5), new i(Blocks.YELLOW_WOOL, 1, 1, 16, 5), new i(Blocks.LIME_WOOL, 1, 1, 16, 5), new i(Blocks.PINK_WOOL, 1, 1, 16, 5), new i(Blocks.GRAY_WOOL, 1, 1, 16, 5), new i(Blocks.LIGHT_GRAY_WOOL, 1, 1, 16, 5), new i(Blocks.CYAN_WOOL, 1, 1, 16, 5), new i(Blocks.PURPLE_WOOL, 1, 1, 16, 5), new i(Blocks.BLUE_WOOL, 1, 1, 16, 5), new i(Blocks.BROWN_WOOL, 1, 1, 16, 5), new i(Blocks.GREEN_WOOL, 1, 1, 16, 5), new i(Blocks.RED_WOOL, 1, 1, 16, 5), new i(Blocks.BLACK_WOOL, 1, 1, 16, 5), new i(Blocks.WHITE_CARPET, 1, 4, 16, 5), new i(Blocks.ORANGE_CARPET, 1, 4, 16, 5), new i(Blocks.MAGENTA_CARPET, 1, 4, 16, 5), new i(Blocks.LIGHT_BLUE_CARPET, 1, 4, 16, 5), new i(Blocks.YELLOW_CARPET, 1, 4, 16, 5), new i(Blocks.LIME_CARPET, 1, 4, 16, 5), new i(Blocks.PINK_CARPET, 1, 4, 16, 5), new i(Blocks.GRAY_CARPET, 1, 4, 16, 5), new i(Blocks.LIGHT_GRAY_CARPET, 1, 4, 16, 5), new i(Blocks.CYAN_CARPET, 1, 4, 16, 5), new i(Blocks.PURPLE_CARPET, 1, 4, 16, 5), new i(Blocks.BLUE_CARPET, 1, 4, 16, 5), new i(Blocks.BROWN_CARPET, 1, 4, 16, 5), new i(Blocks.GREEN_CARPET, 1, 4, 16, 5), new i(Blocks.RED_CARPET, 1, 4, 16, 5), new i(Blocks.BLACK_CARPET, 1, 4, 16, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.YELLOW_DYE, 12, 16, 20), new b(Items.LIGHT_GRAY_DYE, 12, 16, 20), new b(Items.ORANGE_DYE, 12, 16, 20), new b(Items.RED_DYE, 12, 16, 20), new b(Items.PINK_DYE, 12, 16, 20), new i(Blocks.WHITE_BED, 3, 1, 12, 10), new i(Blocks.YELLOW_BED, 3, 1, 12, 10), new i(Blocks.RED_BED, 3, 1, 12, 10), new i(Blocks.BLACK_BED, 3, 1, 12, 10), new i(Blocks.BLUE_BED, 3, 1, 12, 10), new i(Blocks.BROWN_BED, 3, 1, 12, 10), new i(Blocks.CYAN_BED, 3, 1, 12, 10), new i(Blocks.GRAY_BED, 3, 1, 12, 10), new i(Blocks.GREEN_BED, 3, 1, 12, 10), new i(Blocks.LIGHT_BLUE_BED, 3, 1, 12, 10), new i(Blocks.LIGHT_GRAY_BED, 3, 1, 12, 10), new i(Blocks.LIME_BED, 3, 1, 12, 10), new i(Blocks.MAGENTA_BED, 3, 1, 12, 10), new i(Blocks.ORANGE_BED, 3, 1, 12, 10), new i(Blocks.PINK_BED, 3, 1, 12, 10), new i(Blocks.PURPLE_BED, 3, 1, 12, 10)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.BROWN_DYE, 12, 16, 30), new b(Items.PURPLE_DYE, 12, 16, 30), new b(Items.BLUE_DYE, 12, 16, 30), new b(Items.GREEN_DYE, 12, 16, 30), new b(Items.MAGENTA_DYE, 12, 16, 30), new b(Items.CYAN_DYE, 12, 16, 30), new i(Items.WHITE_BANNER, 3, 1, 12, 15), new i(Items.BLUE_BANNER, 3, 1, 12, 15), new i(Items.LIGHT_BLUE_BANNER, 3, 1, 12, 15), new i(Items.RED_BANNER, 3, 1, 12, 15), new i(Items.PINK_BANNER, 3, 1, 12, 15), new i(Items.GREEN_BANNER, 3, 1, 12, 15), new i(Items.LIME_BANNER, 3, 1, 12, 15), new i(Items.GRAY_BANNER, 3, 1, 12, 15), new i(Items.BLACK_BANNER, 3, 1, 12, 15), new i(Items.PURPLE_BANNER, 3, 1, 12, 15), new i(Items.MAGENTA_BANNER, 3, 1, 12, 15), new i(Items.CYAN_BANNER, 3, 1, 12, 15), new i(Items.BROWN_BANNER, 3, 1, 12, 15), new i(Items.YELLOW_BANNER, 3, 1, 12, 15), new i(Items.ORANGE_BANNER, 3, 1, 12, 15), new i(Items.LIGHT_GRAY_BANNER, 3, 1, 12, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new i(Items.PAINTING, 2, 3, 30)})));
        var0.put(VillagerProfession.FLETCHER, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.STICK, 32, 16, 2), new i(Items.ARROW, 1, 16, 1), new h((IMaterial)Blocks.GRAVEL, 10, 1, Items.FLINT, 10, 12, 1, 0.05f)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.FLINT, 26, 12, 10), new i(Items.BOW, 2, 1, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.STRING, 14, 16, 20), new i(Items.CROSSBOW, 3, 1, 10)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.FEATHER, 24, 16, 30), new e(Items.BOW, 2, 3, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new b(Items.TRIPWIRE_HOOK, 8, 12, 30), new e(Items.CROSSBOW, 3, 3, 15), new k(Items.ARROW, 5, Items.TIPPED_ARROW, 5, 2, 12, 30)})));
        var0.put(VillagerProfession.LIBRARIAN, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.builder().put((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.PAPER, 24, 16, 2), new d(1, EnchantmentTags.TRADEABLE), new i(Blocks.BOOKSHELF, 9, 1, 12, 1)}).put((Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.BOOK, 4, 12, 10), new d(5, EnchantmentTags.TRADEABLE), new i(Items.LANTERN, 1, 1, 5)}).put((Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.INK_SAC, 5, 12, 20), new d(10, EnchantmentTags.TRADEABLE), new i(Items.GLASS, 1, 4, 10)}).put((Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.WRITABLE_BOOK, 2, 12, 30), new d(15, EnchantmentTags.TRADEABLE), new i(Items.CLOCK, 5, 1, 15), new i(Items.COMPASS, 4, 1, 15)}).put((Object)5, (Object)new IMerchantRecipeOption[]{new i(Items.NAME_TAG, 20, 1, 30)}).build()));
        var0.put(VillagerProfession.CARTOGRAPHER, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.PAPER, 24, 16, 2), new i(Items.MAP, 7, 1, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.GLASS_PANE, 11, 16, 10), new l(13, StructureTags.ON_OCEAN_EXPLORER_MAPS, "filled_map.monument", MapDecorationTypes.OCEAN_MONUMENT, 12, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.COMPASS, 1, 12, 20), new l(14, StructureTags.ON_WOODLAND_EXPLORER_MAPS, "filled_map.mansion", MapDecorationTypes.WOODLAND_MANSION, 12, 10), new l(12, StructureTags.ON_TRIAL_CHAMBERS_MAPS, "filled_map.trial_chambers", MapDecorationTypes.TRIAL_CHAMBERS, 12, 10)}, (Object)4, (Object)new IMerchantRecipeOption[]{new i(Items.ITEM_FRAME, 7, 1, 15), new i(Items.WHITE_BANNER, 3, 1, 15), new i(Items.BLUE_BANNER, 3, 1, 15), new i(Items.LIGHT_BLUE_BANNER, 3, 1, 15), new i(Items.RED_BANNER, 3, 1, 15), new i(Items.PINK_BANNER, 3, 1, 15), new i(Items.GREEN_BANNER, 3, 1, 15), new i(Items.LIME_BANNER, 3, 1, 15), new i(Items.GRAY_BANNER, 3, 1, 15), new i(Items.BLACK_BANNER, 3, 1, 15), new i(Items.PURPLE_BANNER, 3, 1, 15), new i(Items.MAGENTA_BANNER, 3, 1, 15), new i(Items.CYAN_BANNER, 3, 1, 15), new i(Items.BROWN_BANNER, 3, 1, 15), new i(Items.YELLOW_BANNER, 3, 1, 15), new i(Items.ORANGE_BANNER, 3, 1, 15), new i(Items.LIGHT_GRAY_BANNER, 3, 1, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new i(Items.GLOBE_BANNER_PATTERN, 8, 1, 30)})));
        var0.put(VillagerProfession.CLERIC, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.ROTTEN_FLESH, 32, 16, 2), new i(Items.REDSTONE, 1, 2, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.GOLD_INGOT, 3, 12, 10), new i(Items.LAPIS_LAZULI, 1, 1, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.RABBIT_FOOT, 2, 12, 20), new i(Blocks.GLOWSTONE, 4, 1, 12, 10)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.TURTLE_SCUTE, 4, 12, 30), new b(Items.GLASS_BOTTLE, 9, 12, 30), new i(Items.ENDER_PEARL, 5, 1, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new b(Items.NETHER_WART, 22, 12, 30), new i(Items.EXPERIENCE_BOTTLE, 3, 1, 30)})));
        var0.put(VillagerProfession.ARMORER, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.COAL, 15, 16, 2), new i(new ItemStack(Items.IRON_LEGGINGS), 7, 1, 12, 1, 0.2f), new i(new ItemStack(Items.IRON_BOOTS), 4, 1, 12, 1, 0.2f), new i(new ItemStack(Items.IRON_HELMET), 5, 1, 12, 1, 0.2f), new i(new ItemStack(Items.IRON_CHESTPLATE), 9, 1, 12, 1, 0.2f)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.IRON_INGOT, 4, 12, 10), new i(new ItemStack(Items.BELL), 36, 1, 12, 5, 0.2f), new i(new ItemStack(Items.CHAINMAIL_BOOTS), 1, 1, 12, 5, 0.2f), new i(new ItemStack(Items.CHAINMAIL_LEGGINGS), 3, 1, 12, 5, 0.2f)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.LAVA_BUCKET, 1, 12, 20), new b(Items.DIAMOND, 1, 12, 20), new i(new ItemStack(Items.CHAINMAIL_HELMET), 1, 1, 12, 10, 0.2f), new i(new ItemStack(Items.CHAINMAIL_CHESTPLATE), 4, 1, 12, 10, 0.2f), new i(new ItemStack(Items.SHIELD), 5, 1, 12, 10, 0.2f)}, (Object)4, (Object)new IMerchantRecipeOption[]{new e(Items.DIAMOND_LEGGINGS, 14, 3, 15, 0.2f), new e(Items.DIAMOND_BOOTS, 8, 3, 15, 0.2f)}, (Object)5, (Object)new IMerchantRecipeOption[]{new e(Items.DIAMOND_HELMET, 8, 3, 30, 0.2f), new e(Items.DIAMOND_CHESTPLATE, 16, 3, 30, 0.2f)})));
        var0.put(VillagerProfession.WEAPONSMITH, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.COAL, 15, 16, 2), new i(new ItemStack(Items.IRON_AXE), 3, 1, 12, 1, 0.2f), new e(Items.IRON_SWORD, 2, 3, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.IRON_INGOT, 4, 12, 10), new i(new ItemStack(Items.BELL), 36, 1, 12, 5, 0.2f)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.FLINT, 24, 12, 20)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.DIAMOND, 1, 12, 30), new e(Items.DIAMOND_AXE, 12, 3, 15, 0.2f)}, (Object)5, (Object)new IMerchantRecipeOption[]{new e(Items.DIAMOND_SWORD, 8, 3, 30, 0.2f)})));
        var0.put(VillagerProfession.TOOLSMITH, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.COAL, 15, 16, 2), new i(new ItemStack(Items.STONE_AXE), 1, 1, 12, 1, 0.2f), new i(new ItemStack(Items.STONE_SHOVEL), 1, 1, 12, 1, 0.2f), new i(new ItemStack(Items.STONE_PICKAXE), 1, 1, 12, 1, 0.2f), new i(new ItemStack(Items.STONE_HOE), 1, 1, 12, 1, 0.2f)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.IRON_INGOT, 4, 12, 10), new i(new ItemStack(Items.BELL), 36, 1, 12, 5, 0.2f)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.FLINT, 30, 12, 20), new e(Items.IRON_AXE, 1, 3, 10, 0.2f), new e(Items.IRON_SHOVEL, 2, 3, 10, 0.2f), new e(Items.IRON_PICKAXE, 3, 3, 10, 0.2f), new i(new ItemStack(Items.DIAMOND_HOE), 4, 1, 3, 10, 0.2f)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.DIAMOND, 1, 12, 30), new e(Items.DIAMOND_AXE, 12, 3, 15, 0.2f), new e(Items.DIAMOND_SHOVEL, 5, 3, 15, 0.2f)}, (Object)5, (Object)new IMerchantRecipeOption[]{new e(Items.DIAMOND_PICKAXE, 13, 3, 30, 0.2f)})));
        var0.put(VillagerProfession.BUTCHER, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.CHICKEN, 14, 16, 2), new b(Items.PORKCHOP, 7, 16, 2), new b(Items.RABBIT, 4, 16, 2), new i(Items.RABBIT_STEW, 1, 1, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.COAL, 15, 16, 2), new i(Items.COOKED_PORKCHOP, 1, 5, 16, 5), new i(Items.COOKED_CHICKEN, 1, 8, 16, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.MUTTON, 7, 16, 20), new b(Items.BEEF, 10, 16, 20)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.DRIED_KELP_BLOCK, 10, 12, 30)}, (Object)5, (Object)new IMerchantRecipeOption[]{new b(Items.SWEET_BERRIES, 10, 12, 30)})));
        var0.put(VillagerProfession.LEATHERWORKER, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.LEATHER, 6, 16, 2), new a(Items.LEATHER_LEGGINGS, 3), new a(Items.LEATHER_CHESTPLATE, 7)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.FLINT, 26, 12, 10), new a(Items.LEATHER_HELMET, 5, 12, 5), new a(Items.LEATHER_BOOTS, 4, 12, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.RABBIT_HIDE, 9, 12, 20), new a(Items.LEATHER_CHESTPLATE, 7)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.TURTLE_SCUTE, 4, 12, 30), new a(Items.LEATHER_HORSE_ARMOR, 6, 12, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new i(new ItemStack(Items.SADDLE), 6, 1, 12, 30, 0.2f), new a(Items.LEATHER_HELMET, 5, 12, 30)})));
        var0.put(VillagerProfession.MASON, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.CLAY_BALL, 10, 16, 2), new i(Items.BRICK, 1, 10, 16, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Blocks.STONE, 20, 16, 10), new i(Blocks.CHISELED_STONE_BRICKS, 1, 4, 16, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Blocks.GRANITE, 16, 16, 20), new b(Blocks.ANDESITE, 16, 16, 20), new b(Blocks.DIORITE, 16, 16, 20), new i(Blocks.DRIPSTONE_BLOCK, 1, 4, 16, 10), new i(Blocks.POLISHED_ANDESITE, 1, 4, 16, 10), new i(Blocks.POLISHED_DIORITE, 1, 4, 16, 10), new i(Blocks.POLISHED_GRANITE, 1, 4, 16, 10)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.QUARTZ, 12, 12, 30), new i(Blocks.ORANGE_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.WHITE_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.BLUE_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.LIGHT_BLUE_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.GRAY_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.LIGHT_GRAY_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.BLACK_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.RED_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.PINK_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.MAGENTA_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.LIME_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.GREEN_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.CYAN_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.PURPLE_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.YELLOW_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.BROWN_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.ORANGE_GLAZED_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.WHITE_GLAZED_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.BLUE_GLAZED_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.LIGHT_BLUE_GLAZED_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.GRAY_GLAZED_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.LIGHT_GRAY_GLAZED_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.BLACK_GLAZED_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.RED_GLAZED_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.PINK_GLAZED_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.MAGENTA_GLAZED_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.LIME_GLAZED_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.GREEN_GLAZED_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.CYAN_GLAZED_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.PURPLE_GLAZED_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.YELLOW_GLAZED_TERRACOTTA, 1, 1, 12, 15), new i(Blocks.BROWN_GLAZED_TERRACOTTA, 1, 1, 12, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new i(Blocks.QUARTZ_PILLAR, 1, 1, 12, 30), new i(Blocks.QUARTZ_BLOCK, 1, 1, 12, 30)})));
    });
    public static final Int2ObjectMap<IMerchantRecipeOption[]> WANDERING_TRADER_TRADES = VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new i(Items.SEA_PICKLE, 2, 1, 5, 1), new i(Items.SLIME_BALL, 4, 1, 5, 1), new i(Items.GLOWSTONE, 2, 1, 5, 1), new i(Items.NAUTILUS_SHELL, 5, 1, 5, 1), new i(Items.FERN, 1, 1, 12, 1), new i(Items.SUGAR_CANE, 1, 1, 8, 1), new i(Items.PUMPKIN, 1, 1, 4, 1), new i(Items.KELP, 3, 1, 12, 1), new i(Items.CACTUS, 3, 1, 8, 1), new i(Items.DANDELION, 1, 1, 12, 1), new i(Items.POPPY, 1, 1, 12, 1), new i(Items.BLUE_ORCHID, 1, 1, 8, 1), new i(Items.ALLIUM, 1, 1, 12, 1), new i(Items.AZURE_BLUET, 1, 1, 12, 1), new i(Items.RED_TULIP, 1, 1, 12, 1), new i(Items.ORANGE_TULIP, 1, 1, 12, 1), new i(Items.WHITE_TULIP, 1, 1, 12, 1), new i(Items.PINK_TULIP, 1, 1, 12, 1), new i(Items.OXEYE_DAISY, 1, 1, 12, 1), new i(Items.CORNFLOWER, 1, 1, 12, 1), new i(Items.LILY_OF_THE_VALLEY, 1, 1, 7, 1), new i(Items.WHEAT_SEEDS, 1, 1, 12, 1), new i(Items.BEETROOT_SEEDS, 1, 1, 12, 1), new i(Items.PUMPKIN_SEEDS, 1, 1, 12, 1), new i(Items.MELON_SEEDS, 1, 1, 12, 1), new i(Items.ACACIA_SAPLING, 5, 1, 8, 1), new i(Items.BIRCH_SAPLING, 5, 1, 8, 1), new i(Items.DARK_OAK_SAPLING, 5, 1, 8, 1), new i(Items.JUNGLE_SAPLING, 5, 1, 8, 1), new i(Items.OAK_SAPLING, 5, 1, 8, 1), new i(Items.SPRUCE_SAPLING, 5, 1, 8, 1), new i(Items.CHERRY_SAPLING, 5, 1, 8, 1), new i(Items.MANGROVE_PROPAGULE, 5, 1, 8, 1), new i(Items.RED_DYE, 1, 3, 12, 1), new i(Items.WHITE_DYE, 1, 3, 12, 1), new i(Items.BLUE_DYE, 1, 3, 12, 1), new i(Items.PINK_DYE, 1, 3, 12, 1), new i(Items.BLACK_DYE, 1, 3, 12, 1), new i(Items.GREEN_DYE, 1, 3, 12, 1), new i(Items.LIGHT_GRAY_DYE, 1, 3, 12, 1), new i(Items.MAGENTA_DYE, 1, 3, 12, 1), new i(Items.YELLOW_DYE, 1, 3, 12, 1), new i(Items.GRAY_DYE, 1, 3, 12, 1), new i(Items.PURPLE_DYE, 1, 3, 12, 1), new i(Items.LIGHT_BLUE_DYE, 1, 3, 12, 1), new i(Items.LIME_DYE, 1, 3, 12, 1), new i(Items.ORANGE_DYE, 1, 3, 12, 1), new i(Items.BROWN_DYE, 1, 3, 12, 1), new i(Items.CYAN_DYE, 1, 3, 12, 1), new i(Items.BRAIN_CORAL_BLOCK, 3, 1, 8, 1), new i(Items.BUBBLE_CORAL_BLOCK, 3, 1, 8, 1), new i(Items.FIRE_CORAL_BLOCK, 3, 1, 8, 1), new i(Items.HORN_CORAL_BLOCK, 3, 1, 8, 1), new i(Items.TUBE_CORAL_BLOCK, 3, 1, 8, 1), new i(Items.VINE, 1, 1, 12, 1), new i(Items.BROWN_MUSHROOM, 1, 1, 12, 1), new i(Items.RED_MUSHROOM, 1, 1, 12, 1), new i(Items.LILY_PAD, 1, 2, 5, 1), new i(Items.SMALL_DRIPLEAF, 1, 2, 5, 1), new i(Items.SAND, 1, 8, 8, 1), new i(Items.RED_SAND, 1, 4, 6, 1), new i(Items.POINTED_DRIPSTONE, 1, 2, 5, 1), new i(Items.ROOTED_DIRT, 1, 2, 5, 1), new i(Items.MOSS_BLOCK, 1, 2, 5, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new i(Items.TROPICAL_FISH_BUCKET, 5, 1, 4, 1), new i(Items.PUFFERFISH_BUCKET, 5, 1, 4, 1), new i(Items.PACKED_ICE, 3, 1, 6, 1), new i(Items.BLUE_ICE, 6, 1, 6, 1), new i(Items.GUNPOWDER, 1, 1, 8, 1), new i(Items.PODZOL, 3, 3, 6, 1)}));
    private static final l DESERT_MAP = new l(8, StructureTags.ON_DESERT_VILLAGE_MAPS, "filled_map.village_desert", MapDecorationTypes.DESERT_VILLAGE, 12, 5);
    private static final l SAVANNA_MAP = new l(8, StructureTags.ON_SAVANNA_VILLAGE_MAPS, "filled_map.village_savanna", MapDecorationTypes.SAVANNA_VILLAGE, 12, 5);
    private static final l PLAINS_MAP = new l(8, StructureTags.ON_PLAINS_VILLAGE_MAPS, "filled_map.village_plains", MapDecorationTypes.PLAINS_VILLAGE, 12, 5);
    private static final l TAIGA_MAP = new l(8, StructureTags.ON_TAIGA_VILLAGE_MAPS, "filled_map.village_taiga", MapDecorationTypes.TAIGA_VILLAGE, 12, 5);
    private static final l SNOWY_MAP = new l(8, StructureTags.ON_SNOWY_VILLAGE_MAPS, "filled_map.village_snowy", MapDecorationTypes.SNOWY_VILLAGE, 12, 5);
    private static final l JUNGLE_MAP = new l(8, StructureTags.ON_JUNGLE_EXPLORER_MAPS, "filled_map.explorer_jungle", MapDecorationTypes.JUNGLE_TEMPLE, 12, 5);
    private static final l SWAMP_MAP = new l(8, StructureTags.ON_SWAMP_EXPLORER_MAPS, "filled_map.explorer_swamp", MapDecorationTypes.SWAMP_HUT, 12, 5);
    public static final Map<VillagerProfession, Int2ObjectMap<IMerchantRecipeOption[]>> EXPERIMENTAL_TRADES = Map.of(VillagerProfession.LIBRARIAN, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.builder().put((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.PAPER, 24, 16, 2), VillagerTrades.commonBooks(1), new i(Blocks.BOOKSHELF, 9, 1, 12, 1)}).put((Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.BOOK, 4, 12, 10), VillagerTrades.commonBooks(5), new i(Items.LANTERN, 1, 1, 5)}).put((Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.INK_SAC, 5, 12, 20), VillagerTrades.commonBooks(10), new i(Items.GLASS, 1, 4, 10)}).put((Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.WRITABLE_BOOK, 2, 12, 30), new i(Items.CLOCK, 5, 1, 15), new i(Items.COMPASS, 4, 1, 15)}).put((Object)5, (Object)new IMerchantRecipeOption[]{VillagerTrades.specialBooks(), new i(Items.NAME_TAG, 20, 1, 30)}).build()), VillagerProfession.ARMORER, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.builder().put((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.COAL, 15, 12, 2), new b(Items.IRON_INGOT, 5, 12, 2)}).put((Object)2, (Object)new IMerchantRecipeOption[]{m.oneTradeInBiomes(new i(Items.IRON_BOOTS, 4, 1, 12, 5, 0.05f), VillagerType.DESERT, VillagerType.PLAINS, VillagerType.SAVANNA, VillagerType.SNOW, VillagerType.TAIGA), m.oneTradeInBiomes(new i(Items.CHAINMAIL_BOOTS, 4, 1, 12, 5, 0.05f), VillagerType.JUNGLE, VillagerType.SWAMP), m.oneTradeInBiomes(new i(Items.IRON_HELMET, 5, 1, 12, 5, 0.05f), VillagerType.DESERT, VillagerType.PLAINS, VillagerType.SAVANNA, VillagerType.SNOW, VillagerType.TAIGA), m.oneTradeInBiomes(new i(Items.CHAINMAIL_HELMET, 5, 1, 12, 5, 0.05f), VillagerType.JUNGLE, VillagerType.SWAMP), m.oneTradeInBiomes(new i(Items.IRON_LEGGINGS, 7, 1, 12, 5, 0.05f), VillagerType.DESERT, VillagerType.PLAINS, VillagerType.SAVANNA, VillagerType.SNOW, VillagerType.TAIGA), m.oneTradeInBiomes(new i(Items.CHAINMAIL_LEGGINGS, 7, 1, 12, 5, 0.05f), VillagerType.JUNGLE, VillagerType.SWAMP), m.oneTradeInBiomes(new i(Items.IRON_CHESTPLATE, 9, 1, 12, 5, 0.05f), VillagerType.DESERT, VillagerType.PLAINS, VillagerType.SAVANNA, VillagerType.SNOW, VillagerType.TAIGA), m.oneTradeInBiomes(new i(Items.CHAINMAIL_CHESTPLATE, 9, 1, 12, 5, 0.05f), VillagerType.JUNGLE, VillagerType.SWAMP)}).put((Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.LAVA_BUCKET, 1, 12, 20), new i(Items.SHIELD, 5, 1, 12, 10, 0.05f), new i(Items.BELL, 36, 1, 12, 10, 0.2f)}).put((Object)4, (Object)new IMerchantRecipeOption[]{m.oneTradeInBiomes(new i(Items.IRON_BOOTS, 8, 1, 3, 15, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_DESERT_ARMORER_BOOTS_4), VillagerType.DESERT), m.oneTradeInBiomes(new i(Items.IRON_HELMET, 9, 1, 3, 15, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_DESERT_ARMORER_HELMET_4), VillagerType.DESERT), m.oneTradeInBiomes(new i(Items.IRON_LEGGINGS, 11, 1, 3, 15, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_DESERT_ARMORER_LEGGINGS_4), VillagerType.DESERT), m.oneTradeInBiomes(new i(Items.IRON_CHESTPLATE, 13, 1, 3, 15, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_DESERT_ARMORER_CHESTPLATE_4), VillagerType.DESERT), m.oneTradeInBiomes(new i(Items.IRON_BOOTS, 8, 1, 3, 15, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_PLAINS_ARMORER_BOOTS_4), VillagerType.PLAINS), m.oneTradeInBiomes(new i(Items.IRON_HELMET, 9, 1, 3, 15, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_PLAINS_ARMORER_HELMET_4), VillagerType.PLAINS), m.oneTradeInBiomes(new i(Items.IRON_LEGGINGS, 11, 1, 3, 15, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_PLAINS_ARMORER_LEGGINGS_4), VillagerType.PLAINS), m.oneTradeInBiomes(new i(Items.IRON_CHESTPLATE, 13, 1, 3, 15, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_PLAINS_ARMORER_CHESTPLATE_4), VillagerType.PLAINS), m.oneTradeInBiomes(new i(Items.IRON_BOOTS, 2, 1, 3, 15, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_SAVANNA_ARMORER_BOOTS_4), VillagerType.SAVANNA), m.oneTradeInBiomes(new i(Items.IRON_HELMET, 3, 1, 3, 15, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_SAVANNA_ARMORER_HELMET_4), VillagerType.SAVANNA), m.oneTradeInBiomes(new i(Items.IRON_LEGGINGS, 5, 1, 3, 15, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_SAVANNA_ARMORER_LEGGINGS_4), VillagerType.SAVANNA), m.oneTradeInBiomes(new i(Items.IRON_CHESTPLATE, 7, 1, 3, 15, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_SAVANNA_ARMORER_CHESTPLATE_4), VillagerType.SAVANNA), m.oneTradeInBiomes(new i(Items.IRON_BOOTS, 8, 1, 3, 15, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_SNOW_ARMORER_BOOTS_4), VillagerType.SNOW), m.oneTradeInBiomes(new i(Items.IRON_HELMET, 9, 1, 3, 15, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_SNOW_ARMORER_HELMET_4), VillagerType.SNOW), m.oneTradeInBiomes(new i(Items.CHAINMAIL_BOOTS, 8, 1, 3, 15, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_JUNGLE_ARMORER_BOOTS_4), VillagerType.JUNGLE), m.oneTradeInBiomes(new i(Items.CHAINMAIL_HELMET, 9, 1, 3, 15, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_JUNGLE_ARMORER_HELMET_4), VillagerType.JUNGLE), m.oneTradeInBiomes(new i(Items.CHAINMAIL_LEGGINGS, 11, 1, 3, 15, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_JUNGLE_ARMORER_LEGGINGS_4), VillagerType.JUNGLE), m.oneTradeInBiomes(new i(Items.CHAINMAIL_CHESTPLATE, 13, 1, 3, 15, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_JUNGLE_ARMORER_CHESTPLATE_4), VillagerType.JUNGLE), m.oneTradeInBiomes(new i(Items.CHAINMAIL_BOOTS, 8, 1, 3, 15, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_SWAMP_ARMORER_BOOTS_4), VillagerType.SWAMP), m.oneTradeInBiomes(new i(Items.CHAINMAIL_HELMET, 9, 1, 3, 15, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_SWAMP_ARMORER_HELMET_4), VillagerType.SWAMP), m.oneTradeInBiomes(new i(Items.CHAINMAIL_LEGGINGS, 11, 1, 3, 15, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_SWAMP_ARMORER_LEGGINGS_4), VillagerType.SWAMP), m.oneTradeInBiomes(new i(Items.CHAINMAIL_CHESTPLATE, 13, 1, 3, 15, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_SWAMP_ARMORER_CHESTPLATE_4), VillagerType.SWAMP), m.oneTradeInBiomes(new h((IMaterial)Items.DIAMOND_BOOTS, 1, 4, Items.DIAMOND_LEGGINGS, 1, 3, 15, 0.05f), VillagerType.TAIGA), m.oneTradeInBiomes(new h((IMaterial)Items.DIAMOND_LEGGINGS, 1, 4, Items.DIAMOND_CHESTPLATE, 1, 3, 15, 0.05f), VillagerType.TAIGA), m.oneTradeInBiomes(new h((IMaterial)Items.DIAMOND_HELMET, 1, 4, Items.DIAMOND_BOOTS, 1, 3, 15, 0.05f), VillagerType.TAIGA), m.oneTradeInBiomes(new h((IMaterial)Items.DIAMOND_CHESTPLATE, 1, 2, Items.DIAMOND_HELMET, 1, 3, 15, 0.05f), VillagerType.TAIGA)}).put((Object)5, (Object)new IMerchantRecipeOption[]{m.oneTradeInBiomes(new h(Items.DIAMOND, 4, 16, Items.DIAMOND_CHESTPLATE, 1, 3, 30, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_DESERT_ARMORER_CHESTPLATE_5), VillagerType.DESERT), m.oneTradeInBiomes(new h(Items.DIAMOND, 3, 16, Items.DIAMOND_LEGGINGS, 1, 3, 30, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_DESERT_ARMORER_LEGGINGS_5), VillagerType.DESERT), m.oneTradeInBiomes(new h(Items.DIAMOND, 3, 16, Items.DIAMOND_LEGGINGS, 1, 3, 30, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_PLAINS_ARMORER_LEGGINGS_5), VillagerType.PLAINS), m.oneTradeInBiomes(new h(Items.DIAMOND, 2, 12, Items.DIAMOND_BOOTS, 1, 3, 30, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_PLAINS_ARMORER_BOOTS_5), VillagerType.PLAINS), m.oneTradeInBiomes(new h(Items.DIAMOND, 2, 6, Items.DIAMOND_HELMET, 1, 3, 30, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_SAVANNA_ARMORER_HELMET_5), VillagerType.SAVANNA), m.oneTradeInBiomes(new h(Items.DIAMOND, 3, 8, Items.DIAMOND_CHESTPLATE, 1, 3, 30, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_SAVANNA_ARMORER_CHESTPLATE_5), VillagerType.SAVANNA), m.oneTradeInBiomes(new h(Items.DIAMOND, 2, 12, Items.DIAMOND_BOOTS, 1, 3, 30, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_SNOW_ARMORER_BOOTS_5), VillagerType.SNOW), m.oneTradeInBiomes(new h(Items.DIAMOND, 3, 12, Items.DIAMOND_HELMET, 1, 3, 30, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_SNOW_ARMORER_HELMET_5), VillagerType.SNOW), m.oneTradeInBiomes(new i(Items.CHAINMAIL_HELMET, 9, 1, 3, 30, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_JUNGLE_ARMORER_HELMET_5), VillagerType.JUNGLE), m.oneTradeInBiomes(new i(Items.CHAINMAIL_BOOTS, 8, 1, 3, 30, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_JUNGLE_ARMORER_BOOTS_5), VillagerType.JUNGLE), m.oneTradeInBiomes(new i(Items.CHAINMAIL_HELMET, 9, 1, 3, 30, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_SWAMP_ARMORER_HELMET_5), VillagerType.SWAMP), m.oneTradeInBiomes(new i(Items.CHAINMAIL_BOOTS, 8, 1, 3, 30, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_SWAMP_ARMORER_BOOTS_5), VillagerType.SWAMP), m.oneTradeInBiomes(new h(Items.DIAMOND, 4, 18, Items.DIAMOND_CHESTPLATE, 1, 3, 30, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_TAIGA_ARMORER_CHESTPLATE_5), VillagerType.TAIGA), m.oneTradeInBiomes(new h(Items.DIAMOND, 3, 18, Items.DIAMOND_LEGGINGS, 1, 3, 30, 0.05f, TradeRebalanceEnchantmentProviders.TRADES_TAIGA_ARMORER_LEGGINGS_5), VillagerType.TAIGA), m.oneTradeInBiomes(new b(Items.DIAMOND_BLOCK, 1, 12, 30, 42), VillagerType.TAIGA), m.oneTradeInBiomes(new b(Items.IRON_BLOCK, 1, 12, 30, 4), VillagerType.DESERT, VillagerType.JUNGLE, VillagerType.PLAINS, VillagerType.SAVANNA, VillagerType.SNOW, VillagerType.SWAMP)}).build()), VillagerProfession.CARTOGRAPHER, VillagerTrades.toIntMap((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.PAPER, 24, 16, 2), new i(Items.MAP, 7, 1, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.GLASS_PANE, 11, 16, 10), new m((Map<VillagerType, IMerchantRecipeOption>)ImmutableMap.builder().put((Object)VillagerType.DESERT, (Object)SAVANNA_MAP).put((Object)VillagerType.SAVANNA, (Object)PLAINS_MAP).put((Object)VillagerType.PLAINS, (Object)TAIGA_MAP).put((Object)VillagerType.TAIGA, (Object)SNOWY_MAP).put((Object)VillagerType.SNOW, (Object)PLAINS_MAP).put((Object)VillagerType.JUNGLE, (Object)SAVANNA_MAP).put((Object)VillagerType.SWAMP, (Object)SNOWY_MAP).build()), new m((Map<VillagerType, IMerchantRecipeOption>)ImmutableMap.builder().put((Object)VillagerType.DESERT, (Object)PLAINS_MAP).put((Object)VillagerType.SAVANNA, (Object)DESERT_MAP).put((Object)VillagerType.PLAINS, (Object)SAVANNA_MAP).put((Object)VillagerType.TAIGA, (Object)PLAINS_MAP).put((Object)VillagerType.SNOW, (Object)TAIGA_MAP).put((Object)VillagerType.JUNGLE, (Object)DESERT_MAP).put((Object)VillagerType.SWAMP, (Object)TAIGA_MAP).build()), new m((Map<VillagerType, IMerchantRecipeOption>)ImmutableMap.builder().put((Object)VillagerType.DESERT, (Object)JUNGLE_MAP).put((Object)VillagerType.SAVANNA, (Object)JUNGLE_MAP).put((Object)VillagerType.PLAINS, (Object)new f()).put((Object)VillagerType.TAIGA, (Object)SWAMP_MAP).put((Object)VillagerType.SNOW, (Object)SWAMP_MAP).put((Object)VillagerType.JUNGLE, (Object)SWAMP_MAP).put((Object)VillagerType.SWAMP, (Object)JUNGLE_MAP).build())}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.COMPASS, 1, 12, 20), new l(13, StructureTags.ON_OCEAN_EXPLORER_MAPS, "filled_map.monument", MapDecorationTypes.OCEAN_MONUMENT, 12, 10), new l(12, StructureTags.ON_TRIAL_CHAMBERS_MAPS, "filled_map.trial_chambers", MapDecorationTypes.TRIAL_CHAMBERS, 12, 10)}, (Object)4, (Object)new IMerchantRecipeOption[]{new i(Items.ITEM_FRAME, 7, 1, 15), new i(Items.WHITE_BANNER, 3, 1, 15), new i(Items.BLUE_BANNER, 3, 1, 15), new i(Items.LIGHT_BLUE_BANNER, 3, 1, 15), new i(Items.RED_BANNER, 3, 1, 15), new i(Items.PINK_BANNER, 3, 1, 15), new i(Items.GREEN_BANNER, 3, 1, 15), new i(Items.LIME_BANNER, 3, 1, 15), new i(Items.GRAY_BANNER, 3, 1, 15), new i(Items.BLACK_BANNER, 3, 1, 15), new i(Items.PURPLE_BANNER, 3, 1, 15), new i(Items.MAGENTA_BANNER, 3, 1, 15), new i(Items.CYAN_BANNER, 3, 1, 15), new i(Items.BROWN_BANNER, 3, 1, 15), new i(Items.YELLOW_BANNER, 3, 1, 15), new i(Items.ORANGE_BANNER, 3, 1, 15), new i(Items.LIGHT_GRAY_BANNER, 3, 1, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new i(Items.GLOBE_BANNER_PATTERN, 8, 1, 30), new l(14, StructureTags.ON_WOODLAND_EXPLORER_MAPS, "filled_map.mansion", MapDecorationTypes.WOODLAND_MANSION, 1, 30)})));
    public static final List<Pair<IMerchantRecipeOption[], Integer>> EXPERIMENTAL_WANDERING_TRADER_TRADES = ImmutableList.builder().add((Object)Pair.of((Object)new IMerchantRecipeOption[]{new b(VillagerTrades.potionCost(Potions.WATER), 1, 1, 1), new b(Items.WATER_BUCKET, 1, 1, 1, 2), new b(Items.MILK_BUCKET, 1, 1, 1, 2), new b(Items.FERMENTED_SPIDER_EYE, 1, 1, 1, 3), new b(Items.BAKED_POTATO, 4, 1, 1), new b(Items.HAY_BLOCK, 1, 1, 1)}, (Object)2)).add((Object)Pair.of((Object)new IMerchantRecipeOption[]{new i(Items.PACKED_ICE, 1, 1, 6, 1), new i(Items.BLUE_ICE, 6, 1, 6, 1), new i(Items.GUNPOWDER, 1, 4, 2, 1), new i(Items.PODZOL, 3, 3, 6, 1), new i(Blocks.ACACIA_LOG, 1, 8, 4, 1), new i(Blocks.BIRCH_LOG, 1, 8, 4, 1), new i(Blocks.DARK_OAK_LOG, 1, 8, 4, 1), new i(Blocks.JUNGLE_LOG, 1, 8, 4, 1), new i(Blocks.OAK_LOG, 1, 8, 4, 1), new i(Blocks.SPRUCE_LOG, 1, 8, 4, 1), new i(Blocks.CHERRY_LOG, 1, 8, 4, 1), new e(Items.IRON_PICKAXE, 1, 1, 1, 0.2f), new i(VillagerTrades.potion(Potions.LONG_INVISIBILITY), 5, 1, 1, 1)}, (Object)2)).add((Object)Pair.of((Object)new IMerchantRecipeOption[]{new i(Items.TROPICAL_FISH_BUCKET, 3, 1, 4, 1), new i(Items.PUFFERFISH_BUCKET, 3, 1, 4, 1), new i(Items.SEA_PICKLE, 2, 1, 5, 1), new i(Items.SLIME_BALL, 4, 1, 5, 1), new i(Items.GLOWSTONE, 2, 1, 5, 1), new i(Items.NAUTILUS_SHELL, 5, 1, 5, 1), new i(Items.FERN, 1, 1, 12, 1), new i(Items.SUGAR_CANE, 1, 1, 8, 1), new i(Items.PUMPKIN, 1, 1, 4, 1), new i(Items.KELP, 3, 1, 12, 1), new i(Items.CACTUS, 3, 1, 8, 1), new i(Items.DANDELION, 1, 1, 12, 1), new i(Items.POPPY, 1, 1, 12, 1), new i(Items.BLUE_ORCHID, 1, 1, 8, 1), new i(Items.ALLIUM, 1, 1, 12, 1), new i(Items.AZURE_BLUET, 1, 1, 12, 1), new i(Items.RED_TULIP, 1, 1, 12, 1), new i(Items.ORANGE_TULIP, 1, 1, 12, 1), new i(Items.WHITE_TULIP, 1, 1, 12, 1), new i(Items.PINK_TULIP, 1, 1, 12, 1), new i(Items.OXEYE_DAISY, 1, 1, 12, 1), new i(Items.CORNFLOWER, 1, 1, 12, 1), new i(Items.LILY_OF_THE_VALLEY, 1, 1, 7, 1), new i(Items.WHEAT_SEEDS, 1, 1, 12, 1), new i(Items.BEETROOT_SEEDS, 1, 1, 12, 1), new i(Items.PUMPKIN_SEEDS, 1, 1, 12, 1), new i(Items.MELON_SEEDS, 1, 1, 12, 1), new i(Items.ACACIA_SAPLING, 5, 1, 8, 1), new i(Items.BIRCH_SAPLING, 5, 1, 8, 1), new i(Items.DARK_OAK_SAPLING, 5, 1, 8, 1), new i(Items.JUNGLE_SAPLING, 5, 1, 8, 1), new i(Items.OAK_SAPLING, 5, 1, 8, 1), new i(Items.SPRUCE_SAPLING, 5, 1, 8, 1), new i(Items.CHERRY_SAPLING, 5, 1, 8, 1), new i(Items.MANGROVE_PROPAGULE, 5, 1, 8, 1), new i(Items.RED_DYE, 1, 3, 12, 1), new i(Items.WHITE_DYE, 1, 3, 12, 1), new i(Items.BLUE_DYE, 1, 3, 12, 1), new i(Items.PINK_DYE, 1, 3, 12, 1), new i(Items.BLACK_DYE, 1, 3, 12, 1), new i(Items.GREEN_DYE, 1, 3, 12, 1), new i(Items.LIGHT_GRAY_DYE, 1, 3, 12, 1), new i(Items.MAGENTA_DYE, 1, 3, 12, 1), new i(Items.YELLOW_DYE, 1, 3, 12, 1), new i(Items.GRAY_DYE, 1, 3, 12, 1), new i(Items.PURPLE_DYE, 1, 3, 12, 1), new i(Items.LIGHT_BLUE_DYE, 1, 3, 12, 1), new i(Items.LIME_DYE, 1, 3, 12, 1), new i(Items.ORANGE_DYE, 1, 3, 12, 1), new i(Items.BROWN_DYE, 1, 3, 12, 1), new i(Items.CYAN_DYE, 1, 3, 12, 1), new i(Items.BRAIN_CORAL_BLOCK, 3, 1, 8, 1), new i(Items.BUBBLE_CORAL_BLOCK, 3, 1, 8, 1), new i(Items.FIRE_CORAL_BLOCK, 3, 1, 8, 1), new i(Items.HORN_CORAL_BLOCK, 3, 1, 8, 1), new i(Items.TUBE_CORAL_BLOCK, 3, 1, 8, 1), new i(Items.VINE, 1, 3, 4, 1), new i(Items.BROWN_MUSHROOM, 1, 3, 4, 1), new i(Items.RED_MUSHROOM, 1, 3, 4, 1), new i(Items.LILY_PAD, 1, 5, 2, 1), new i(Items.SMALL_DRIPLEAF, 1, 2, 5, 1), new i(Items.SAND, 1, 8, 8, 1), new i(Items.RED_SAND, 1, 4, 6, 1), new i(Items.POINTED_DRIPSTONE, 1, 2, 5, 1), new i(Items.ROOTED_DIRT, 1, 2, 5, 1), new i(Items.MOSS_BLOCK, 1, 2, 5, 1)}, (Object)5)).build();

    private static IMerchantRecipeOption commonBooks(int var0) {
        return new m((Map<VillagerType, IMerchantRecipeOption>)ImmutableMap.builder().put((Object)VillagerType.DESERT, (Object)new d(var0, EnchantmentTags.TRADES_DESERT_COMMON)).put((Object)VillagerType.JUNGLE, (Object)new d(var0, EnchantmentTags.TRADES_JUNGLE_COMMON)).put((Object)VillagerType.PLAINS, (Object)new d(var0, EnchantmentTags.TRADES_PLAINS_COMMON)).put((Object)VillagerType.SAVANNA, (Object)new d(var0, EnchantmentTags.TRADES_SAVANNA_COMMON)).put((Object)VillagerType.SNOW, (Object)new d(var0, EnchantmentTags.TRADES_SNOW_COMMON)).put((Object)VillagerType.SWAMP, (Object)new d(var0, EnchantmentTags.TRADES_SWAMP_COMMON)).put((Object)VillagerType.TAIGA, (Object)new d(var0, EnchantmentTags.TRADES_TAIGA_COMMON)).build());
    }

    private static IMerchantRecipeOption specialBooks() {
        return new m((Map<VillagerType, IMerchantRecipeOption>)ImmutableMap.builder().put((Object)VillagerType.DESERT, (Object)new d(30, 3, 3, EnchantmentTags.TRADES_DESERT_SPECIAL)).put((Object)VillagerType.JUNGLE, (Object)new d(30, 2, 2, EnchantmentTags.TRADES_JUNGLE_SPECIAL)).put((Object)VillagerType.PLAINS, (Object)new d(30, 3, 3, EnchantmentTags.TRADES_PLAINS_SPECIAL)).put((Object)VillagerType.SAVANNA, (Object)new d(30, 3, 3, EnchantmentTags.TRADES_SAVANNA_SPECIAL)).put((Object)VillagerType.SNOW, (Object)new d(30, EnchantmentTags.TRADES_SNOW_SPECIAL)).put((Object)VillagerType.SWAMP, (Object)new d(30, EnchantmentTags.TRADES_SWAMP_SPECIAL)).put((Object)VillagerType.TAIGA, (Object)new d(30, 2, 2, EnchantmentTags.TRADES_TAIGA_SPECIAL)).build());
    }

    private static Int2ObjectMap<IMerchantRecipeOption[]> toIntMap(ImmutableMap<Integer, IMerchantRecipeOption[]> var0) {
        return new Int2ObjectOpenHashMap(var0);
    }

    private static ItemCost potionCost(Holder<PotionRegistry> var0) {
        return new ItemCost(Items.POTION).withComponents(var1 -> var1.expect(DataComponents.POTION_CONTENTS, new PotionContents(var0)));
    }

    private static ItemStack potion(Holder<PotionRegistry> var0) {
        return PotionContents.createItemStack(Items.POTION, var0);
    }

    record m(Map<VillagerType, IMerchantRecipeOption> trades) implements IMerchantRecipeOption
    {
        public static m oneTradeInBiomes(IMerchantRecipeOption var02, VillagerType ... var12) {
            return new m(Arrays.stream(var12).collect(Collectors.toMap(var0 -> var0, var1 -> var02)));
        }

        @Override
        @Nullable
        public MerchantRecipe getOffer(Entity var0, RandomSource var1) {
            if (var0 instanceof VillagerDataHolder) {
                VillagerDataHolder var2 = (VillagerDataHolder)((Object)var0);
                VillagerType var3 = var2.getVillagerData().getType();
                IMerchantRecipeOption var4 = this.trades.get(var3);
                if (var4 == null) {
                    return null;
                }
                return var4.getOffer(var0, var1);
            }
            return null;
        }
    }

    static class d
    implements IMerchantRecipeOption {
        private final int villagerXp;
        private final TagKey<Enchantment> tradeableEnchantments;
        private final int minLevel;
        private final int maxLevel;

        public d(int var0, TagKey<Enchantment> var1) {
            this(var0, 0, Integer.MAX_VALUE, var1);
        }

        public d(int var0, int var1, int var2, TagKey<Enchantment> var3) {
            this.minLevel = var1;
            this.maxLevel = var2;
            this.villagerXp = var0;
            this.tradeableEnchantments = var3;
        }

        @Override
        public MerchantRecipe getOffer(Entity var0, RandomSource var1) {
            int var3;
            ItemStack var4;
            Optional<Holder<Enchantment>> var2 = var0.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getRandomElementOf(this.tradeableEnchantments, var1);
            if (!var2.isEmpty()) {
                Holder<Enchantment> var5 = var2.get();
                Enchantment var6 = var5.value();
                int var7 = Math.max(var6.getMinLevel(), this.minLevel);
                int var8 = Math.min(var6.getMaxLevel(), this.maxLevel);
                int var9 = MathHelper.nextInt(var1, var7, var8);
                var4 = ItemEnchantedBook.createForEnchantment(new WeightedRandomEnchant(var5, var9));
                var3 = 2 + var1.nextInt(5 + var9 * 10) + 3 * var9;
                if (var5.is(EnchantmentTags.DOUBLE_TRADE_PRICE)) {
                    var3 *= 2;
                }
                if (var3 > 64) {
                    var3 = 64;
                }
            } else {
                var3 = 1;
                var4 = new ItemStack(Items.BOOK);
            }
            return new MerchantRecipe(new ItemCost(Items.EMERALD, var3), Optional.of(new ItemCost(Items.BOOK)), var4, 12, this.villagerXp, 0.2f);
        }
    }

    public static interface IMerchantRecipeOption {
        @Nullable
        public MerchantRecipe getOffer(Entity var1, RandomSource var2);
    }

    static class b
    implements IMerchantRecipeOption {
        private final ItemCost itemStack;
        private final int maxUses;
        private final int villagerXp;
        private final int emeraldAmount;
        private final float priceMultiplier;

        public b(IMaterial var0, int var1, int var2, int var3) {
            this(var0, var1, var2, var3, 1);
        }

        public b(IMaterial var0, int var1, int var2, int var3, int var4) {
            this(new ItemCost(var0.asItem(), var1), var2, var3, var4);
        }

        public b(ItemCost var0, int var1, int var2, int var3) {
            this.itemStack = var0;
            this.maxUses = var1;
            this.villagerXp = var2;
            this.emeraldAmount = var3;
            this.priceMultiplier = 0.05f;
        }

        @Override
        public MerchantRecipe getOffer(Entity var0, RandomSource var1) {
            return new MerchantRecipe(this.itemStack, new ItemStack(Items.EMERALD, this.emeraldAmount), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    static class i
    implements IMerchantRecipeOption {
        private final ItemStack itemStack;
        private final int emeraldCost;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;
        private final Optional<ResourceKey<EnchantmentProvider>> enchantmentProvider;

        public i(Block var0, int var1, int var2, int var3, int var4) {
            this(new ItemStack(var0), var1, var2, var3, var4);
        }

        public i(Item var0, int var1, int var2, int var3) {
            this(new ItemStack(var0), var1, var2, 12, var3);
        }

        public i(Item var0, int var1, int var2, int var3, int var4) {
            this(new ItemStack(var0), var1, var2, var3, var4);
        }

        public i(ItemStack var0, int var1, int var2, int var3, int var4) {
            this(var0, var1, var2, var3, var4, 0.05f);
        }

        public i(Item var0, int var1, int var2, int var3, int var4, float var5) {
            this(new ItemStack(var0), var1, var2, var3, var4, var5);
        }

        public i(Item var0, int var1, int var2, int var3, int var4, float var5, ResourceKey<EnchantmentProvider> var6) {
            this(new ItemStack(var0), var1, var2, var3, var4, var5, Optional.of(var6));
        }

        public i(ItemStack var0, int var1, int var2, int var3, int var4, float var5) {
            this(var0, var1, var2, var3, var4, var5, Optional.empty());
        }

        public i(ItemStack var0, int var1, int var2, int var3, int var4, float var5, Optional<ResourceKey<EnchantmentProvider>> var6) {
            this.itemStack = var0;
            this.emeraldCost = var1;
            this.itemStack.setCount(var2);
            this.maxUses = var3;
            this.villagerXp = var4;
            this.priceMultiplier = var5;
            this.enchantmentProvider = var6;
        }

        @Override
        public MerchantRecipe getOffer(Entity var0, RandomSource var1) {
            ItemStack var2 = this.itemStack.copy();
            World var3 = var0.level();
            this.enchantmentProvider.ifPresent(var4 -> EnchantmentManager.enchantItemFromProvider(var2, var3.registryAccess(), var4, var3.getCurrentDifficultyAt(var0.blockPosition()), var1));
            return new MerchantRecipe(new ItemCost(Items.EMERALD, this.emeraldCost), var2, this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    static class j
    implements IMerchantRecipeOption {
        private final SuspiciousStewEffects effects;
        private final int xp;
        private final float priceMultiplier;

        public j(Holder<MobEffectList> var0, int var1, int var2) {
            this(new SuspiciousStewEffects(List.of(new SuspiciousStewEffects.a(var0, var1))), var2, 0.05f);
        }

        public j(SuspiciousStewEffects var0, int var1, float var2) {
            this.effects = var0;
            this.xp = var1;
            this.priceMultiplier = var2;
        }

        @Override
        @Nullable
        public MerchantRecipe getOffer(Entity var0, RandomSource var1) {
            ItemStack var2 = new ItemStack(Items.SUSPICIOUS_STEW, 1);
            var2.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, this.effects);
            return new MerchantRecipe(new ItemCost(Items.EMERALD), var2, 12, this.xp, this.priceMultiplier);
        }
    }

    static class h
    implements IMerchantRecipeOption {
        private final ItemCost fromItem;
        private final int emeraldCost;
        private final ItemStack toItem;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;
        private final Optional<ResourceKey<EnchantmentProvider>> enchantmentProvider;

        public h(IMaterial var0, int var1, int var2, Item var3, int var4, int var5, int var6, float var7) {
            this(var0, var1, var2, new ItemStack(var3), var4, var5, var6, var7);
        }

        private h(IMaterial var0, int var1, int var2, ItemStack var3, int var4, int var5, int var6, float var7) {
            this(new ItemCost(var0, var1), var2, var3.copyWithCount(var4), var5, var6, var7, Optional.empty());
        }

        h(IMaterial var0, int var1, int var2, IMaterial var3, int var4, int var5, int var6, float var7, ResourceKey<EnchantmentProvider> var8) {
            this(new ItemCost(var0, var1), var2, new ItemStack(var3, var4), var5, var6, var7, Optional.of(var8));
        }

        public h(ItemCost var0, int var1, ItemStack var2, int var3, int var4, float var5, Optional<ResourceKey<EnchantmentProvider>> var6) {
            this.fromItem = var0;
            this.emeraldCost = var1;
            this.toItem = var2;
            this.maxUses = var3;
            this.villagerXp = var4;
            this.priceMultiplier = var5;
            this.enchantmentProvider = var6;
        }

        @Override
        @Nullable
        public MerchantRecipe getOffer(Entity var0, RandomSource var1) {
            ItemStack var2 = this.toItem.copy();
            World var3 = var0.level();
            this.enchantmentProvider.ifPresent(var4 -> EnchantmentManager.enchantItemFromProvider(var2, var3.registryAccess(), var4, var3.getCurrentDifficultyAt(var0.blockPosition()), var1));
            return new MerchantRecipe(new ItemCost(Items.EMERALD, this.emeraldCost), Optional.of(this.fromItem), var2, 0, this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    static class e
    implements IMerchantRecipeOption {
        private final ItemStack itemStack;
        private final int baseEmeraldCost;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public e(Item var0, int var1, int var2, int var3) {
            this(var0, var1, var2, var3, 0.05f);
        }

        public e(Item var0, int var1, int var2, int var3, float var4) {
            this.itemStack = new ItemStack(var0);
            this.baseEmeraldCost = var1;
            this.maxUses = var2;
            this.villagerXp = var3;
            this.priceMultiplier = var4;
        }

        @Override
        public MerchantRecipe getOffer(Entity var0, RandomSource var1) {
            int var2 = 5 + var1.nextInt(15);
            IRegistryCustom var3 = var0.level().registryAccess();
            Optional<HolderSet.Named<Enchantment>> var4 = var3.registryOrThrow(Registries.ENCHANTMENT).getTag(EnchantmentTags.ON_TRADED_EQUIPMENT);
            ItemStack var5 = EnchantmentManager.enchantItem(var1, new ItemStack(this.itemStack.getItem()), var2, var3, var4);
            int var6 = Math.min(this.baseEmeraldCost + var2, 64);
            ItemCost var7 = new ItemCost(Items.EMERALD, var6);
            return new MerchantRecipe(var7, var5, this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    static class c
    implements IMerchantRecipeOption {
        private final Map<VillagerType, Item> trades;
        private final int cost;
        private final int maxUses;
        private final int villagerXp;

        public c(int var02, int var12, int var2, Map<VillagerType, Item> var3) {
            BuiltInRegistries.VILLAGER_TYPE.stream().filter(var1 -> !var3.containsKey(var1)).findAny().ifPresent(var0 -> {
                throw new IllegalStateException("Missing trade for villager type: " + String.valueOf(BuiltInRegistries.VILLAGER_TYPE.getKey((VillagerType)var0)));
            });
            this.trades = var3;
            this.cost = var02;
            this.maxUses = var12;
            this.villagerXp = var2;
        }

        @Override
        @Nullable
        public MerchantRecipe getOffer(Entity var0, RandomSource var1) {
            if (var0 instanceof VillagerDataHolder) {
                VillagerDataHolder var2 = (VillagerDataHolder)((Object)var0);
                ItemCost var3 = new ItemCost(this.trades.get(var2.getVillagerData().getType()), this.cost);
                return new MerchantRecipe(var3, new ItemStack(Items.EMERALD), this.maxUses, this.villagerXp, 0.05f);
            }
            return null;
        }
    }

    static class k
    implements IMerchantRecipeOption {
        private final ItemStack toItem;
        private final int toCount;
        private final int emeraldCost;
        private final int maxUses;
        private final int villagerXp;
        private final Item fromItem;
        private final int fromCount;
        private final float priceMultiplier;

        public k(Item var0, int var1, Item var2, int var3, int var4, int var5, int var6) {
            this.toItem = new ItemStack(var2);
            this.emeraldCost = var4;
            this.maxUses = var5;
            this.villagerXp = var6;
            this.fromItem = var0;
            this.fromCount = var1;
            this.toCount = var3;
            this.priceMultiplier = 0.05f;
        }

        @Override
        public MerchantRecipe getOffer(Entity var0, RandomSource var12) {
            ItemCost var2 = new ItemCost(Items.EMERALD, this.emeraldCost);
            List var3 = BuiltInRegistries.POTION.holders().filter(var1 -> !((PotionRegistry)var1.value()).getEffects().isEmpty() && var0.level().potionBrewing().isBrewablePotion((Holder<PotionRegistry>)var1)).collect(Collectors.toList());
            Holder var4 = (Holder)SystemUtils.getRandom(var3, var12);
            ItemStack var5 = new ItemStack(this.toItem.getItem(), this.toCount);
            var5.set(DataComponents.POTION_CONTENTS, new PotionContents(var4));
            return new MerchantRecipe(var2, Optional.of(new ItemCost(this.fromItem, this.fromCount)), var5, this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    static class l
    implements IMerchantRecipeOption {
        private final int emeraldCost;
        private final TagKey<Structure> destination;
        private final String displayName;
        private final Holder<MapDecorationType> destinationType;
        private final int maxUses;
        private final int villagerXp;

        public l(int var0, TagKey<Structure> var1, String var2, Holder<MapDecorationType> var3, int var4, int var5) {
            this.emeraldCost = var0;
            this.destination = var1;
            this.displayName = var2;
            this.destinationType = var3;
            this.maxUses = var4;
            this.villagerXp = var5;
        }

        @Override
        @Nullable
        public MerchantRecipe getOffer(Entity var0, RandomSource var1) {
            if (!(var0.level() instanceof WorldServer)) {
                return null;
            }
            WorldServer var2 = (WorldServer)var0.level();
            BlockPosition var3 = var2.findNearestMapStructure(this.destination, var0.blockPosition(), 100, true);
            if (var3 != null) {
                ItemStack var4 = ItemWorldMap.create(var2, var3.getX(), var3.getZ(), (byte)2, true, true);
                ItemWorldMap.renderBiomePreviewMap(var2, var4);
                WorldMap.addTargetDecoration(var4, var3, "+", this.destinationType);
                var4.set(DataComponents.ITEM_NAME, IChatBaseComponent.translatable(this.displayName));
                return new MerchantRecipe(new ItemCost(Items.EMERALD, this.emeraldCost), Optional.of(new ItemCost(Items.COMPASS)), var4, this.maxUses, this.villagerXp, 0.2f);
            }
            return null;
        }
    }

    static class a
    implements IMerchantRecipeOption {
        private final Item item;
        private final int value;
        private final int maxUses;
        private final int villagerXp;

        public a(Item var0, int var1) {
            this(var0, var1, 12, 1);
        }

        public a(Item var0, int var1, int var2, int var3) {
            this.item = var0;
            this.value = var1;
            this.maxUses = var2;
            this.villagerXp = var3;
        }

        @Override
        public MerchantRecipe getOffer(Entity var0, RandomSource var1) {
            ItemCost var2 = new ItemCost(Items.EMERALD, this.value);
            ItemStack var3 = new ItemStack(this.item);
            if (var3.is(TagsItem.DYEABLE)) {
                ArrayList var4 = Lists.newArrayList();
                var4.add(a.getRandomDye(var1));
                if (var1.nextFloat() > 0.7f) {
                    var4.add(a.getRandomDye(var1));
                }
                if (var1.nextFloat() > 0.8f) {
                    var4.add(a.getRandomDye(var1));
                }
                var3 = DyedItemColor.applyDyes(var3, var4);
            }
            return new MerchantRecipe(var2, var3, this.maxUses, this.villagerXp, 0.2f);
        }

        private static ItemDye getRandomDye(RandomSource var0) {
            return ItemDye.byColor(EnumColor.byId(var0.nextInt(16)));
        }
    }

    static class f
    implements IMerchantRecipeOption {
        f() {
        }

        @Override
        public MerchantRecipe getOffer(Entity var0, RandomSource var1) {
            return null;
        }
    }
}

