/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon.phases;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.AbstractDragonController;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.phys.Vec3D;

public class DragonControllerLandingFly
extends AbstractDragonController {
    private static final PathfinderTargetCondition NEAR_EGG_TARGETING = PathfinderTargetCondition.forCombat().ignoreLineOfSight();
    @Nullable
    private PathEntity currentPath;
    @Nullable
    private Vec3D targetLocation;

    public DragonControllerLandingFly(EntityEnderDragon var0) {
        super(var0);
    }

    public DragonControllerPhase<DragonControllerLandingFly> getPhase() {
        return DragonControllerPhase.LANDING_APPROACH;
    }

    @Override
    public void begin() {
        this.currentPath = null;
        this.targetLocation = null;
    }

    @Override
    public void doServerTick() {
        double var0;
        double d2 = var0 = this.targetLocation == null ? 0.0 : this.targetLocation.distanceToSqr(this.dragon.getX(), this.dragon.getY(), this.dragon.getZ());
        if (var0 < 100.0 || var0 > 22500.0 || this.dragon.horizontalCollision || this.dragon.verticalCollision) {
            this.findNewTarget();
        }
    }

    @Override
    @Nullable
    public Vec3D getFlyTargetLocation() {
        return this.targetLocation;
    }

    private void findNewTarget() {
        if (this.currentPath == null || this.currentPath.isDone()) {
            int var3;
            Object var4;
            int var0 = this.dragon.findClosestNode();
            BlockPosition var1 = this.dragon.level().getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, WorldGenEndTrophy.getLocation(this.dragon.getFightOrigin()));
            EntityHuman var2 = this.dragon.level().getNearestPlayer(NEAR_EGG_TARGETING, this.dragon, (double)var1.getX(), (double)var1.getY(), var1.getZ());
            if (var2 != null) {
                var4 = new Vec3D(var2.getX(), 0.0, var2.getZ()).normalize();
                var3 = this.dragon.findClosestNode(-((Vec3D)var4).x * 40.0, 105.0, -((Vec3D)var4).z * 40.0);
            } else {
                var3 = this.dragon.findClosestNode(40.0, var1.getY(), 0.0);
            }
            var4 = new PathPoint(var1.getX(), var1.getY(), var1.getZ());
            this.currentPath = this.dragon.findPath(var0, var3, (PathPoint)var4);
            if (this.currentPath != null) {
                this.currentPath.advance();
            }
        }
        this.navigateToNextPathNode();
        if (this.currentPath != null && this.currentPath.isDone()) {
            this.dragon.getPhaseManager().setPhase(DragonControllerPhase.LANDING);
        }
    }

    private void navigateToNextPathNode() {
        if (this.currentPath != null && !this.currentPath.isDone()) {
            double var5;
            BlockPosition var0 = this.currentPath.getNextNodePos();
            this.currentPath.advance();
            double var1 = var0.getX();
            double var3 = var0.getZ();
            while ((var5 = (double)((float)var0.getY() + this.dragon.getRandom().nextFloat() * 20.0f)) < (double)var0.getY()) {
            }
            this.targetLocation = new Vec3D(var1, var5, var3);
        }
    }
}

